/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.dmz.mergequeue.PullRequestMergeService;
import com.atlassian.bitbucket.dmz.pull.automerge.AutoMergeBulkCancelledEvent;
import com.atlassian.bitbucket.event.pull.PullRequestActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestAutoMergeCancelledEvent;
import com.atlassian.bitbucket.event.pull.PullRequestAutoMergeRequestedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVetoedException;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.automerge.AutoMergeNotRequestedException;
import com.atlassian.bitbucket.pull.automerge.AutoMergeProcessingResult;
import com.atlassian.bitbucket.pull.automerge.AutoMergeRequest;
import com.atlassian.bitbucket.pull.automerge.AutoMergeService;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingNotEnabledException;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeStrategyException;
import com.atlassian.bitbucket.scm.git.command.merge.GitUnsupportedMergeStrategyException;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.pull.InternalMergeRequest;
import com.atlassian.stash.internal.pull.InternalMergeRequestCheckService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestAutoMergeCancelledActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipantHelper;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.SimpleMergeRequest;
import com.atlassian.stash.internal.pull.automerge.AutoMergeFailedException;
import com.atlassian.stash.internal.pull.automerge.AutoMergeRequestDao;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeRequest;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=AutoMergeService.class)
@RequireFeature(value=StandardFeature.PULL_REQUEST_AUTO_MERGE)
@Service(value="autoMergeService")
public class DefaultAutoMergeService
implements InternalAutoMergeService {
    @VisibleForTesting
    static final int BULK_DELETE_BATCH_SIZE = 100;
    @VisibleForTesting
    static final Duration LOCK_ACQUIRE_TIMEOUT = Duration.ofSeconds(30L);
    @VisibleForTesting
    static final String LOCK_PREFIX = "pull.request.auto.merge.";
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoMergeService.class);
    private final PullRequestActivityDao activityDao;
    private final AuthenticationContext authenticationContext;
    private final AutoMergeRequestDao autoMergeRequestDao;
    private final AutoMergeSettingsService autoMergeSettingsService;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final LockService lockService;
    private final Duration maxRequestLifetime;
    private final Duration mergeabilityCheckTimeout;
    private final MergeQueueService mergeQueueService;
    private final InternalMergeRequestCheckService mergeRequestCheckService;
    private final InternalPullRequestParticipantHelper participantHelper;
    private final PermissionService permissionService;
    private final PullRequestMergeService pullRequestMergeService;
    private final InternalPullRequestService pullRequestService;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    @Autowired
    public DefaultAutoMergeService(@DurationUnit(value=ChronoUnit.DAYS) @Value(value="${pullrequest.auto.merge.request.max.lifetime}") Duration maxRequestLifetime, @DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${pullrequest.auto.merge.request.mergeabilityCheck.timeout}") Duration mergeabilityCheckTimeout, PullRequestActivityDao activityDao, AuthenticationContext authenticationContext, AutoMergeRequestDao autoMergeRequestDao, AutoMergeSettingsService autoMergeSettingsService, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, LockService lockService, MergeQueueService mergeQueueService, InternalMergeRequestCheckService mergeRequestCheckService, InternalPullRequestParticipantHelper participantHelper, PermissionService permissionService, PlatformTransactionManager platformTransactionManager, PullRequestMergeService pullRequestMergeService, InternalPullRequestService pullRequestService, SecurityService securityService, UserService userService) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.autoMergeRequestDao = autoMergeRequestDao;
        this.autoMergeSettingsService = autoMergeSettingsService;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.maxRequestLifetime = maxRequestLifetime;
        this.mergeabilityCheckTimeout = mergeabilityCheckTimeout;
        this.mergeQueueService = mergeQueueService;
        this.mergeRequestCheckService = mergeRequestCheckService;
        this.participantHelper = participantHelper;
        this.permissionService = permissionService;
        this.pullRequestMergeService = pullRequestMergeService;
        this.pullRequestService = pullRequestService;
        this.securityService = securityService;
        this.userService = userService;
        this.transactionTemplate = new TransactionTemplate(platformTransactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Override
    @Profiled
    @Unsecured(value="Internal service method; no permission check necessary")
    public void bulkCancel(@Nonnull Repository repository, @Nonnull AutoMergeCancelledReason cancelledReason) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(cancelledReason, "cancelledReason");
        Date startTime = new Date();
        this.securityService.impersonating((ApplicationUser)this.userService.getSystemServiceUser(), "Bulk-cancelling auto-merge as a system user").withPermission((Object)repository, Permission.REPO_WRITE).call(() -> {
            boolean wasLastPage;
            while (!(wasLastPage = ((Boolean)this.transactionTemplate.execute(status -> this.bulkCancelBatch(repository, cancelledReason, startTime))).booleanValue())) {
            }
            return null;
        });
    }

    @Override
    @Transactional
    @Unsecured(value="Internal service method; no permission check necessary")
    public void cancelAutoMerge(long id, @Nonnull AutoMergeCancelledReason cancelledReason) {
        Objects.requireNonNull(cancelledReason, "cancelledReason");
        InternalAutoMergeRequest autoMergeRequest = this.getAutoMergeRequestOrThrow(id);
        this.cancelAutoMerge((PullRequest)autoMergeRequest.getPullRequest(), cancelledReason);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequest cancelAutoMerge(int repositoryId, long pullRequestId, @Nonnull AutoMergeCancelledReason cancelledReason) {
        Objects.requireNonNull(cancelledReason, "cancelledReason");
        InternalPullRequest pullRequest = this.getPullRequestOrThrow(repositoryId, pullRequestId);
        this.cancelAutoMerge((PullRequest)pullRequest, cancelledReason);
        return pullRequest;
    }

    @Override
    @Transactional
    @Unsecured(value="Internal service method; no permission check necessary")
    public void deleteAutoMergeRequest(long id) {
        this.autoMergeRequestDao.deleteById((Object)id);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#pullRequest?.toRef.repository, 'REPO_READ')")
    @Transactional(readOnly=true)
    public Optional<AutoMergeRequest> getAutoMergeRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return Optional.ofNullable(this.autoMergeRequestDao.getByPullRequest(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest)));
    }

    @PreAuthorize(value="hasRepositoryPermission(#pullRequest?.toRef.repository, 'REPO_READ')")
    @RequireFeature(value=StandardFeature.PULL_REQUEST_AUTO_MERGE, skip=true)
    @Transactional(readOnly=true)
    public boolean isSettingEnabledForPullRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        if (!this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_AUTO_MERGE)) {
            return false;
        }
        RepositoryScope repositoryScope = Scopes.repository((Repository)DefaultAutoMergeService.getRepository(pullRequest));
        return this.autoMergeSettingsService.getOrDefault((Scope)repositoryScope).isEnabled();
    }

    @Override
    public <T> T performUsingLock(int repositoryId, @Nonnull Function<Boolean, T> operation) {
        Objects.requireNonNull(operation, "operation");
        try (LockGuard lockGuard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_PREFIX + repositoryId));){
            T t = operation.apply(lockGuard != null);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T performUsingLock(int repositoryId, @Nonnull Function<Boolean, T> operation, @Nonnull Duration acquireTimeout) {
        Objects.requireNonNull(acquireTimeout, "acquireTimeout");
        Objects.requireNonNull(operation, "operation");
        try (LockGuard lockGuard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_PREFIX + repositoryId), (long)acquireTimeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);){
            Boolean t = operation.apply(lockGuard != null);
            return (T)t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Interrupted while waiting for the lock for repository ID {}", (Object)repositoryId);
            return (T)operation.apply(false);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#pullRequestMergeRequest?.repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequest submitAutoMergeRequest(@Nonnull PullRequestMergeRequest pullRequestMergeRequest) {
        Objects.requireNonNull(pullRequestMergeRequest, "pullRequestMergeRequest");
        InternalPullRequest pullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)this.pullRequestService.validateMergeRequest(pullRequestMergeRequest));
        this.validateAutoMergeSetting((PullRequest)pullRequest);
        if (this.canMergeNow((PullRequest)pullRequest)) {
            return this.pullRequestMergeService.merge(pullRequestMergeRequest, false);
        }
        if (!this.isAutoMergeRequested((PullRequest)pullRequest)) {
            this.createAutoMergeRequest(pullRequest, pullRequestMergeRequest);
            this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
            PullRequestActivity activity = this.logRequestedActivity((PullRequest)pullRequest);
            this.eventPublisher.publish((Object)new PullRequestActivityEvent((Object)this, activity));
            this.eventPublisher.publish((Object)new PullRequestAutoMergeRequestedEvent((Object)this, (PullRequest)pullRequest));
        }
        return pullRequest;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_WRITE')")
    @Profiled
    public AutoMergeProcessingResult tryAutoMerge(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrThrow(repositoryId, pullRequestId);
        long autoMergeRequestId = pullRequest.getGlobalId();
        try {
            return this.performUsingLock(repositoryId, acquired -> acquired != false ? this.tryAutoMerge(autoMergeRequestId) : this.handleLockFailure(autoMergeRequestId), LOCK_ACQUIRE_TIMEOUT);
        }
        catch (NoSuchEntityException e) {
            throw new AutoMergeNotRequestedException(this.i18nService.createKeyedMessage("bitbucket.pull.automerge.error.missingrequest", new Object[0]), (PullRequest)pullRequest);
        }
        catch (AutoMergeFailedException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    @Nonnull
    @Profiled
    @Unsecured(value="Internal service method; no permission check necessary")
    public AutoMergeProcessingResult tryAutoMerge(long id) {
        try {
            return (AutoMergeProcessingResult)this.transactionTemplate.execute(status -> {
                InternalAutoMergeRequest autoMergeRequest = this.getAutoMergeRequestOrThrow(id);
                InternalPullRequest pullRequest = autoMergeRequest.getPullRequest();
                try {
                    this.validateAutoMergeSetting((PullRequest)pullRequest);
                    return this.process(autoMergeRequest);
                }
                catch (RuntimeException e) {
                    throw new AutoMergeFailedException((AutoMergeRequest)autoMergeRequest, (Throwable)e);
                }
            });
        }
        catch (AutoMergeFailedException e) {
            if (e.getCause() instanceof PullRequestMergeVetoedException && ((PullRequestMergeVetoedException)e.getCause()).isConflicted()) {
                return (AutoMergeProcessingResult)this.transactionTemplate.execute(status -> this.handleConflictedAutoMerge(e.getAutoMergeRequest()));
            }
            if (e.getCause() instanceof MergeException) {
                return this.handleMergeException(e);
            }
            if (e.getCause() instanceof GitUnsupportedMergeStrategyException) {
                return this.handleMergeStrategyFailure(e, e.getAutoMergeRequest());
            }
            throw e;
        }
    }

    private static Object describe(final PullRequest pullRequest) {
        return new Object(){

            public String toString() {
                return String.format("[%d:%d@%d]", DefaultAutoMergeService.getRepository(pullRequest).getId(), pullRequest.getId(), pullRequest.getVersion());
            }
        };
    }

    private static Repository getRepository(PullRequest pullRequest) {
        return pullRequest.getToRef().getRepository();
    }

    private boolean bulkCancelBatch(Repository repository, AutoMergeCancelledReason cancelledReason, Date latestDate) {
        Page page = this.autoMergeRequestDao.findByRepository(repository.getId(), latestDate, PageUtils.newRequest((int)0, (int)100));
        if (page.getSize() == 0) {
            return true;
        }
        log.debug("{}: Bulk cancelling {} auto-merge requests for repository", (Object)repository, (Object)page.getSize());
        Set requestIds = (Set)page.stream().map(InternalAutoMergeRequest::getId).collect(MoreCollectors.toImmutableSet());
        this.autoMergeRequestDao.deleteByIds(requestIds);
        HashSet<Long> cancelledPullRequestIds = new HashSet<Long>();
        for (InternalAutoMergeRequest request : page.getValues()) {
            InternalPullRequest pullRequest = request.getPullRequest();
            if (!pullRequest.isOpen() || pullRequest.isDraft()) continue;
            cancelledPullRequestIds.add(pullRequest.getId());
            this.logCancelledActivity((PullRequest)pullRequest, cancelledReason);
        }
        if (!cancelledPullRequestIds.isEmpty()) {
            this.eventPublisher.publish((Object)new AutoMergeBulkCancelledEvent((Object)this, repository, cancelledPullRequestIds));
            log.debug("{}: {} auto-merge requests were deleted", (Object)repository, (Object)requestIds.size());
        }
        return page.getIsLastPage();
    }

    private void cancelAutoMerge(PullRequest pullRequest, AutoMergeCancelledReason cancelledReason) {
        if (pullRequest.isLocked()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.pull.automerge.error.locked", new Object[0]));
        }
        InternalPullRequest internalPullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
        if (this.deleteAutoMergeRequest(internalPullRequest)) {
            if (pullRequest.isOpen() && !internalPullRequest.isDraft()) {
                PullRequestActivity activity = this.logCancelledActivity(pullRequest, cancelledReason);
                log.debug("{}: Auto-merge canceled with reason: {}", DefaultAutoMergeService.describe(pullRequest), (Object)cancelledReason);
                if (!(this.authenticationContext.getCurrentUser() instanceof ServiceUser)) {
                    this.participantHelper.makeCurrentUserParticipantAndWatcher(internalPullRequest);
                }
                this.eventPublisher.publish((Object)new PullRequestActivityEvent((Object)this, activity));
                this.eventPublisher.publish((Object)new PullRequestAutoMergeCancelledEvent((Object)this, pullRequest, cancelledReason));
            } else {
                log.debug("{}: Deleted auto-merge request", DefaultAutoMergeService.describe(pullRequest));
            }
        }
    }

    private void cancelAutoMergeAsSystemUser(PullRequest pullRequest, AutoMergeCancelledReason cancelledReason) {
        this.securityService.impersonating((ApplicationUser)this.userService.getSystemServiceUser(), "Cancelling auto-merge as a system user").withPermission((Object)pullRequest.getToRef().getRepository(), Permission.REPO_WRITE).call(() -> {
            try {
                this.cancelAutoMerge(pullRequest, cancelledReason);
            }
            catch (IllegalPullRequestStateException e) {
                log.debug("{}: Couldn't cancel auto-merge request as the pull request is currently locked", DefaultAutoMergeService.describe(pullRequest), (Object)(log.isTraceEnabled() ? e : null));
            }
            return null;
        });
    }

    private boolean canMergeNow(PullRequest pullRequest) {
        PullRequestMergeability mergeability = this.mergeRequestCheckService.checkMergeability((InternalMergeRequest)new SimpleMergeRequest.Builder(pullRequest).abortOnFirstVeto(true).build());
        if (mergeability.isConflicted()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.pull.automerge.error.conflicted", new Object[0]));
        }
        return mergeability.canMerge();
    }

    private void createAutoMergeRequest(InternalPullRequest pullRequest, PullRequestMergeRequest pullRequestMergeRequest) {
        InternalApplicationUser user = this.getCurrentUserOrThrow();
        this.autoMergeRequestDao.create((Object)new InternalAutoMergeRequest.Builder(pullRequest, user).autoSubject(pullRequestMergeRequest.isAutoSubject()).createdDate(new Date()).message(pullRequestMergeRequest.getMessage()).strategyId(pullRequestMergeRequest.getStrategyId()).build());
        log.debug("{}: Auto-merge request is created for the pull request {}", (Object)DefaultAutoMergeService.getRepository((PullRequest)pullRequest), (Object)pullRequest.getId());
    }

    private boolean deleteAutoMergeRequest(InternalPullRequest pullRequest) {
        return this.autoMergeRequestDao.deleteByPullRequest(pullRequest);
    }

    private InternalAutoMergeRequest getAutoMergeRequestOrThrow(long id) {
        InternalAutoMergeRequest autoMergeRequest = (InternalAutoMergeRequest)this.autoMergeRequestDao.getById((Object)id);
        if (autoMergeRequest == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.pull.automerge.error.nosuchrequest", new Object[]{id}));
        }
        return autoMergeRequest;
    }

    private InternalApplicationUser getCurrentUserOrThrow() {
        InternalApplicationUser currentUser = InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
        if (currentUser == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.pull.automerge.error.anonymous", new Object[0]));
        }
        return currentUser;
    }

    private InternalPullRequest getPullRequestOrThrow(int repositoryId, long pullRequestId) {
        PullRequest pullRequest = this.pullRequestService.getById(repositoryId, pullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.repository.nosuchrequest", new Object[]{pullRequestId, repositoryId}));
        }
        return InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
    }

    private AutoMergeProcessingResult handleConflictedAutoMerge(AutoMergeRequest autoMergeRequest) {
        PullRequest pullRequest = autoMergeRequest.getPullRequest();
        log.debug("{} Cancelling auto-merge for the pull request due to merge conflicts", DefaultAutoMergeService.describe(pullRequest));
        this.cancelAutoMergeAsSystemUser(pullRequest, AutoMergeCancelledReason.MERGE_CONFLICTS);
        return new AutoMergeProcessingResult(autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.CANCELLED);
    }

    private AutoMergeProcessingResult handleLockFailure(long autoMergeRequestId) {
        InternalAutoMergeRequest autoMergeRequest = this.getAutoMergeRequestOrThrow(autoMergeRequestId);
        return new AutoMergeProcessingResult((AutoMergeRequest)autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.LOCK_FAILURE);
    }

    private AutoMergeProcessingResult handleMergeabilityCheckTimedOut(AutoMergeRequest autoMergeRequest, Duration mergeabilityCheckDuration) {
        PullRequest pullRequest = autoMergeRequest.getPullRequest();
        log.warn("{}: Cancelling auto-merge for the pull request due to merge checks taking {}, which exceeds the configured timeout of {}", new Object[]{DefaultAutoMergeService.describe(pullRequest), mergeabilityCheckDuration, this.mergeabilityCheckTimeout});
        this.cancelAutoMergeAsSystemUser(pullRequest, AutoMergeCancelledReason.MERGE_CHECK_TIMEOUT);
        return new AutoMergeProcessingResult(autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.CANCELLED);
    }

    private AutoMergeProcessingResult handleMergeException(AutoMergeFailedException e) {
        MergeException mergeException = (MergeException)e.getCause();
        AutoMergeRequest autoMergeRequest = e.getAutoMergeRequest();
        if (mergeException.getCause() instanceof GitMergeStrategyException) {
            return this.handleMergeStrategyFailure((RuntimeException)mergeException, autoMergeRequest);
        }
        throw e;
    }

    private AutoMergeProcessingResult handleMergeStrategyFailure(RuntimeException exception, AutoMergeRequest autoMergeRequest) {
        return (AutoMergeProcessingResult)this.transactionTemplate.execute(status -> {
            log.debug("{}: Pull request could not be merged because of the following error:\n{}\nAuto-merge request will be cancelled", new Object[]{DefaultAutoMergeService.describe(autoMergeRequest.getPullRequest()), exception.getMessage(), log.isTraceEnabled() ? exception : null});
            this.cancelAutoMergeAsSystemUser(autoMergeRequest.getPullRequest(), AutoMergeCancelledReason.MERGE_STRATEGY_FAILURE);
            return new AutoMergeProcessingResult(autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.CANCELLED);
        });
    }

    private boolean isAutoMergeRequested(PullRequest pullRequest) {
        return this.getAutoMergeRequest(pullRequest).isPresent();
    }

    private boolean isExpired(AutoMergeRequest autoMergeRequest) {
        return autoMergeRequest.getCreatedDate().toInstant().plus(this.maxRequestLifetime).isBefore(Instant.now());
    }

    private PullRequestActivity logCancelledActivity(PullRequest pullRequest, AutoMergeCancelledReason cancelledReason) {
        InternalPullRequestAutoMergeCancelledActivity activity = ((InternalPullRequestAutoMergeCancelledActivity.Builder)((InternalPullRequestAutoMergeCancelledActivity.Builder)((InternalPullRequestAutoMergeCancelledActivity.Builder)new InternalPullRequestAutoMergeCancelledActivity.Builder(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest)).action(PullRequestAction.AUTO_MERGE_CANCELLED)).createdDate(new Date())).user(this.getCurrentUserOrThrow())).cancelledReason(cancelledReason).build();
        this.activityDao.create((Object)activity);
        return activity;
    }

    private PullRequestActivity logRequestedActivity(PullRequest pullRequest) {
        InternalPullRequestActivity activity = ((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest)).action(PullRequestAction.AUTO_MERGE_REQUESTED)).createdDate(new Date())).user(this.getCurrentUserOrThrow())).build();
        this.activityDao.create((Object)activity);
        return activity;
    }

    private AutoMergeProcessingResult process(InternalAutoMergeRequest autoMergeRequest) {
        if (!this.validateAutoMergeRequest(autoMergeRequest)) {
            return new AutoMergeProcessingResult((AutoMergeRequest)autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.CANCELLED);
        }
        InternalPullRequest pullRequest = autoMergeRequest.getPullRequest();
        InternalApplicationUser user = autoMergeRequest.getUser();
        log.trace("{}: Attempting to process the auto-merge request on behalf of {}", DefaultAutoMergeService.describe((PullRequest)pullRequest), (Object)user.getUsername());
        return (AutoMergeProcessingResult)this.securityService.impersonating((ApplicationUser)user, "Auto-merging pull request on behalf of user who requested").call(() -> this.tryMerge(autoMergeRequest));
    }

    private AutoMergeProcessingResult tryMerge(InternalAutoMergeRequest autoMergeRequest) {
        InternalPullRequest pullRequest = autoMergeRequest.getPullRequest();
        Instant mergeabilityCheckStart = Instant.now();
        PullRequestMergeability mergeability = this.pullRequestService.canMerge(autoMergeRequest.getRepositoryId(), pullRequest.getId(), true);
        if (mergeability.isConflicted()) {
            return this.handleConflictedAutoMerge((AutoMergeRequest)autoMergeRequest);
        }
        if (mergeability.canMerge()) {
            if (this.pullRequestService.needsRescoping((PullRequest)pullRequest)) {
                return new AutoMergeProcessingResult((AutoMergeRequest)autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.STALE);
            }
            PullRequestMergeRequest mergeRequest = new PullRequestMergeRequest.Builder((PullRequest)pullRequest).autoSubject(autoMergeRequest.isAutoSubject()).message(autoMergeRequest.getMessage()).strategyId(autoMergeRequest.getStrategyId()).build();
            PullRequest merged = this.pullRequestMergeService.merge(mergeRequest, true);
            if (merged.isClosed() || this.mergeQueueService.isQueued(merged)) {
                log.trace("{}: Pull request is successfully auto-merged, removing auto-merge request from the database", DefaultAutoMergeService.describe((PullRequest)pullRequest));
                this.deleteAutoMergeRequest(pullRequest);
                return new AutoMergeProcessingResult((AutoMergeRequest)autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.MERGED);
            }
            return new AutoMergeProcessingResult((AutoMergeRequest)autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.UNKNOWN);
        }
        Instant mergeabilityCheckFinish = Instant.now();
        if (mergeabilityCheckStart.plus(this.mergeabilityCheckTimeout).isBefore(mergeabilityCheckFinish)) {
            Duration mergeabilityCheckDuration = Duration.between(mergeabilityCheckStart, mergeabilityCheckFinish);
            return this.handleMergeabilityCheckTimedOut((AutoMergeRequest)autoMergeRequest, mergeabilityCheckDuration);
        }
        log.trace("{}: Pull request is not yet ready to merge, skipping auto-merge", DefaultAutoMergeService.describe((PullRequest)pullRequest));
        return new AutoMergeProcessingResult((AutoMergeRequest)autoMergeRequest, AutoMergeProcessingResult.AutoMergeProcessingStatus.VETOED);
    }

    private boolean validateAutoMergeRequest(InternalAutoMergeRequest autoMergeRequest) {
        InternalPullRequest pullRequest = autoMergeRequest.getPullRequest();
        if (pullRequest.isClosed()) {
            log.debug("{}: Pull request is not open, deleting auto-merge request", DefaultAutoMergeService.describe((PullRequest)pullRequest));
            this.deleteAutoMergeRequest(pullRequest);
            return false;
        }
        if (pullRequest.isDraft()) {
            log.debug("{}: Pull request is a draft, deleting auto-merge request", DefaultAutoMergeService.describe((PullRequest)pullRequest));
            this.deleteAutoMergeRequest(pullRequest);
            return false;
        }
        InternalApplicationUser user = autoMergeRequest.getUser();
        if (!user.isActive()) {
            log.debug("{}: The user {} who requested to auto-merge is no longer active, cancelling auto-merge", DefaultAutoMergeService.describe((PullRequest)pullRequest), (Object)user.getUsername());
            this.cancelAutoMergeAsSystemUser((PullRequest)pullRequest, AutoMergeCancelledReason.USER_DELETED);
            return false;
        }
        if (!this.permissionService.hasRepositoryPermission((ApplicationUser)user, autoMergeRequest.getRepositoryId(), Permission.REPO_WRITE)) {
            log.debug("{}: The user {} who requested to auto-merge no longer has permission to merge pull request, cancelling auto-merge", DefaultAutoMergeService.describe((PullRequest)pullRequest), (Object)user.getUsername());
            this.cancelAutoMergeAsSystemUser((PullRequest)pullRequest, AutoMergeCancelledReason.INSUFFICIENT_USER_PERMISSIONS);
            return false;
        }
        if (!Objects.equals(pullRequest.getFromRef().getLatestCommit(), autoMergeRequest.getFromHash())) {
            log.debug("{}: Could not process auto merge request as changes detected on source branch since request was made", DefaultAutoMergeService.describe((PullRequest)pullRequest));
            this.cancelAutoMergeAsSystemUser((PullRequest)pullRequest, AutoMergeCancelledReason.SOURCE_BRANCH_COMMITS_CHANGED);
            return false;
        }
        if (!Objects.equals(pullRequest.getToRef().getId(), autoMergeRequest.getToRefId())) {
            log.debug("{}: Could not process auto merge request as the pull request was re-targeted to a different branch since request was made", DefaultAutoMergeService.describe((PullRequest)pullRequest));
            this.cancelAutoMergeAsSystemUser((PullRequest)pullRequest, AutoMergeCancelledReason.RETARGETED);
            return false;
        }
        if (this.isExpired((AutoMergeRequest)autoMergeRequest)) {
            log.debug("{} Cancelling auto-merge for the pull request as it has failed to merge after {}", DefaultAutoMergeService.describe((PullRequest)pullRequest), (Object)this.maxRequestLifetime);
            this.cancelAutoMergeAsSystemUser((PullRequest)pullRequest, AutoMergeCancelledReason.EXPIRED);
            return false;
        }
        return true;
    }

    private void validateAutoMergeSetting(PullRequest pullRequest) {
        if (!this.isSettingEnabledForPullRequest(pullRequest)) {
            throw new AutoMergeSettingNotEnabledException(this.i18nService.createKeyedMessage("bitbucket.pull.automerge.error.disabled", new Object[0]), pullRequest);
        }
    }
}

