/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettings;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsCreateRequest;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsService;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsCreatedEvent;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsDao;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsDeletedEvent;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsUpdatedEvent;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeSettings;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=AutoMergeSettingsService.class)
@RequireFeature(value=StandardFeature.PULL_REQUEST_AUTO_MERGE)
@Service(value="autoMergeSettingsService")
@Transactional(readOnly=true)
public class DefaultAutoMergeSettingsService
implements AutoMergeSettingsService {
    private static final AutoMergeSettings GLOBAL_SETTINGS = new AutoMergeSettings(){

        public boolean isEnabled() {
            return false;
        }

        @Nonnull
        public Scope getScope() {
            return Scopes.global();
        }
    };
    private final AutoMergeSettingsDao autoMergeSettingsDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;

    @Autowired
    public DefaultAutoMergeSettingsService(AutoMergeSettingsDao autoMergeSettingsDao, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, ProjectSettingsRestrictionService projectSettingsRestrictionService) {
        this.autoMergeSettingsDao = autoMergeSettingsDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
    }

    @Transactional
    public void delete(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() == ScopeType.GLOBAL) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.pull.automerge.error.invalidscope", new Object[0]));
        }
        this.validateAdminPermission(scope);
        this.validateIsNotRestricted(scope, "bitbucket.pull.automerge.settingsrestriction.delete");
        InternalAutoMergeSettings settings = this.autoMergeSettingsDao.findByScope(scope);
        if (settings != null) {
            this.autoMergeSettingsDao.deleteByScope(scope);
            this.eventPublisher.publish((Object)new AutoMergeSettingsDeletedEvent(this, (AutoMergeSettings)settings));
        }
    }

    @Nonnull
    @Transactional(readOnly=true)
    public AutoMergeSettings getOrDefault(@Nonnull Scope scope) {
        this.validateReadPermission(Objects.requireNonNull(scope, "scope"));
        if (scope.getType() == ScopeType.GLOBAL) {
            return GLOBAL_SETTINGS;
        }
        Scope permittedScope = (Scope)scope.accept((ScopeVisitor)new ScopeVisitor<Scope>(){

            public Scope visit(@Nonnull ProjectScope projectScope) {
                return projectScope;
            }

            public Scope visit(@Nonnull RepositoryScope repositoryScope) {
                if (DefaultAutoMergeSettingsService.this.projectSettingsRestrictionService.hasRestriction(repositoryScope.getProject(), ProjectSettingsRestrictionKeys.AUTO_MERGE)) {
                    return Scopes.project((Project)repositoryScope.getProject());
                }
                return repositoryScope;
            }
        });
        return (AutoMergeSettings)ObjectUtils.firstNonNull((Object[])new AutoMergeSettings[]{this.autoMergeSettingsDao.findInheritedByScopes(permittedScope), GLOBAL_SETTINGS});
    }

    @Nonnull
    @Transactional
    public AutoMergeSettings set(@Nonnull AutoMergeSettingsCreateRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateAdminPermission(request.getScope());
        this.validateIsNotRestricted(request.getScope(), "bitbucket.pull.automerge.settingsrestriction.update");
        InternalAutoMergeSettings existingSettings = this.autoMergeSettingsDao.findByScope(request.getScope());
        if (existingSettings == null) {
            InternalAutoMergeSettings newSettings = new InternalAutoMergeSettings.Builder(request.getScope(), request.isEnabled()).build();
            this.eventPublisher.publish((Object)new AutoMergeSettingsCreatedEvent(this, (AutoMergeSettings)newSettings));
            return (AutoMergeSettings)this.autoMergeSettingsDao.create((Object)newSettings);
        }
        InternalAutoMergeSettings updatedSettings = new InternalAutoMergeSettings.Builder(existingSettings).enabled(request.isEnabled()).build();
        if (!updatedSettings.equals((Object)existingSettings)) {
            existingSettings = new InternalAutoMergeSettings.Builder(existingSettings).build();
            this.eventPublisher.publish((Object)new AutoMergeSettingsUpdatedEvent(this, (AutoMergeSettings)updatedSettings, (AutoMergeSettings)existingSettings));
            return (AutoMergeSettings)this.autoMergeSettingsDao.update((Object)updatedSettings);
        }
        return updatedSettings;
    }

    private void validateAdminPermission(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultAutoMergeSettingsService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultAutoMergeSettingsService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateIsNotRestricted(Scope scope, final String errorKey) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                if (DefaultAutoMergeSettingsService.this.projectSettingsRestrictionService.hasRestriction(repositoryScope.getProject(), ProjectSettingsRestrictionKeys.AUTO_MERGE)) {
                    throw new ForbiddenException(DefaultAutoMergeSettingsService.this.i18nService.createKeyedMessage(errorKey, new Object[0]));
                }
                return null;
            }
        });
    }

    private void validateReadPermission(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope globalScope) {
                DefaultAutoMergeSettingsService.this.permissionValidationService.validateForGlobal(Permission.LICENSED_USER);
                return null;
            }

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultAutoMergeSettingsService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_VIEW);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultAutoMergeSettingsService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_READ);
                return null;
            }
        });
    }
}

