/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVetoedException;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.automerge.AutoMergeProcessingResult;
import com.atlassian.bitbucket.pull.automerge.AutoMergeRequest;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingNotEnabledException;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.git.command.push.GitNonFastForwardUpdateRejectedException;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.pull.automerge.AutoMergeFailedException;
import com.atlassian.stash.internal.pull.automerge.AutoMergeProcessingRequest;
import com.atlassian.stash.internal.pull.automerge.AutoMergeStalePullRequestQueue;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeRequest;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="exceptionHandlingAutoMergeProcessor")
public class ExceptionHandlingAutoMergeProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlingAutoMergeProcessor.class);
    private final InternalAutoMergeService autoMergeService;
    private final AutoMergeStalePullRequestQueue queue;
    private final SecurityService securityService;
    private final UserService userService;

    @Autowired
    public ExceptionHandlingAutoMergeProcessor(InternalAutoMergeService autoMergeService, AutoMergeStalePullRequestQueue queue, SecurityService securityService, UserService userService) {
        this.autoMergeService = autoMergeService;
        this.queue = queue;
        this.securityService = securityService;
        this.userService = userService;
    }

    public void tryAutoMerge(@Nonnull AutoMergeProcessingRequest processingRequest) {
        Objects.requireNonNull(processingRequest, "processingRequest");
        long autoMergeRequestId = processingRequest.getAutoMergeRequestId();
        try {
            AutoMergeProcessingResult result = this.autoMergeService.tryAutoMerge(autoMergeRequestId);
            log.trace("{}: Processing of auto-merge request completed with status: {}", ExceptionHandlingAutoMergeProcessor.describe(result.getAutoMergeRequest()), (Object)result.getProcessingStatus());
            if (result.getProcessingStatus() == AutoMergeProcessingResult.AutoMergeProcessingStatus.STALE) {
                this.handleStalePullRequest(processingRequest, result.getAutoMergeRequest());
            }
        }
        catch (NoSuchEntityException e) {
            log.debug("[{}]: Auto-merge request with ID {} could not be processed as it is now deleted", (Object)processingRequest.getRepositoryId(), (Object)autoMergeRequestId);
        }
        catch (AutoMergeFailedException e) {
            Throwable cause = e.getCause();
            AutoMergeRequest autoMergeRequest = e.getAutoMergeRequest();
            if (cause instanceof MergeException) {
                this.handleMergeException(processingRequest, e);
            }
            if (cause instanceof AutoMergeSettingNotEnabledException) {
                this.handleAutoMergeSettingNotEnabledException(autoMergeRequest);
            }
            if (ExceptionHandlingAutoMergeProcessor.shouldIgnoreException(cause)) {
                log.debug("{}: Pull request could not be auto-merged because of the following error:\n{}", new Object[]{ExceptionHandlingAutoMergeProcessor.describe(autoMergeRequest), cause.getLocalizedMessage(), log.isTraceEnabled() ? e : null});
            }
            log.warn("{}: Unknown error while processing {}; cancelling auto-merge request", new Object[]{ExceptionHandlingAutoMergeProcessor.describe(autoMergeRequest), processingRequest, e});
            this.cancelAutoMergeRequest((InternalAutoMergeRequest)autoMergeRequest);
        }
    }

    private static Object describe(final AutoMergeRequest autoMergeRequest) {
        return new Object(){

            public String toString() {
                PullRequest pullRequest = autoMergeRequest.getPullRequest();
                return String.format("[%d:%d@%d]", pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), pullRequest.getVersion());
            }
        };
    }

    private static boolean shouldIgnoreException(Throwable cause) {
        return cause instanceof PullRequestMergeVetoedException || cause instanceof NoSuchPullRequestException || cause instanceof IllegalPullRequestStateException || cause instanceof PullRequestOutOfDateException;
    }

    private void cancelAutoMergeRequest(InternalAutoMergeRequest autoMergeRequest) {
        this.securityService.impersonating((ApplicationUser)this.userService.getSystemServiceUser(), "Cancelling auto-merge as a system user").call(() -> {
            try {
                this.autoMergeService.cancelAutoMerge(autoMergeRequest.getId(), AutoMergeCancelledReason.UNEXPECTED_ERROR);
            }
            catch (NoSuchEntityException e) {
                log.debug("{}: Auto-merge for the pull request could not be cancelled as the request is not found", ExceptionHandlingAutoMergeProcessor.describe((AutoMergeRequest)autoMergeRequest), (Object)e);
            }
            catch (IllegalPullRequestStateException e) {
                log.debug("{}: Auto-merge for the pull request could not be cancelled as the pull request is currently locked.", ExceptionHandlingAutoMergeProcessor.describe((AutoMergeRequest)autoMergeRequest), (Object)e);
            }
            catch (RuntimeException e) {
                log.warn("{}: Unknown exception while cancelling auto-merge request for the pull request, deleting auto-merge request", ExceptionHandlingAutoMergeProcessor.describe((AutoMergeRequest)autoMergeRequest), (Object)e);
                this.autoMergeService.deleteAutoMergeRequest(autoMergeRequest.getId());
            }
            return null;
        });
    }

    private void handleAutoMergeSettingNotEnabledException(AutoMergeRequest autoMergeRequest) {
        log.debug("{}: Pull request was not processed as the auto-merge setting is disabled in the repository, bulk canceling auto-merge for the remaining requests in this repository", ExceptionHandlingAutoMergeProcessor.describe(autoMergeRequest));
        this.autoMergeService.bulkCancel(autoMergeRequest.getPullRequest().getToRef().getRepository(), AutoMergeCancelledReason.SETTING_DISABLED);
    }

    private void handleMergeException(AutoMergeProcessingRequest autoMergeProcessingRequest, AutoMergeFailedException exception) {
        MergeException mergeException = (MergeException)exception.getCause();
        if (mergeException.getCause() != null && mergeException.getCause() instanceof GitNonFastForwardUpdateRejectedException) {
            GitNonFastForwardUpdateRejectedException cause = (GitNonFastForwardUpdateRejectedException)mergeException.getCause();
            log.debug("{}: Pull request could not be merged because it had stale ref '{}'", new Object[]{ExceptionHandlingAutoMergeProcessor.describe(exception.getAutoMergeRequest()), cause.getRejectedRef(), log.isTraceEnabled() ? mergeException : null});
            this.queue.offerRetry(autoMergeProcessingRequest);
            return;
        }
        log.warn("{} could not be processed as an error was encountered while performing SCM merge operation", (Object)autoMergeProcessingRequest, (Object)mergeException);
    }

    private void handleStalePullRequest(AutoMergeProcessingRequest processingRequest, AutoMergeRequest autoMergeRequest) {
        log.debug("{}: Pull request could not be auto-merged because it is not up-to-date with the SCM refs", ExceptionHandlingAutoMergeProcessor.describe(autoMergeRequest));
        this.queue.offerRetry(processingRequest);
    }
}

