/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.cluster.ClusterPartitionService;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.pull.automerge.AutoMergeRequestDao;
import com.atlassian.stash.internal.pull.automerge.PullRequestAutoMergeRepositoryProcessor;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="pullRequestAutoMergeJob")
@DefaultApplicationMode
public class PullRequestAutoMergeJob
implements ScheduledJobSource {
    @VisibleForTesting
    static final JobId JOB_ID = JobId.of((String)PullRequestAutoMergeJob.class.getSimpleName());
    @VisibleForTesting
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)PullRequestAutoMergeJob.class.getName());
    private static final Duration FIRST_RUN_DELAY = Duration.ofMinutes(1L);
    private static final Logger log = LoggerFactory.getLogger(PullRequestAutoMergeJob.class);
    private final PullRequestAutoMergeRepositoryProcessor autoMergeRepositoryProcessor;
    private final AutoMergeRequestDao autoMergeRequestDao;
    private final ClusterPartitionService clusterPartitionService;
    private final Executor executor;
    private final Duration interval;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public PullRequestAutoMergeJob(@DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${pullrequest.auto.merge.job.interval}") Duration interval, AutoMergeRequestDao autoMergeRequestDao, PullRequestAutoMergeRepositoryProcessor autoMergeRepositoryProcessor, ClusterPartitionService clusterPartitionService, @Value(value="${pullrequest.auto.merge.max.threads:1}") int maxConcurrency, PlatformTransactionManager platformTransactionManager, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.autoMergeRequestDao = autoMergeRequestDao;
        this.interval = interval;
        this.autoMergeRepositoryProcessor = autoMergeRepositoryProcessor;
        this.clusterPartitionService = clusterPartitionService;
        this.executor = PullRequestAutoMergeJob.createExecutor(maxConcurrency, threadLocalDelegateExecutorFactory);
        this.transactionTemplate = new TransactionTemplate(platformTransactionManager, SpringTransactionUtils.definitionFor((int)3, (boolean)true));
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new AutoMergeJobRunner());
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withParameters((Map)ImmutableMap.of((Object)"feature", (Object)StandardFeature.PULL_REQUEST_AUTO_MERGE)).withSchedule(Schedule.forInterval((long)this.interval.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(FIRST_RUN_DELAY).toInstant()))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    private static Executor createExecutor(int maxConcurrency, ThreadLocalDelegateExecutorFactory factory) {
        return maxConcurrency == 1 ? MoreExecutors.directExecutor() : factory.createExecutorService((ExecutorService)new ThreadPoolExecutor(maxConcurrency, maxConcurrency, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"pull-request-auto-merge-executor", (ThreadFactories.Type)ThreadFactories.Type.DAEMON), (runnable, executor) -> {
            if (executor.isShutdown()) {
                log.debug("Dropping rejected auto-merge processing task; the executor has been shutdown");
                return;
            }
            try {
                executor.getQueue().put(runnable);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("Interrupted while waiting to add the task to executor queue, rejecting execution");
                throw new RejectedExecutionException();
            }
        }));
    }

    private class AutoMergeJobRunner
    implements JobRunner {
        private AutoMergeJobRunner() {
        }

        @Nonnull
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            try (IntStream repoIds = (IntStream)PullRequestAutoMergeJob.this.transactionTemplate.execute(status -> PullRequestAutoMergeJob.this.autoMergeRequestDao.streamRepositoryIds());){
                repoIds.filter(arg_0 -> ((ClusterPartitionService)PullRequestAutoMergeJob.this.clusterPartitionService).belongsToLocalPartition(arg_0)).forEach(this::process);
            }
            return JobRunnerResponse.success();
        }

        private void process(int repositoryId) {
            PullRequestAutoMergeJob.this.executor.execute(() -> {
                log.trace("[{}]: Processing auto-merge requests for the repository", (Object)repositoryId);
                PullRequestAutoMergeJob.this.autoMergeRepositoryProcessor.process(repositoryId);
            });
        }
    }
}

