/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.automerge.DefaultAutoMergeService;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestAutoMergeListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoMergeService.class);
    private final InternalAutoMergeService autoMergeService;
    private final FeatureManager featureManager;
    private final SecurityService securityService;
    private final UserService userService;

    @Autowired
    public PullRequestAutoMergeListener(InternalAutoMergeService autoMergeService, FeatureManager featureManager, SecurityService securityService, UserService userService) {
        this.autoMergeService = autoMergeService;
        this.featureManager = featureManager;
        this.securityService = securityService;
        this.userService = userService;
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent event) {
        if (this.isAutoMergeFeatureDisabled()) {
            return;
        }
        this.deleteAutoMergeRequest(event.getPullRequest());
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        if (this.isAutoMergeFeatureDisabled()) {
            return;
        }
        this.deleteAutoMergeRequest(event.getPullRequest());
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent event) {
        if (this.isAutoMergeFeatureDisabled()) {
            return;
        }
        if (event.isFromHashUpdated()) {
            this.cancelAutoMerge(event.getPullRequest(), AutoMergeCancelledReason.SOURCE_BRANCH_COMMITS_CHANGED);
        }
    }

    @EventListener
    public void onPullRequestUpdated(PullRequestUpdatedEvent event) {
        if (this.isAutoMergeFeatureDisabled()) {
            return;
        }
        if (event.getPreviousToBranch() != null) {
            this.cancelAutoMerge(event.getPullRequest(), AutoMergeCancelledReason.RETARGETED);
            return;
        }
        PullRequest pullRequest = event.getPullRequest();
        if (pullRequest.isDraft()) {
            this.deleteAutoMergeRequest(pullRequest);
        }
    }

    private void cancelAutoMerge(PullRequest pullRequest, AutoMergeCancelledReason cancelledReason) {
        this.securityService.impersonating((ApplicationUser)this.userService.getSystemServiceUser(), "Cancelling auto-merge as a system user").withPermission((Object)pullRequest.getToRef().getRepository(), Permission.REPO_WRITE).call(() -> {
            try {
                this.autoMergeService.cancelAutoMerge(pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), cancelledReason);
            }
            catch (IllegalPullRequestStateException e) {
                log.debug("[{}:{}@{}]: Couldn't cancel auto-merge request as the pull request is currently locked", new Object[]{pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), pullRequest.getVersion(), log.isTraceEnabled() ? e : null});
            }
            return null;
        });
    }

    private void deleteAutoMergeRequest(PullRequest pullRequest) {
        InternalPullRequest internalPullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
        this.autoMergeService.deleteAutoMergeRequest(internalPullRequest.getGlobalId());
    }

    private boolean isAutoMergeFeatureDisabled() {
        return !this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_AUTO_MERGE);
    }
}

