/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.pull.automerge.AutoMergeProcessingRequest;
import com.atlassian.stash.internal.pull.automerge.AutoMergeRequestDao;
import com.atlassian.stash.internal.pull.automerge.ExceptionHandlingAutoMergeProcessor;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeService;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;

@Component
public class PullRequestAutoMergeRepositoryProcessor {
    static final int DAO_FETCH_PAGE_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(PullRequestAutoMergeRepositoryProcessor.class);
    private final AutoMergeRequestDao autoMergeRequestDao;
    private final InternalAutoMergeService autoMergeService;
    private final AutoMergeSettingsService autoMergeSettingsService;
    private final ExceptionHandlingAutoMergeProcessor exceptionHandlingAutoMergeProcessor;
    private final Duration lockAcquireTimeout;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public PullRequestAutoMergeRepositoryProcessor(@DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${pullrequest.auto.merge.repository.lock.acquisition.timeout}") Duration lockAcquireTimeout, AutoMergeRequestDao autoMergeRequestDao, InternalAutoMergeService autoMergeService, AutoMergeSettingsService autoMergeSettingsService, ExceptionHandlingAutoMergeProcessor exceptionHandlingAutoMergeProcessor, RepositoryService repositoryService, SecurityService securityService, TransactionTemplate transactionTemplate) {
        this.autoMergeRequestDao = autoMergeRequestDao;
        this.autoMergeService = autoMergeService;
        this.autoMergeSettingsService = autoMergeSettingsService;
        this.exceptionHandlingAutoMergeProcessor = exceptionHandlingAutoMergeProcessor;
        this.lockAcquireTimeout = lockAcquireTimeout;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.transactionTemplate = transactionTemplate;
    }

    public void process(int repositoryId) {
        this.autoMergeService.performUsingLock(repositoryId, acquired -> {
            if (acquired.booleanValue()) {
                try (Timer ignored = TimerUtils.start((String)("Auto-merging pull requests for repository ID: " + repositoryId));){
                    Object object = this.withAdminPermission().call(() -> {
                        Repository repository = this.repositoryService.getById(repositoryId);
                        if (repository == null) {
                            log.debug("Repository not found with ID: {}, nothing to process", (Object)repositoryId);
                            return null;
                        }
                        this.doProcess(repository);
                        return null;
                    });
                    return object;
                }
            }
            log.debug("Skipping the processing of auto-merge requests for repository ID: {} as the lock could not be acquired after {}.", (Object)repositoryId, (Object)this.lockAcquireTimeout);
            return null;
        }, this.lockAcquireTimeout);
    }

    private void doProcess(Repository repository) {
        if (this.isSettingEnabled(repository)) {
            log.trace("{}: Going to process auto-merge requests for the repository", (Object)repository);
            this.streamAutoMergeRequestIds(repository).forEach(requestId -> this.exceptionHandlingAutoMergeProcessor.tryAutoMerge(new AutoMergeProcessingRequest.Builder(repository.getId(), (long)requestId).build()));
        } else {
            log.debug("{}: Auto-merge setting is not enabled for the repository, cancelling its auto-merge requests", (Object)repository);
            this.autoMergeService.bulkCancel(repository, AutoMergeCancelledReason.SETTING_DISABLED);
        }
        log.trace("{}: Finished handling auto-merge requests for the repository", (Object)repository);
    }

    private boolean isSettingEnabled(Repository repository) {
        return this.autoMergeSettingsService.getOrDefault((Scope)Scopes.repository((Repository)repository)).isEnabled();
    }

    private Stream<Long> streamAutoMergeRequestIds(Repository repository) {
        AutoMergeRequestIdsProvider pageProvider = new AutoMergeRequestIdsProvider(repository.getId(), this.autoMergeRequestDao, this.transactionTemplate);
        return PageUtils.toStream((PageProvider)pageProvider, (int)100);
    }

    private EscalatedSecurityContext withAdminPermission() {
        return this.securityService.withPermission(Permission.ADMIN, "Processing auto-merge requests");
    }

    private static class AutoMergeRequestIdsProvider
    implements PageProvider<Long> {
        private final AutoMergeRequestDao autoMergeRequestDao;
        private final int repositoryId;
        private final TransactionTemplate transactionTemplate;
        private long endOfLastPage;

        public AutoMergeRequestIdsProvider(int repositoryId, AutoMergeRequestDao autoMergeRequestDao, TransactionTemplate transactionTemplate) {
            this.repositoryId = repositoryId;
            this.autoMergeRequestDao = autoMergeRequestDao;
            this.transactionTemplate = transactionTemplate;
        }

        @Nonnull
        public Page<Long> get(@Nonnull PageRequest request) {
            log.trace("Fetching a page of auto-merge request IDs for repository ID: {}", (Object)this.repositoryId);
            List autoMergeRequests = (List)this.transactionTemplate.execute(() -> this.autoMergeRequestDao.findIdsByRepository(this.repositoryId, this.endOfLastPage, request.getLimit() + 1));
            if (autoMergeRequests.size() > 1) {
                this.endOfLastPage = (Long)autoMergeRequests.get(autoMergeRequests.size() - 2);
            }
            return PageUtils.createPage((Iterable)autoMergeRequests, (PageRequest)request);
        }
    }
}

