/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestPropertyContext;
import com.atlassian.bitbucket.pull.PullRequestPropertyProvider;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.CommentDao;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="commentCountProvider")
public class CommentCountProvider
implements PullRequestPropertyProvider {
    static final String COMMENT_COUNT = "commentCount";
    static final String OPEN_TASK_COUNT = "openTaskCount";
    static final String RESOLVED_TASK_COUNT = "resolvedTaskCount";
    private final CommentDao commentDao;

    @Autowired
    public CommentCountProvider(CommentDao commentDao) {
        this.commentDao = commentDao;
    }

    public void provideProperties(@Nonnull PullRequestPropertyContext context) {
        Map<Long, PullRequest> pullRequestsById = this.indexByGlobalId((Iterable<PullRequest>)context);
        Map commentsByPullRequest = this.commentDao.countByPullRequest(pullRequestsById.keySet(), (List)ImmutableList.of((Object)CommentSeverity.NORMAL), (List)ImmutableList.of((Object)CommentState.OPEN, (Object)CommentState.RESOLVED));
        Map openTasksByPullRequest = this.commentDao.countByPullRequest(pullRequestsById.keySet(), (List)ImmutableList.of((Object)CommentSeverity.BLOCKER), (List)ImmutableList.of((Object)CommentState.OPEN));
        Map resolvedTasksByPullRequest = this.commentDao.countByPullRequest(pullRequestsById.keySet(), (List)ImmutableList.of((Object)CommentSeverity.BLOCKER), (List)ImmutableList.of((Object)CommentState.RESOLVED));
        for (Map.Entry<Long, PullRequest> entry : pullRequestsById.entrySet()) {
            context.setProperty(entry.getValue(), COMMENT_COUNT, (Object)commentsByPullRequest.getOrDefault(entry.getKey(), 0L));
            context.setProperty(entry.getValue(), OPEN_TASK_COUNT, (Object)openTasksByPullRequest.getOrDefault(entry.getKey(), 0L));
            context.setProperty(entry.getValue(), RESOLVED_TASK_COUNT, (Object)resolvedTasksByPullRequest.getOrDefault(entry.getKey(), 0L));
        }
    }

    private Map<Long, PullRequest> indexByGlobalId(Iterable<PullRequest> context) {
        return (Map)MoreStreams.streamIterable(context).collect(MoreCollectors.toImmutableMap(pullRequest -> InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId(), Function.identity()));
    }
}

