/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.pull.comment.diff.CommentContextDiffContentCallback;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CommentPullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private static final Logger log = LoggerFactory.getLogger(CommentPullRequestActivityEnricher.class);
    private final AuthenticationContext authenticationContext;
    private final CommentPostProcessor postProcessor;
    private final ScmService scmService;
    @Value(value="${pullrequest.diff.context}")
    private int diffContext;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;
    @Value(value="${plugin.multiline.comment.max.span.size:30}")
    private int maxMultilineSpanLength;

    @Autowired
    public CommentPullRequestActivityEnricher(AuthenticationContext authenticationContext, CommentPostProcessor postProcessor, ScmService scmService) {
        this.authenticationContext = authenticationContext;
        this.postProcessor = postProcessor;
        this.scmService = scmService;
    }

    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Iterable<InternalPullRequestActivity> activities) {
        List<InternalPullRequestCommentActivity> commentActivities = CommentPullRequestActivityEnricher.getCommentActivities(activities);
        if (commentActivities.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("{}: Of {} activities, none relate to comments", (Object)pullRequest.getGlobalId(), (Object)Iterables.size(activities));
            }
            return;
        }
        ReplyFilterCommentActivityVisitor replyFilterVisitor = new ReplyFilterCommentActivityVisitor(InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser()));
        commentActivities.forEach(activity -> activity.accept((PullRequestActivityVisitor)replyFilterVisitor));
        this.postProcessor.processRoots((InternalCommentable)pullRequest, (Set)commentActivities.stream().map(InternalPullRequestCommentActivity::getComment).collect(MoreCollectors.toImmutableSet()));
        List lineActivities = (List)commentActivities.stream().filter(activity -> {
            Optional anchor = activity.getComment().getAnchor();
            return anchor.map(a -> a.isLineAnchor() && a.getFromHash().isPresent()).orElse(false);
        }).collect(MoreCollectors.toImmutableList());
        if (lineActivities.isEmpty()) {
            log.trace("{}: Of {} comment activities, none relate to diff lines", (Object)pullRequest.getGlobalId(), (Object)commentActivities.size());
            return;
        }
        PullRequestEffectiveDiff effectiveDiff = (PullRequestEffectiveDiff)this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).effectiveDiff().call();
        if (effectiveDiff == null) {
            return;
        }
        this.applyDiffs(pullRequest, effectiveDiff, lineActivities);
    }

    private void applyDiffs(InternalPullRequest pullRequest, PullRequestEffectiveDiff effectiveDiff, List<InternalPullRequestCommentActivity> activities) {
        log.debug("{}: Sifting diffs for {} diff line comment(s)", (Object)pullRequest.getGlobalId(), (Object)activities.size());
        HashMap<DiffHashes, Set> diffs = new HashMap<DiffHashes, Set>(activities.size(), 1.0f);
        activities.forEach(activity -> {
            DiffHashes hashes = new DiffHashes((CommentThreadDiffAnchor)activity.getComment().getAnchor().get());
            diffs.computeIfAbsent(hashes, diffHashes -> new HashSet()).add(activity);
        });
        log.debug("{}: Performing {} diff(s) to build context for {} comment(s)", new Object[]{pullRequest.getGlobalId(), diffs.size(), activities.size()});
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory((Repository)pullRequest.getScopeRepository());
        diffs.forEach((hashes, set) -> this.streamDiff(commandFactory, pullRequest, effectiveDiff, (DiffHashes)hashes, (Set<InternalPullRequestCommentActivity>)set));
    }

    private static List<InternalPullRequestCommentActivity> getCommentActivities(Iterable<InternalPullRequestActivity> activities) {
        WinnowingVisitor visitor = new WinnowingVisitor();
        for (PullRequestActivity pullRequestActivity : activities) {
            pullRequestActivity.accept((PullRequestActivityVisitor)visitor);
        }
        return visitor.getActivities();
    }

    private static boolean isCurrentDiff(PullRequestEffectiveDiff effectiveDiff, DiffHashes hashes) {
        return Objects.equals(hashes.from, effectiveDiff.getSinceId()) && Objects.equals(hashes.to, effectiveDiff.getUntilId());
    }

    private void streamDiff(ScmCommandFactory commandFactory, InternalPullRequest pullRequest, PullRequestEffectiveDiff effectiveDiff, DiffHashes hashes, Set<InternalPullRequestCommentActivity> activities) {
        ImmutableList.Builder pathsBuilder = ImmutableList.builder();
        boolean showFullContext = false;
        for (InternalPullRequestCommentActivity activity : activities) {
            InternalCommentThreadDiffAnchor anchor = InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)activity.getComment().getAnchor().orElse(null));
            if (anchor == null) continue;
            if (anchor.isMultilineAnchor()) {
                if (anchor.getDstSpanStart().isPresent() && anchor.getSrcSpanStart().isPresent()) {
                    showFullContext = true;
                }
            } else if (anchor.getLineType().filter(type -> type == DiffSegmentType.CONTEXT).isPresent()) {
                showFullContext = true;
            }
            pathsBuilder.add((Object)anchor.getPath());
            anchor.getSrcPath().ifPresent(arg_0 -> ((ImmutableList.Builder)pathsBuilder).add(arg_0));
        }
        ImmutableList paths = pathsBuilder.build();
        DiffCommandParameters parameters = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(showFullContext ? Integer.MAX_VALUE : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(Integer.MAX_VALUE)).paths((Iterable)paths)).sinceId(hashes.from).untilId(hashes.to).build();
        PropertyMap properties = new PropertyMap.Builder().property("current", (Object)CommentPullRequestActivityEnricher.isCurrentDiff(effectiveDiff, hashes)).property("fromHash", (Object)hashes.from).property("toHash", (Object)hashes.to).build();
        log.debug("{}: Performing diff from {} to {} for {} comment(s) in {} file(s)", new Object[]{pullRequest.getGlobalId(), hashes.from, hashes.to, activities.size(), paths.size()});
        try {
            commandFactory.diff(parameters, (DiffContentCallback)new CommentContextDiffContentCallback(activities, properties, this.maxMultilineSpanLength)).call();
        }
        catch (NoSuchCommitException e) {
            log.debug("{}: Context for {} comment(s) in {} file(s) could not be loaded due to a missing commit: {}", new Object[]{pullRequest.getGlobalId(), activities.size(), paths.size(), e.getCommitId()});
        }
    }

    private static class ReplyFilterCommentActivityVisitor
    extends AbstractPullRequestActivityVisitor {
        private final InternalApplicationUser user;

        private ReplyFilterCommentActivityVisitor(InternalApplicationUser user) {
            this.user = user;
        }

        public void visit(@Nonnull PullRequestCommentActivity activity) {
            ((InternalComment)activity.getComment()).setReplyFilter(comment -> comment.getState() != CommentState.PENDING || comment.getAuthor().equals((Object)this.user));
        }
    }

    private static class WinnowingVisitor
    extends AbstractPullRequestActivityVisitor {
        private final ImmutableList.Builder<InternalPullRequestCommentActivity> builder = ImmutableList.builder();

        private WinnowingVisitor() {
        }

        public List<InternalPullRequestCommentActivity> getActivities() {
            return this.builder.build();
        }

        public void visit(@Nonnull PullRequestCommentActivity activity) {
            this.builder.add((Object)((InternalPullRequestCommentActivity)activity));
        }
    }

    private static class DiffHashes {
        private final String from;
        private final String to;

        public DiffHashes(CommentThreadDiffAnchor anchor) {
            Objects.requireNonNull(anchor, "anchor");
            this.from = Objects.requireNonNull((String)anchor.getFromHash().orElse(null), "anchor.fromHash");
            this.to = Objects.requireNonNull(anchor.getToHash(), "anchor.toHash");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DiffHashes) {
                DiffHashes d = (DiffHashes)o;
                return Objects.equals(this.from, d.from) && Objects.equals(this.to, d.to);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }
}

