/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;

public class CompositeCommentPostProcessor
implements CommentPostProcessor {
    private static final Timer PROCESS = Timers.timer((String)"process");
    private static final Timer PROCESS_COMMENTS = Timers.timer((String)"processComments");
    private static final Timer PROCESS_ROOTS = Timers.timer((String)"processRoots");
    private final List<CommentPostProcessor> postProcessors;

    public CompositeCommentPostProcessor(List<CommentPostProcessor> coreProcessors, CommentPostProcessor pluginCommentPostProcessor) {
        this.postProcessors = ImmutableList.builder().addAll(coreProcessors).add((Object)pluginCommentPostProcessor).build();
    }

    @Override
    @Profiled
    public InternalComment process(InternalCommentable entity, InternalComment comment) {
        for (CommentPostProcessor postProcessor : this.postProcessors) {
            Ticker ignored = PROCESS.start(new Object[]{postProcessor.getClass().getName(), comment.getId()});
            try {
                comment = postProcessor.process(entity, comment);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return comment;
    }

    @Override
    @Profiled
    public Set<InternalComment> processComments(InternalCommentable entity, Set<InternalComment> comments) {
        for (CommentPostProcessor postProcessor : this.postProcessors) {
            Ticker ignored = PROCESS_COMMENTS.start(new Object[]{postProcessor.getClass().getName(), comments.size()});
            try {
                comments = postProcessor.processComments(entity, comments);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return comments;
    }

    @Override
    @Profiled
    public Set<InternalComment> processRoots(InternalCommentable entity, Set<InternalComment> comments) {
        for (CommentPostProcessor postProcessor : this.postProcessors) {
            Ticker ignored = PROCESS_ROOTS.start(new Object[]{postProcessor.getClass().getName(), comments.size()});
            try {
                comments = postProcessor.processRoots(entity, comments);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return comments;
    }
}

