/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestStateGuard;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

public class DelegatingCommentUpdateProcessor
implements CommentUpdateProcessor {
    private final CommentUpdateProcessor delegate;
    private final PullRequestStateGuard stateGuard;
    private final TransactionSynchronizer transactionSynchronizer;

    public DelegatingCommentUpdateProcessor(CommentUpdateProcessor delegate, PullRequestStateGuard stateGuard, TransactionSynchronizer transactionSynchronizer) {
        this.delegate = delegate;
        this.stateGuard = stateGuard;
        this.transactionSynchronizer = transactionSynchronizer;
    }

    public void maybeProcess(InternalPullRequest pullRequest) {
        this.stateGuard.processIfUpdated(pullRequest, () -> {
            this.delegate.maybeProcess(pullRequest);
            return null;
        });
    }

    public void process(final InternalPullRequest pullRequest, final String previousFromHash, final String previousToHash) {
        this.transactionSynchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                DelegatingCommentUpdateProcessor.this.stateGuard.updated(pullRequest);
                DelegatingCommentUpdateProcessor.this.delegate.process(pullRequest, previousFromHash, previousToHash);
            }
        });
    }
}

