/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextBatch;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CommentContextDiffContentCallback
extends AbstractDiffContentCallback {
    private static final BinaryOperator<DiffContextBatch.Builder> THROWING_MERGER = (b1, b2) -> {
        throw new UnsupportedOperationException();
    };
    private final Map<String, DiffContextBatch> batchesByPath;
    private DiffContextBatch batch;

    public CommentContextDiffContentCallback(@Nonnull Set<InternalPullRequestCommentActivity> activities, @Nonnull PropertyMap properties, int maxMultilineSpanSize) {
        this.batchesByPath = CommentContextDiffContentCallback.mapBatches(activities, properties, maxMultilineSpanSize);
    }

    public void onDiffEnd(boolean truncated) {
        if (this.batch != null) {
            this.batch.endDiff();
            this.batch = null;
        }
    }

    public void onDiffStart(Path src, Path dst) {
        String path = dst == null ? src.toString() : dst.toString();
        this.batch = this.batchesByPath.get(path);
    }

    public void onHunkEnd(boolean truncated) {
        if (this.batch != null) {
            this.batch.endHunk();
        }
    }

    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, String context) {
        if (this.batch != null) {
            this.batch.startHunk(srcLine, dstLine, context);
        }
    }

    public void onSegmentLine(@Nonnull String line, ConflictMarker marker, boolean truncated) {
        if (this.batch != null) {
            this.batch.processLine(line, marker, truncated);
        }
    }

    public void onSegmentStart(@Nonnull DiffSegmentType type) {
        if (this.batch != null) {
            this.batch.startSegment(type);
        }
    }

    @Nonnull
    private static Map<String, DiffContextBatch> mapBatches(Set<InternalPullRequestCommentActivity> activities, PropertyMap properties, int maxMultilineSpanSize) {
        Map<String, DiffContextBatch> batchByPath = activities.stream().filter(activity -> activity.getComment().getAnchor().map(anchor -> anchor.isLineAnchor() && anchor.getFromHash().map(StringUtils::isNotBlank).orElse(false) != false).orElse(false)).collect(Collectors.groupingBy(activity -> ((CommentThreadDiffAnchor)activity.getComment().getAnchor().get()).getPath(), Collector.of(() -> new DiffContextBatch.Builder(properties, maxMultilineSpanSize), DiffContextBatch.Builder::activity, THROWING_MERGER, DiffContextBatch.Builder::build, new Collector.Characteristics[0])));
        if (batchByPath.isEmpty()) {
            throw new IllegalStateException("No line-anchored comments were found in the provided activities. Performing a diff to gather context is not necessary");
        }
        return batchByPath;
    }
}

