/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.SimpleDiff;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DiffComment {
    private final InternalPullRequestCommentActivity activity;
    private final InternalCommentThreadDiffAnchor anchor;
    private final InternalComment comment;
    private final PropertyMap properties;

    public DiffComment(@Nonnull InternalPullRequestCommentActivity activity, @Nonnull PropertyMap properties) {
        this.activity = Objects.requireNonNull(activity, "An activity is required");
        this.properties = Objects.requireNonNull(properties, "properties");
        this.comment = activity.getComment();
        this.anchor = this.comment.getAnchor().map(InternalConverter::convertToInternalAnchor).orElseThrow(() -> new IllegalArgumentException("Only anchored comments support gathering context"));
    }

    public void applyDiff(@Nonnull DiffHunk hunk) {
        SimpleDiff.Builder diffBuilder = (SimpleDiff.Builder)new SimpleDiff.Builder().destination(this.anchor.getPath()).hunk(hunk).properties((Map)this.properties);
        this.anchor.getSrcPath().ifPresent(srcPath -> {
            if (StringUtils.isNotBlank((CharSequence)srcPath)) {
                diffBuilder.source(srcPath);
            }
        });
        this.activity.setDiff((Diff)diffBuilder.build());
    }

    public long getId() {
        return this.comment.getId();
    }

    public boolean isDiffApplied() {
        return this.activity.getDiff().isPresent();
    }

    public boolean isLowerAnchoredOn(@Nonnull DiffContextLine line) {
        return this.anchor.getLineType().map(lineType -> line.isAnchor((DiffSegmentType)lineType, this.anchor.getLine())).orElse(false);
    }

    public boolean isMultiline() {
        return this.anchor.isMultilineAnchor();
    }

    public boolean isUpperAnchoredOn(@Nonnull DiffContextLine line) {
        if (this.anchor.isMultilineAnchor()) {
            return line.isAnchor((DiffSegmentType)this.anchor.getMultilineStartLineType().get(), (Integer)this.anchor.getMultilineStartLine().get());
        }
        return this.isLowerAnchoredOn(line);
    }
}

