/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.content.DiffSegment;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.SimpleDiffHunk;
import com.atlassian.bitbucket.content.SimpleDiffSegment;
import com.atlassian.stash.internal.pull.comment.diff.DiffComment;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public abstract class DiffContext {
    public abstract void done();

    public abstract boolean offer(DiffContextLine var1);

    protected static DiffComment checkNoDiff(@Nonnull DiffComment comment) {
        Objects.requireNonNull(comment, "comment");
        if (comment.isDiffApplied()) {
            throw new IllegalStateException("The DiffComment has already had a diff applied to it");
        }
        return comment;
    }

    protected static DiffHunk newDiffHunk(@Nonnull Iterable<DiffContextLine> context) {
        Objects.requireNonNull(context, "context");
        SimpleDiffHunk.Builder hunkBuilder = new SimpleDiffHunk.Builder();
        SimpleDiffSegment.Builder segmentBuilder = null;
        DiffSegmentType type = null;
        int sourceSpan = 0;
        int destSpan = 0;
        for (DiffContextLine contextLine : context) {
            if (segmentBuilder == null || type != contextLine.getType()) {
                if (segmentBuilder == null) {
                    hunkBuilder.context(contextLine.getContext()).destinationLine(contextLine.getDestination()).sourceLine(contextLine.getSource());
                } else {
                    hunkBuilder.segment((DiffSegment)segmentBuilder.build());
                }
                segmentBuilder = contextLine.startNewSegment();
                type = contextLine.getType();
            } else {
                contextLine.addToSegment(segmentBuilder);
            }
            if (type.isInSource()) {
                ++sourceSpan;
            }
            if (!type.isInDestination()) continue;
            ++destSpan;
        }
        if (segmentBuilder != null) {
            hunkBuilder.sourceSpan(sourceSpan).destinationSpan(destSpan).segment((DiffSegment)segmentBuilder.build());
        }
        return hunkBuilder.build();
    }
}

