/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.content.DiffLines;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.comment.diff.DiffComment;
import com.atlassian.stash.internal.pull.comment.diff.DiffContext;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextWindow;
import com.atlassian.stash.internal.pull.comment.diff.MultilineDiffContext;
import com.atlassian.stash.internal.pull.comment.diff.SingleLineDiffContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffContextBatch {
    private static final Logger log = LoggerFactory.getLogger(DiffContextBatch.class);
    private final List<DiffContext> building;
    private final Set<DiffComment> foundComments;
    private final int maxMultilineSpanSize;
    private final Set<DiffComment> searchComments;
    private final DiffContextWindow window;
    private DiffLines lines;
    private DiffSegmentType segmentType;

    private DiffContextBatch(@Nonnull Builder builder) {
        ImmutableSet activities = builder.activities.build();
        Preconditions.checkArgument((!((Set)Objects.requireNonNull(activities, "activities")).isEmpty() ? 1 : 0) != 0, (Object)"At least one activity is required for the batch");
        this.searchComments = activities.stream().map(activity -> new DiffComment((InternalPullRequestCommentActivity)activity, builder.properties)).collect(Collectors.toSet());
        log.debug("Searching for context for {} comment(s)", (Object)this.searchComments.size());
        this.building = Lists.newArrayListWithCapacity((int)activities.size());
        this.maxMultilineSpanSize = builder.maxMultilineSpanSize;
        this.foundComments = Sets.newHashSetWithExpectedSize((int)activities.size());
        this.window = new DiffContextWindow();
    }

    public void endDiff() {
        if (!this.building.isEmpty()) {
            log.warn("endHunk() was not called for the final hunk before calling done(); {} comment(s) were still assembling their context", (Object)this.building.size());
            this.endHunk();
        }
        if (this.searchComments.isEmpty()) {
            log.debug("Context has been applied for all {} comment(s)", (Object)this.foundComments.size());
        } else {
            log.debug("Context has been applied for {} comment(s); {} comment(s) were not found", (Object)this.foundComments.size(), (Object)this.searchComments.size());
        }
    }

    public void endHunk() {
        for (DiffContext context : this.building) {
            context.done();
        }
        this.building.clear();
        this.window.clear();
    }

    public void processLine(String line, ConflictMarker marker, boolean truncated) {
        if (this.building.isEmpty() && this.searchComments.isEmpty()) {
            return;
        }
        DiffContextLine contextLine = this.lines.withLines(this.segmentType, line, marker, truncated, DiffContextLine::new);
        Iterator<DiffContext> workingIterator = this.building.iterator();
        while (workingIterator.hasNext()) {
            DiffContext context = workingIterator.next();
            if (context.offer(contextLine)) continue;
            context.done();
            workingIterator.remove();
        }
        Iterator<DiffComment> searchIterator = this.searchComments.iterator();
        while (searchIterator.hasNext()) {
            DiffComment comment = searchIterator.next();
            if (!comment.isUpperAnchoredOn(contextLine)) continue;
            if (comment.isMultiline()) {
                this.building.add(new MultilineDiffContext(comment, contextLine, this.maxMultilineSpanSize));
            } else {
                this.building.add(new SingleLineDiffContext(comment, contextLine, this.window.snapshot()));
            }
            this.foundComments.add(comment);
            searchIterator.remove();
        }
        this.window.slide(contextLine);
    }

    public void startHunk(int srcLine, int dstLine, String context) {
        this.lines = new DiffLines(srcLine, dstLine, context);
    }

    public void startSegment(DiffSegmentType segmentType) {
        this.segmentType = segmentType;
    }

    public static class Builder
    extends BuilderSupport {
        private final PropertyMap properties;
        private final ImmutableSet.Builder<InternalPullRequestCommentActivity> activities;
        private final int maxMultilineSpanSize;

        public Builder(@Nonnull PropertyMap value, int maxMultilineSpanSize) {
            this.properties = new PropertyMap.Builder().properties((Map)Objects.requireNonNull(value, "properties")).build();
            this.activities = ImmutableSet.builder();
            this.maxMultilineSpanSize = maxMultilineSpanSize;
        }

        @Nonnull
        public Builder activity(@Nonnull InternalPullRequestCommentActivity value) {
            Builder.addIf(Objects::nonNull, this.activities, (Object)value);
            return this;
        }

        @Nonnull
        public DiffContextBatch build() {
            return new DiffContextBatch(this);
        }
    }
}

