/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffLine;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.SimpleDiffLine;
import com.atlassian.bitbucket.content.SimpleDiffSegment;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class DiffContextLine {
    private final Long commentId;
    private final int commentLine;
    private final ConflictMarker conflictMarker;
    private final String context;
    private final int destination;
    private final String line;
    private final int source;
    private final boolean truncated;
    private final DiffSegmentType type;

    public DiffContextLine(@Nonnull DiffSegmentType type, int source, int destination, String context, @Nonnull String line, ConflictMarker conflictMarker, boolean truncated) {
        this(type, source, destination, context, line, conflictMarker, truncated, null);
    }

    private DiffContextLine(@Nonnull DiffSegmentType type, int source, int destination, String context, @Nonnull String line, ConflictMarker conflictMarker, boolean truncated, Long commentId) {
        this.commentId = commentId;
        this.conflictMarker = conflictMarker;
        this.context = context;
        this.destination = destination;
        this.line = line;
        this.source = source;
        this.truncated = truncated;
        this.type = Objects.requireNonNull(type, "type");
        this.commentLine = type == DiffSegmentType.ADDED ? destination : source;
    }

    public void addToSegment(SimpleDiffSegment.Builder segmentBuilder) {
        segmentBuilder.line((DiffLine)this.newDiffLine());
    }

    @Nullable
    public String getContext() {
        return this.context;
    }

    public int getDestination() {
        return this.destination;
    }

    public int getSource() {
        return this.source;
    }

    @Nonnull
    public DiffSegmentType getType() {
        return this.type;
    }

    public boolean isAnchor(@Nonnull DiffSegmentType anchorLineType, int anchorLine) {
        return anchorLineType == this.type && anchorLine == this.commentLine;
    }

    @Nonnull
    public SimpleDiffSegment.Builder startNewSegment() {
        return new SimpleDiffSegment.Builder().line((DiffLine)this.newDiffLine()).type(this.type);
    }

    @Nonnull
    public DiffContextLine withComment(long id) {
        if (this.commentId == null || id == this.commentId) {
            return new DiffContextLine(this.type, this.source, this.destination, this.context, this.line, this.conflictMarker, this.truncated, id);
        }
        throw new IllegalStateException("This DiffContextLine already references comment " + this.commentId);
    }

    @Nonnull
    private SimpleDiffLine newDiffLine() {
        SimpleDiffLine.Builder builder = new SimpleDiffLine.Builder().conflictMarker(this.conflictMarker).destination(this.destination).line(this.line).source(this.source).truncated(this.truncated);
        if (this.commentId != null) {
            builder.commentId(this.commentId.longValue());
        }
        return builder.build();
    }
}

