/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class DiffContextWindow {
    public static final int CONTEXT_SIZE = 10;
    private final Deque<DiffContextLine> window = new LinkedList<DiffContextLine>();

    public void clear() {
        this.window.clear();
    }

    public boolean isFull() {
        return this.window.size() == 10;
    }

    public boolean offer(DiffContextLine line) {
        if (this.window.size() < 10) {
            this.window.add(line);
        }
        return !this.isFull();
    }

    public void slide(DiffContextLine line) {
        if (this.isFull()) {
            this.window.pop();
        }
        this.window.add(line);
    }

    @Nonnull
    public List<DiffContextLine> snapshot() {
        return ImmutableList.copyOf(this.window);
    }
}

