/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.stash.internal.pull.comment.diff.DiffComment;
import com.atlassian.stash.internal.pull.comment.diff.DiffContext;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilineDiffContext
extends DiffContext {
    private static final Logger log = LoggerFactory.getLogger(MultilineDiffContext.class);
    private final DiffComment comment;
    private final Deque<DiffContextLine> commentLines;
    private final int maxCommentLength;

    public MultilineDiffContext(@Nonnull DiffComment comment, @Nonnull DiffContextLine line, int maxMultilineSpanSize) {
        this.comment = MultilineDiffContext.checkNoDiff(Objects.requireNonNull(comment, "comment"));
        Preconditions.checkArgument((boolean)comment.isMultiline(), (Object)"Multiline diff contexts can only be created for multiline comments");
        this.commentLines = new LinkedList<DiffContextLine>();
        this.commentLines.add(Objects.requireNonNull(line, "line"));
        this.maxCommentLength = maxMultilineSpanSize * 2;
    }

    @Override
    public void done() {
        if (!this.commentLines.isEmpty() && this.comment.isLowerAnchoredOn(this.commentLines.peekLast())) {
            MultilineDiffContext.checkNoDiff(this.comment).applyDiff(MultilineDiffContext.newDiffHunk(this.commentLines));
        }
    }

    @Override
    public boolean offer(@Nonnull DiffContextLine line) {
        Objects.requireNonNull(line, "line");
        if (this.comment.isLowerAnchoredOn(line)) {
            this.commentLines.add(line.withComment(this.comment.getId()));
            return false;
        }
        this.commentLines.add(line);
        if (this.commentLines.size() >= this.maxCommentLength) {
            log.debug("Lower line anchor for comment {} not found with {} lines, returning no context", (Object)this.comment.getId(), (Object)this.maxCommentLength);
            return false;
        }
        return true;
    }
}

