/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.stash.internal.pull.comment.diff.DiffComment;
import com.atlassian.stash.internal.pull.comment.diff.DiffContext;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextWindow;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class SingleLineDiffContext
extends DiffContext {
    private final DiffContextWindow afterWindow;
    private final DiffComment comment;
    private final DiffContextLine commentLine;
    private final List<DiffContextLine> linesBefore;

    public SingleLineDiffContext(@Nonnull DiffComment comment, @Nonnull DiffContextLine line, @Nonnull List<DiffContextLine> linesBefore) {
        this.comment = SingleLineDiffContext.checkNoDiff(Objects.requireNonNull(comment, "comment"));
        Preconditions.checkArgument((!comment.isMultiline() ? 1 : 0) != 0, (Object)"Single line diff contexts can only be created for single line comments");
        this.linesBefore = Objects.requireNonNull(linesBefore, "linesBefore");
        this.afterWindow = new DiffContextWindow();
        this.commentLine = Objects.requireNonNull(line, "line").withComment(comment.getId());
    }

    @Override
    public void done() {
        Iterable diffHunk = Iterables.concat(this.linesBefore, List.of(this.commentLine), this.afterWindow.snapshot());
        SingleLineDiffContext.checkNoDiff(this.comment).applyDiff(SingleLineDiffContext.newDiffHunk(diffHunk));
    }

    @Override
    public boolean offer(@Nonnull DiffContextLine line) {
        return this.afterWindow.offer(Objects.requireNonNull(line, "line"));
    }
}

