/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class CommentDriftStrategyChain {
    private static final Logger log = LoggerFactory.getLogger(CommentDriftStrategyChain.class);
    private final CommentDriftStrategy fallbackStrategy;
    private final List<CommentDriftStrategy> strategies;

    public CommentDriftStrategyChain(List<CommentDriftStrategy> strategies, CommentDriftStrategy fallbackStrategy) {
        this.fallbackStrategy = fallbackStrategy;
        this.strategies = new ArrayList<CommentDriftStrategy>(strategies);
        AnnotationAwareOrderComparator.sort(this.strategies);
    }

    public void applyTo(@Nonnull DriftContext context) {
        InternalPullRequest pullRequest = context.getPullRequest();
        long pullRequestId = pullRequest.getGlobalId();
        for (CommentDriftStrategy strategy : this.strategies) {
            try {
                Timer ignored = CommentDriftStrategyChain.timerFor(pullRequestId, strategy);
                try {
                    strategy.apply(context);
                    if (!context.isEmpty()) continue;
                    return;
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (NoSuchCommitException e) {
                log.error("{}:{}@{}: The {} drift strategy could not complete because commit {} is missing. Further strategies will not be attempted.", new Object[]{pullRequest.getScopeRepository().getId(), pullRequestId, pullRequest.getVersion(), strategy.getName(), e.getCommitId()});
                break;
            }
        }
        try (Timer ignored = CommentDriftStrategyChain.timerFor(pullRequestId, this.fallbackStrategy);){
            this.fallbackStrategy.apply(context);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Chain ([");
        boolean first = true;
        for (CommentDriftStrategy strategy : this.strategies) {
            if (first) {
                first = false;
            } else {
                builder.append(" -> ");
            }
            builder.append(strategy.getName());
        }
        return builder.append("], or ").append(this.fallbackStrategy.getName()).append(")").toString();
    }

    private static Timer timerFor(long pullRequestId, CommentDriftStrategy strategy) {
        return TimerUtils.start((String)("Drift: Strategy - " + strategy.getName() + " " + pullRequestId));
    }
}

