/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ChangesCommandParameters;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.stash.internal.pull.comment.drift.DriftScmHelper;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="driftScmHelper")
public class DefaultDriftScmHelper
implements DriftScmHelper {
    private final ScmService scmService;
    @Value(value="${pullrequest.diff.context}")
    private int diffContext;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;
    @Value(value="${pullrequest.rescope.drift.commandtimeout}")
    private long timeout;

    @Autowired
    public DefaultDriftScmHelper(ScmService scmService) {
        this.scmService = scmService;
    }

    @Override
    public void streamChanges(@Nonnull Repository repository, @Nonnull String sinceId, @Nonnull String untilId, @Nonnull Set<String> paths, @Nonnull ChangeCallback callback) {
        ChangesCommandParameters parameters = ((ChangesCommandParameters.Builder)((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder().maxChanges(this.maxChanges)).paths(paths)).sinceId(sinceId).untilId(untilId).build();
        this.configureAndCall(this.scmService.getCommandFactory(repository).changes(parameters, callback));
    }

    @Override
    public void streamDiff(@Nonnull Repository repository, @Nonnull String sinceId, @Nonnull String untilId, @Nonnull Set<String> paths, boolean withContext, @Nonnull DiffContentCallback callback) {
        DiffCommandParameters parameters = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(withContext ? this.diffContext : 0)).maxLineLength(this.maxLineLength)).maxLines(Integer.MAX_VALUE)).paths(paths)).sinceId(sinceId).untilId(untilId).build();
        this.configureAndCall(this.scmService.getCommandFactory(repository).diff(parameters, callback));
    }

    private void configureAndCall(Command<?> command) {
        command.setTimeout(this.timeout);
        command.call();
    }
}

