/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.DriftResult;
import com.atlassian.stash.internal.pull.comment.drift.DriftScmHelper;
import com.atlassian.stash.internal.pull.comment.drift.ProcessedThreadSpanBuilder;
import com.atlassian.stash.internal.pull.comment.drift.SpanType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class DiffCommentDriftStrategy
implements CommentDriftStrategy {
    private static final Logger log = LoggerFactory.getLogger(DiffCommentDriftStrategy.class);
    private final DriftScmHelper scmHelper;

    @Autowired
    public DiffCommentDriftStrategy(DriftScmHelper scmHelper) {
        this.scmHelper = scmHelper;
    }

    @Override
    public void apply(@Nonnull DriftContext context) {
        DriftResult result = this.processThreads(context);
        result.applyTo(context);
    }

    @Override
    public String getName() {
        return "Diff";
    }

    private DriftResult calculateDrift(Repository repository, String untilId, String sinceId, Iterable<InternalCommentThread> threads, SpanType spanType) {
        DriftDiffContentCallback callback = new DriftDiffContentCallback(threads, spanType);
        this.scmHelper.streamDiff(repository, sinceId, untilId, DriftContext.toPaths(threads), false, (DiffContentCallback)callback);
        return callback.getResult();
    }

    private DriftResult calculateDriftInSource(DriftContext context, List<InternalCommentThread> threads) {
        InternalPullRequest pullRequest = context.getPullRequest();
        if (threads.isEmpty()) {
            log.debug("{}: No comments have been anchored to ADDED lines or have source spans; skipping drift calculation", (Object)pullRequest.getGlobalId());
            return new DriftResult();
        }
        String previousDiffHash = context.getPreviousDiff().getUntilId();
        String diffHash = context.getCurrentDiff().getUntilId();
        if (log.isDebugEnabled()) {
            log.debug("{}: Calculating drift from {} to {} for {} threads on ADDED lines or with destination spans", new Object[]{pullRequest.getGlobalId(), previousDiffHash, diffHash, threads.size()});
        }
        String timerName = "Drift: " + this.getName() + " - Merge diff [" + previousDiffHash + "]->[" + diffHash + "] " + pullRequest.getGlobalId();
        try (Timer ignored = TimerUtils.start((String)timerName);){
            DriftResult driftResult = this.calculateDrift((Repository)context.getRepository(), diffHash, previousDiffHash, threads, SpanType.DESTINATION);
            return driftResult;
        }
    }

    private DriftResult calculateDriftInTarget(DriftContext context, List<InternalCommentThread> threads) {
        String toHash;
        InternalPullRequest pullRequest = context.getPullRequest();
        if (threads.isEmpty()) {
            log.debug("{}: No comments have been anchored to CONTEXT or REMOVED lines, or have source spans; skipping drift calculation", (Object)pullRequest.getGlobalId());
            return new DriftResult();
        }
        String previousToHash = context.getPreviousToHash();
        if (previousToHash.equals(toHash = context.getPullRequest().getToRef().getLatestCommit())) {
            log.debug("{}: The target branch has not been updated; skipping drift calculation", (Object)pullRequest.getGlobalId());
            return DriftResult.forRetained(threads);
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: Calculating drift from {} to {} for {} threads on CONTEXT/REMOVED lines or with source spans", new Object[]{pullRequest.getGlobalId(), previousToHash, toHash, threads.size()});
        }
        String timerName = "Drift: " + this.getName() + " - Target diff [" + previousToHash + "]->[" + toHash + "] " + pullRequest.getGlobalId();
        try (Timer ignored = TimerUtils.start((String)timerName);){
            DriftResult driftResult = this.calculateDrift((Repository)context.getRepository(), toHash, previousToHash, threads, SpanType.SOURCE);
            return driftResult;
        }
    }

    private Set<DriftResult.ProcessedThread> detectOrphans(DriftContext context, DriftResult mergedDrift) {
        InternalPullRequest pullRequest = context.getPullRequest();
        List<DriftResult.ProcessedThread> reachableThreads = mergedDrift.getReachableThreads();
        if (reachableThreads.isEmpty()) {
            log.debug("{}: After calculating drift, all comments have been orphaned", (Object)pullRequest.getGlobalId());
            return Collections.emptySet();
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: Validating {} threads(s)", (Object)pullRequest.getGlobalId(), (Object)reachableThreads.size());
        }
        PullRequestEffectiveDiff currentDiff = context.getCurrentDiff();
        OrphanDetectingDiffContentCallback callback = new OrphanDetectingDiffContentCallback(reachableThreads);
        String timerName = "Drift: " + this.getName() + " - Effective diff [" + currentDiff.getSinceId() + "]->[" + currentDiff.getUntilId() + "] " + pullRequest.getGlobalId();
        try (Timer ignored = TimerUtils.start((String)timerName);){
            this.scmHelper.streamDiff((Repository)context.getRepository(), currentDiff.getSinceId(), currentDiff.getUntilId(), DriftContext.toPaths(Iterables.transform(reachableThreads, DriftResult.ProcessedThread::getThread)), true, (DiffContentCallback)callback);
        }
        return callback.done();
    }

    private static Map<SpanType, List<InternalCommentThread>> mapThreadsBySpanType(DriftContext context) {
        EnumMap<SpanType, List<InternalCommentThread>> threadsBySpanType = new EnumMap<SpanType, List<InternalCommentThread>>(SpanType.class);
        for (SpanType value : SpanType.values()) {
            threadsBySpanType.put(value, new ArrayList());
        }
        MoreStreams.streamIterable((Iterable)context).filter(t -> t.getAnchor().map(CommentThreadDiffAnchor::isLineAnchor).orElse(false)).forEach(thread -> {
            InternalCommentThreadDiffAnchor anchor = InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)((CommentThreadDiffAnchor)thread.getAnchor().get()));
            if (!anchor.isMultilineAnchor()) {
                ((List)threadsBySpanType.get((Object)SpanType.fromSegmentType((DiffSegmentType)anchor.getLineType().get()))).add(thread);
            } else {
                if (anchor.getSrcSpanStart().isPresent()) {
                    ((List)threadsBySpanType.get((Object)SpanType.SOURCE)).add(thread);
                }
                if (anchor.getDstSpanStart().isPresent()) {
                    ((List)threadsBySpanType.get((Object)SpanType.DESTINATION)).add(thread);
                }
            }
        });
        return threadsBySpanType;
    }

    private DriftResult processThreads(DriftContext context) {
        Map<SpanType, List<InternalCommentThread>> threadsByType = DiffCommentDriftStrategy.mapThreadsBySpanType(context);
        DriftResult sourceDrift = this.calculateDriftInSource(context, threadsByType.get((Object)SpanType.DESTINATION));
        DriftResult targetDrift = this.calculateDriftInTarget(context, threadsByType.get((Object)SpanType.SOURCE));
        DriftResult mergedDrifts = sourceDrift.merge(targetDrift);
        Set<DriftResult.ProcessedThread> orphaned = this.detectOrphans(context, mergedDrifts);
        return mergedDrifts.orphan(Iterables.transform(orphaned, DriftResult.ProcessedThread::getThread));
    }

    @VisibleForTesting
    static class DriftDiffContentCallback
    extends AbstractDiffContentCallback {
        private final Map<String, List<InternalCommentThread>> threadsByPath = new HashMap<String, List<InternalCommentThread>>();
        private final Map<Long, LineNumberRange> threadsBySpan = new HashMap<Long, LineNumberRange>();
        private final DriftResult result = new DriftResult();
        private List<InternalCommentThread> workingThreads;
        private int workingDrift;
        private final SpanType spanType;

        @VisibleForTesting
        DriftDiffContentCallback(Iterable<InternalCommentThread> threads, SpanType spanType) {
            this.spanType = spanType;
            MoreStreams.streamIterable(threads).forEach(thread -> {
                InternalCommentThreadDiffAnchor anchor = (InternalCommentThreadDiffAnchor)thread.getAnchor().get();
                this.threadsByPath.computeIfAbsent(anchor.getPath(), path -> new ArrayList()).add(thread);
                if (!anchor.isMultilineAnchor()) {
                    this.threadsBySpan.put(thread.getId(), new LineNumberRange(anchor.getLine(), anchor.getLine()));
                } else {
                    switch (spanType) {
                        case SOURCE: {
                            this.threadsBySpan.put(thread.getId(), new LineNumberRange(((Integer)anchor.getSrcSpanStart().get()).intValue(), ((Integer)anchor.getSrcSpanEnd().get()).intValue()));
                            break;
                        }
                        case DESTINATION: {
                            this.threadsBySpan.put(thread.getId(), new LineNumberRange(((Integer)anchor.getDstSpanStart().get()).intValue(), ((Integer)anchor.getDstSpanEnd().get()).intValue()));
                        }
                    }
                }
            });
        }

        public DriftResult getResult() {
            return this.result;
        }

        public void onDiffEnd(boolean truncated) {
            if (CollectionUtils.isNotEmpty(this.workingThreads)) {
                this.workingThreads.forEach(this::drift);
                this.workingThreads = null;
            }
        }

        public void onDiffStart(Path src, Path dst) {
            if (src != null) {
                this.workingThreads = this.threadsByPath.remove(src.toString());
            }
            this.workingDrift = 0;
        }

        public void onEnd(@Nonnull DiffSummary summary) {
            this.threadsByPath.values().forEach(this.result::retain);
        }

        public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, String context) {
            if (this.workingThreads == null) {
                return;
            }
            LineNumberRange deletedLinesRange = srcSpan > 0 ? new LineNumberRange(srcLine, srcLine + srcSpan - 1) : null;
            this.workingThreads.removeIf(thread -> thread.getAnchor().map(anchor -> {
                LineNumberRange commentSpan = this.threadsBySpan.get(thread.getId());
                if (commentSpan.maximum() < srcLine || srcSpan == 0 && commentSpan.maximum() == srcLine) {
                    this.drift((InternalCommentThread)thread);
                    return true;
                }
                if (srcSpan > 0 && commentSpan.overlaps(deletedLinesRange)) {
                    this.result.orphan((InternalCommentThread)thread);
                    return true;
                }
                if (dstSpan > 0 && commentSpan.contains(srcLine) && commentSpan.maximum() != srcLine) {
                    this.result.orphan((InternalCommentThread)thread);
                    return true;
                }
                return false;
            }).orElse(false));
            this.workingDrift += dstSpan - srcSpan;
        }

        private void drift(InternalCommentThread thread) {
            this.result.drift(this.workingDrift, thread, this.spanType);
        }
    }

    @VisibleForTesting
    static class OrphanDetectingDiffContentCallback
    extends AbstractDiffContentCallback {
        private final List<ProcessedThreadSpanBuilder> currentMultilineThreads;
        private final Set<DriftResult.ProcessedThread> orphanedThreads;
        private final Map<String, Map<DiffSegmentType, Map<Integer, List<DriftResult.ProcessedThread>>>> typesByPath = new HashMap<String, Map<DiffSegmentType, Map<Integer, List<DriftResult.ProcessedThread>>>>();
        private int currentDestinationLine;
        private String currentPath;
        private Map<DiffSegmentType, Map<Integer, List<DriftResult.ProcessedThread>>> currentPathTypes;
        private DiffSegmentType currentSegmentType;
        private int currentSourceLine;
        private Map<Integer, List<DriftResult.ProcessedThread>> currentTypeLines;

        @VisibleForTesting
        OrphanDetectingDiffContentCallback(Iterable<DriftResult.ProcessedThread> processedThreads) {
            this.currentMultilineThreads = new ArrayList<ProcessedThreadSpanBuilder>();
            this.orphanedThreads = new HashSet<DriftResult.ProcessedThread>();
            processedThreads.forEach(processedThread -> {
                int startLine = processedThread.getStartLine().orElse(processedThread.getLine());
                DiffSegmentType startLineType = processedThread.getStartLineType().orElse(processedThread.getLineType().get());
                this.typesByPath.computeIfAbsent(processedThread.getPath(), path -> new HashMap()).computeIfAbsent(startLineType, lineType -> new HashMap()).computeIfAbsent(startLine, line -> new ArrayList()).add(processedThread);
            });
        }

        public Set<DriftResult.ProcessedThread> done() {
            for (Map<DiffSegmentType, Map<Integer, List<DriftResult.ProcessedThread>>> linesByType : this.typesByPath.values()) {
                for (Map<Integer, List<DriftResult.ProcessedThread>> threadsByLine : linesByType.values()) {
                    threadsByLine.values().forEach(this.orphanedThreads::addAll);
                }
            }
            return this.orphanedThreads;
        }

        public void onDiffEnd(boolean truncated) {
            this.currentPath = null;
            this.currentPathTypes = null;
            this.currentMultilineThreads.forEach(spanBuilder -> this.orphanedThreads.add(spanBuilder.getThread()));
            this.currentMultilineThreads.clear();
        }

        public void onDiffStart(Path src, Path dst) {
            if (dst != null) {
                this.currentPath = dst.toString();
            } else if (src != null) {
                this.currentPath = src.toString();
            }
            this.currentPathTypes = this.typesByPath.get(this.currentPath);
        }

        public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, String context) {
            this.currentDestinationLine = dstLine;
            this.currentSourceLine = srcLine;
        }

        public void onSegmentEnd(boolean truncated) {
            this.currentSegmentType = null;
            this.currentTypeLines = null;
        }

        public void onSegmentLine(@Nonnull String line, ConflictMarker marker, boolean truncated) {
            if (this.currentSegmentType == null) {
                return;
            }
            Iterator<ProcessedThreadSpanBuilder> builderIterator = this.currentMultilineThreads.iterator();
            while (builderIterator.hasNext()) {
                ProcessedThreadSpanBuilder spanBuilder = builderIterator.next();
                if (!spanBuilder.addToSpansAndCheckIfEnd(this.currentSourceLine, this.currentDestinationLine, this.currentSegmentType)) continue;
                builderIterator.remove();
                if (!spanBuilder.spansMatchThread()) {
                    this.orphanedThreads.add(spanBuilder.getThread());
                }
                if (!this.currentPathTypes.isEmpty() || !this.currentMultilineThreads.isEmpty()) continue;
                this.currentPathTypes = null;
                this.currentSegmentType = null;
                this.typesByPath.remove(this.currentPath);
                return;
            }
            int commentLine = this.chooseCommentLine();
            if (this.currentTypeLines != null && this.currentTypeLines.containsKey(commentLine)) {
                List<DriftResult.ProcessedThread> threads = this.currentTypeLines.remove(commentLine);
                threads.forEach(thread -> {
                    if (thread.isMultiline()) {
                        this.currentMultilineThreads.add(new ProcessedThreadSpanBuilder((DriftResult.ProcessedThread)thread, this.currentSourceLine, this.currentDestinationLine, this.currentSegmentType));
                    }
                });
                if (this.currentTypeLines.isEmpty()) {
                    this.currentTypeLines = null;
                    this.currentPathTypes.remove(this.currentSegmentType);
                    if (this.currentPathTypes.isEmpty() && this.currentMultilineThreads.isEmpty()) {
                        this.currentPathTypes = null;
                        this.currentSegmentType = null;
                        this.typesByPath.remove(this.currentPath);
                        return;
                    }
                }
            }
            this.incrementLines();
        }

        public void onSegmentStart(@Nonnull DiffSegmentType type) {
            if (this.currentPathTypes != null) {
                this.currentSegmentType = type;
                this.currentTypeLines = this.currentPathTypes.get(type);
            }
        }

        private int chooseCommentLine() {
            return switch (this.currentSegmentType) {
                default -> throw new MatchException(null, null);
                case DiffSegmentType.ADDED -> this.currentDestinationLine;
                case DiffSegmentType.CONTEXT, DiffSegmentType.REMOVED -> this.currentSourceLine;
            };
        }

        private int incrementLines() {
            int n;
            switch (this.currentSegmentType) {
                default: {
                    throw new MatchException(null, null);
                }
                case ADDED: {
                    int n2 = this.currentDestinationLine;
                    n = n2;
                    this.currentDestinationLine = n2 + 1;
                    break;
                }
                case CONTEXT: {
                    ++this.currentDestinationLine;
                }
                case REMOVED: {
                    int n3 = this.currentSourceLine;
                    n = n3;
                    this.currentSourceLine = n3 + 1;
                }
            }
            return n;
        }
    }
}

