/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.PullRequestCommitsCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalCommentService;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftRequestDao;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategyChain;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.InternalDriftRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DriftCommentUpdateProcessor
implements CommentUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(DriftCommentUpdateProcessor.class);
    private static final Duration DURATION_RECENT = Duration.ofHours(2L);
    private final InternalCommentService commentService;
    private final CommentDriftRequestDao driftRequestDao;
    private final ExecutorService executorService;
    private final LockService lockService;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final CommentDriftStrategyChain strategyChain;
    private final TransactionTemplate transactionTemplate;
    private int maxAttempts;

    public DriftCommentUpdateProcessor(InternalCommentService commentService, CommentDriftRequestDao driftRequestDao, ExecutorService executorService, LockService lockService, ScmService scmService, SecurityService securityService, CommentDriftStrategyChain strategyChain, PlatformTransactionManager transactionManager) {
        this.commentService = commentService;
        this.driftRequestDao = driftRequestDao;
        this.executorService = executorService;
        this.lockService = lockService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.strategyChain = strategyChain;
        this.maxAttempts = 5;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public void maybeProcess(InternalPullRequest pullRequest) {
        new CommentDriftBootstrapper(pullRequest).run();
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.securityService.withPermission(Permission.REPO_WRITE, "Reschedule pending comment drift requests").call((Operation)new CommentDriftLoader());
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent rescopedEvent) {
        this.transactionTemplate.execute(status -> {
            InternalPullRequest pullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)rescopedEvent.getPullRequest());
            try (Timer ignored = TimerUtils.start((String)("Drift: Orphan removed commits activity - " + pullRequest.getGlobalId()));){
                List threads = this.commentService.searchThreads(new CommentSearchRequest.Builder((Commentable)pullRequest).diffTypes((Iterable)ImmutableSet.of((Object)CommentThreadDiffAnchorType.COMMIT, (Object)CommentThreadDiffAnchorType.RANGE)).states(EnumSet.allOf(CommentState.class)).build(), false, false);
                if (!threads.isEmpty()) {
                    RescopeDetails rescopeDetails = rescopedEvent.getRemovedCommits();
                    if (rescopeDetails == null || rescopeDetails.getTotal() > rescopeDetails.getCommits().size()) {
                        this.orphan(this.findOrphanedThreads((PullRequest)pullRequest, threads).stream());
                    } else if (rescopeDetails.getTotal() > 0) {
                        this.orphan(threads.stream().filter(thread -> thread.getAnchor().map(anchor -> rescopeDetails.getCommits().stream().anyMatch(commit -> this.anchorMatches((CommentThreadDiffAnchor)anchor, (Commit)commit))).orElse(false)));
                    }
                }
            }
            return null;
        });
    }

    public void process(InternalPullRequest pullRequest, String previousFromHash, String previousToHash) {
        InternalDriftRequest request = new InternalDriftRequest(null, pullRequest, previousFromHash, previousToHash, pullRequest.getFromRef().getLatestCommit(), pullRequest.getToRef().getLatestCommit());
        try {
            this.transactionTemplate.execute(status -> this.driftRequestDao.create(request));
            this.executorService.submit(new CommentDriftBootstrapper(request.getPullRequest()));
        }
        catch (Exception e) {
            log.error("{}:{}@{}: Problem persisting drift request", new Object[]{pullRequest.getScopeRepository().getId(), pullRequest.getId(), pullRequest.getVersion(), e});
        }
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    private boolean anchorMatches(CommentThreadDiffAnchor anchor, Commit commit) {
        return Objects.equals(anchor.getToHash(), commit.getId());
    }

    private List<InternalCommentThread> findOrphanedThreads(PullRequest pullRequest, List<InternalCommentThread> currentThreads) {
        ArrayList<InternalCommentThread> maybeOrphaned = new ArrayList<InternalCommentThread>(currentThreads);
        this.scmService.getPullRequestCommandFactory(pullRequest).commits(new PullRequestCommitsCommandParameters.Builder().withMessages(false).build(), commit -> {
            maybeOrphaned.removeIf(thread -> this.anchorMatches((CommentThreadDiffAnchor)thread.getAnchor().get(), commit));
            return !maybeOrphaned.isEmpty();
        }).call();
        return maybeOrphaned;
    }

    private void orphan(@Nonnull Stream<InternalCommentThread> toOrphan) {
        this.commentService.updateThreads(toOrphan.map(thread -> new InternalCommentThread.Builder(thread).anchor((InternalCommentThreadDiffAnchor)thread.getAnchor().map(anchor -> new InternalCommentThreadDiffAnchor.Builder(InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)anchor)).orphaned(true).build()).orElse(null)).build()));
    }

    private class CommentDriftBootstrapper
    implements Runnable,
    UncheckedOperation<Void> {
        private final InternalPullRequest cachedPullRequest;

        private CommentDriftBootstrapper(InternalPullRequest cachedPullRequest) {
            this.cachedPullRequest = cachedPullRequest;
        }

        public Void perform() {
            return (Void)DriftCommentUpdateProcessor.this.lockService.getPullRequestLock(CommentUpdateProcessor.class.getName()).withLock((PullRequest)this.cachedPullRequest, (Operation)new CommentDriftOperation(this.cachedPullRequest));
        }

        @Override
        public void run() {
            DriftCommentUpdateProcessor.this.securityService.withPermission(Permission.REPO_READ, "Performing comment drift").call((Operation)this);
        }
    }

    private class CommentDriftLoader
    extends TransactionCallbackWithoutResult
    implements UncheckedOperation<Void> {
        private CommentDriftLoader() {
        }

        protected void doInTransactionWithoutResult(@Nonnull TransactionStatus status) {
            List pullRequests = DriftCommentUpdateProcessor.this.driftRequestDao.findPendingPullRequests(DriftCommentUpdateProcessor.this.maxAttempts);
            for (InternalPullRequest pullRequest : pullRequests) {
                DriftCommentUpdateProcessor.this.executorService.submit(new CommentDriftBootstrapper(pullRequest));
            }
        }

        public Void perform() {
            DriftCommentUpdateProcessor.this.transactionTemplate.execute((TransactionCallback)this);
            return null;
        }
    }

    private class CommentDriftOperation
    implements UncheckedOperation<Void> {
        private final InternalPullRequest cachedPullRequest;

        private CommentDriftOperation(InternalPullRequest cachedPullRequest) {
            this.cachedPullRequest = cachedPullRequest;
        }

        public Void perform() {
            List<InternalDriftRequest> drifts = this.getPendingDrifts(this.cachedPullRequest);
            if (drifts.isEmpty()) {
                log.debug("{}:{}@{}: No rescopes are pending drift", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion()});
                return null;
            }
            CommentDriftCalculator calculator = this.calculatorFor(drifts);
            try {
                DriftCommentUpdateProcessor.this.transactionTemplate.execute(status -> {
                    try (Timer ignored = TimerUtils.start((String)("Drift: Calculate for " + String.valueOf(calculator)));){
                        calculator.calculate(drifts);
                        DriftCommentUpdateProcessor.this.driftRequestDao.deleteAll(drifts);
                    }
                    return null;
                });
            }
            catch (RuntimeException e) {
                this.maybeReschedule(drifts, e);
            }
            return null;
        }

        private CommentDriftCalculator calculatorFor(List<InternalDriftRequest> drifts) {
            if (drifts.size() > 1) {
                log.debug("{}:{}@{}: Calculating combined drift for {} rescopes", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), drifts.size()});
            }
            InternalDriftRequest first = drifts.get(0);
            return new CommentDriftCalculator(this.cachedPullRequest, first.getOldFromHash(), first.getOldToHash());
        }

        private List<InternalDriftRequest> getPendingDrifts(InternalPullRequest pullRequest) {
            return (List)DriftCommentUpdateProcessor.this.transactionTemplate.execute(status -> DriftCommentUpdateProcessor.this.driftRequestDao.findByGlobalId(pullRequest.getGlobalId()));
        }

        private boolean isRecoverable(Exception e) {
            return DataAccessException.class.isAssignableFrom(e.getClass()) || TransactionException.class.isAssignableFrom(e.getClass()) || HibernateException.class.isAssignableFrom(e.getClass());
        }

        private void maybeReschedule(List<InternalDriftRequest> drifts, RuntimeException e) {
            InternalDriftRequest newestRequest = drifts.get(drifts.size() - 1);
            int failedAttempts = newestRequest.getAttempts() + 1;
            boolean recoverable = this.isRecoverable(e);
            if (recoverable && failedAttempts <= DriftCommentUpdateProcessor.this.maxAttempts) {
                log.info("{}:{}@{}: Failed to drift comments (Attempt {} of {}). Rescheduling", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), failedAttempts, DriftCommentUpdateProcessor.this.maxAttempts, e});
                try {
                    this.updateAttempts(drifts, failedAttempts);
                    DriftCommentUpdateProcessor.this.executorService.submit(new CommentDriftBootstrapper(this.cachedPullRequest));
                }
                catch (RuntimeException ex) {
                    log.warn("{}:{}@{}: Comment drift could not be rescheduled. No further attempts will be made", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), ex});
                }
            } else {
                log.error("{}:{}@{}: {} calculating comment drift ({} attempts).\n\tFirst: {}\n\tLast: {}", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), recoverable ? "Error" : "Unrecoverable error", failedAttempts, drifts.get(0), newestRequest, e});
                try {
                    this.updateAttempts(drifts, DriftCommentUpdateProcessor.this.maxAttempts + 1);
                }
                catch (RuntimeException ex) {
                    log.warn("{}:{}@{}: Aborted drift requests could not be removed from the database. They may be retried after the next system restart", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), ex});
                }
            }
        }

        private void updateAttempts(final List<InternalDriftRequest> drifts, final int attempts) {
            DriftCommentUpdateProcessor.this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(@Nonnull TransactionStatus status) {
                    DriftCommentUpdateProcessor.this.driftRequestDao.updateAttempts((InternalDriftRequest)drifts.get(0), attempts);
                    if (drifts.size() > 1) {
                        DriftCommentUpdateProcessor.this.driftRequestDao.deleteAll(drifts.subList(1, drifts.size()));
                    }
                }
            });
        }
    }

    private class CommentDriftCalculator {
        private final InternalPullRequest cachedPullRequest;
        private final String previousFromHash;
        private final String previousToHash;
        private final InternalRepository repository;

        private CommentDriftCalculator(InternalPullRequest cachedPullRequest, String previousFromHash, String previousToHash) {
            this.cachedPullRequest = cachedPullRequest;
            this.previousFromHash = previousFromHash;
            this.previousToHash = previousToHash;
            this.repository = cachedPullRequest.getScopeRepository();
        }

        public void calculate(List<InternalDriftRequest> driftRequests) {
            Map<PullRequestEffectiveDiff, List<InternalCommentThread>> previousDiffs;
            PullRequestEffectiveDiff effectiveDiff;
            try (Timer ignored = TimerUtils.start((String)("Drift: Map anchors " + this.cachedPullRequest.getGlobalId()));){
                List threads2 = DriftCommentUpdateProcessor.this.commentService.searchThreads(new CommentSearchRequest.Builder((Commentable)this.cachedPullRequest).diffType(CommentThreadDiffAnchorType.EFFECTIVE).states(EnumSet.allOf(CommentState.class)).build(), false, false);
                if (threads2.isEmpty()) {
                    log.debug("{}:{}@{}: No active diff comments", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion()});
                    return;
                }
                effectiveDiff = (PullRequestEffectiveDiff)DriftCommentUpdateProcessor.this.scmService.getPullRequestCommandFactory((PullRequest)this.cachedPullRequest).effectiveDiff().call();
                previousDiffs = this.mapPreviousDiffs(threads2, effectiveDiff);
            }
            if (previousDiffs.isEmpty()) {
                if (log.isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder().append(this.repository.getId()).append(":").append(this.cachedPullRequest.getId()).append("@").append(this.cachedPullRequest.getVersion()).append(": Comments have already been drifted (").append(effectiveDiff.getSinceId()).append(", ").append(effectiveDiff.getUntilId()).append(") when processing ").append(driftRequests.size()).append(" drift request(s):");
                    for (InternalDriftRequest driftRequest : driftRequests) {
                        builder.append("\n\t").append(driftRequest);
                    }
                    log.debug(builder.toString());
                }
                return;
            }
            if (previousDiffs.size() > 1) {
                log.warn("{}:{}@{}: Non-orphaned comments span {} diffs", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), previousDiffs.size()});
            }
            previousDiffs.forEach((previousDiff, threads) -> {
                DriftContext context = new DriftContext(this.repository, this.cachedPullRequest, this.previousFromHash, this.previousToHash, effectiveDiff, (PullRequestEffectiveDiff)previousDiff, (List<InternalCommentThread>)threads);
                try (Timer ignored = TimerUtils.start((String)("Drift: " + String.valueOf(DriftCommentUpdateProcessor.this.strategyChain) + " " + this.cachedPullRequest.getGlobalId()));){
                    DriftCommentUpdateProcessor.this.strategyChain.applyTo(context);
                }
                List<InternalCommentThread> driftedThreads = context.done();
                try (Timer ignored = TimerUtils.start((String)("Drift: Update threads " + this.cachedPullRequest.getGlobalId()));){
                    DriftCommentUpdateProcessor.this.commentService.updateThreads(driftedThreads.stream());
                }
                log.debug("{}:{}@{}: Successfully drifted {} threads from ({}, {}) to ({}, {})", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), driftedThreads.size(), previousDiff.getSinceId(), previousDiff.getUntilId(), effectiveDiff.getSinceId(), effectiveDiff.getUntilId()});
            });
        }

        private Map<PullRequestEffectiveDiff, List<InternalCommentThread>> mapPreviousDiffs(List<InternalCommentThread> threads, PullRequestEffectiveDiff currentDiff) {
            HashMap<PullRequestEffectiveDiff, List<InternalCommentThread>> previousDiffs = new HashMap<PullRequestEffectiveDiff, List<InternalCommentThread>>();
            threads.forEach(thread -> {
                CommentThreadDiffAnchor anchor = (CommentThreadDiffAnchor)thread.getAnchor().get();
                PullRequestEffectiveDiff diff = new PullRequestEffectiveDiff(anchor.getToHash(), (String)anchor.getFromHash().get());
                if (currentDiff.equals((Object)diff)) {
                    Duration commentAge = Duration.between(thread.getRootComment().getCreatedDate().toInstant(), Instant.now());
                    if (commentAge.compareTo(DURATION_RECENT) < 0) {
                        log.info("{}:{}@{}: Comment {} is already in the current diff ({}, {}) and will not be drifted", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), thread.getRootComment().getId(), currentDiff.getSinceId(), currentDiff.getUntilId()});
                    } else {
                        log.debug("{}:{}@{}: Comment {} is already in the current diff ({}, {}) and will not be drifted", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), thread.getRootComment().getId(), currentDiff.getSinceId(), currentDiff.getUntilId()});
                    }
                } else {
                    previousDiffs.computeIfAbsent(diff, key -> new ArrayList()).add(thread);
                }
            });
            return previousDiffs;
        }
    }
}

