/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.drift.DriftResult;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DriftContext
implements Iterable<InternalCommentThread> {
    private final List<InternalCommentThread> threads;
    private final PullRequestEffectiveDiff currentDiff;
    private final PullRequestEffectiveDiff previousDiff;
    private final String previousFromHash;
    private final String previousToHash;
    private final InternalPullRequest pullRequest;
    private final InternalRepository repository;
    private final List<InternalCommentThread> updated;

    public DriftContext(InternalRepository repository, InternalPullRequest pullRequest, String previousFromHash, String previousToHash, PullRequestEffectiveDiff currentDiff, PullRequestEffectiveDiff previousDiff, List<InternalCommentThread> threads) {
        Preconditions.checkArgument((!Objects.requireNonNull(threads, "threads").isEmpty() ? 1 : 0) != 0, (Object)"At least one thread to process is required");
        this.currentDiff = Objects.requireNonNull(currentDiff, "currentDiff");
        this.previousDiff = Objects.requireNonNull(previousDiff, "previousDiff");
        this.previousFromHash = previousFromHash;
        this.previousToHash = previousToHash;
        this.pullRequest = pullRequest;
        this.repository = Objects.requireNonNull(repository, "repository");
        this.threads = new ArrayList<InternalCommentThread>(threads);
        this.updated = new ArrayList<InternalCommentThread>(threads.size());
    }

    @Nonnull
    public static Set<String> toPaths(Iterable<InternalCommentThread> threads) {
        return MoreStreams.streamIterable(threads).map(thread -> (CommentThreadDiffAnchor)thread.getAnchor().get()).flatMap(anchor -> {
            Stream.Builder<String> builder = Stream.builder();
            builder.add(anchor.getPath());
            anchor.getSrcPath().ifPresent(builder::add);
            return builder.build();
        }).collect(Collectors.toSet());
    }

    @Nonnull
    public List<InternalCommentThread> done() {
        if (this.threads.isEmpty()) {
            return Collections.unmodifiableList(this.updated);
        }
        throw new IllegalStateException(this.threads.size() + " comments were not processed");
    }

    public void drift(@Nonnull InternalCommentThread thread, int srcDrift, int dstDrift) {
        InternalCommentThreadDiffAnchor internalAnchor = InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)((CommentThreadDiffAnchor)thread.getAnchor().get()));
        InternalCommentThreadDiffAnchor.Builder modifiedAnchorBuilder = new InternalCommentThreadDiffAnchor.Builder(internalAnchor).fromHash(this.currentDiff.getSinceId()).toHash(this.currentDiff.getUntilId());
        int lineDrift = DriftResult.DriftHelper.driftLineBySegmentType(internalAnchor, srcDrift, dstDrift);
        modifiedAnchorBuilder.line(internalAnchor.getLine() + lineDrift, (DiffSegmentType)internalAnchor.getLineType().get(), (DiffFileType)internalAnchor.getFileType().get());
        if (internalAnchor.isMultilineAnchor()) {
            internalAnchor.getSrcSpanStart().ifPresent(srcSpanStart -> modifiedAnchorBuilder.srcSpan(srcSpanStart + srcDrift, (Integer)internalAnchor.getSrcSpanEnd().get() + srcDrift));
            internalAnchor.getDstSpanStart().ifPresent(dstSpanStart -> modifiedAnchorBuilder.dstSpan(dstSpanStart + dstDrift, (Integer)internalAnchor.getDstSpanEnd().get() + dstDrift));
            int newStartLineDrift = DriftResult.DriftHelper.driftStartLineBySegmentType(internalAnchor, srcDrift, dstDrift);
            int newStartLine = (Integer)internalAnchor.getMultilineStartLine().get() + newStartLineDrift;
            modifiedAnchorBuilder.multiline(newStartLine, (DiffSegmentType)internalAnchor.getMultilineStartLineType().get());
        }
        this.updated.add(new InternalCommentThread.Builder(thread).anchor(modifiedAnchorBuilder.build()).build());
    }

    @Nonnull
    public PullRequestEffectiveDiff getCurrentDiff() {
        return this.currentDiff;
    }

    @Nonnull
    public Set<String> getRemainingPaths() {
        return DriftContext.toPaths(this.threads);
    }

    @Nonnull
    public PullRequestEffectiveDiff getPreviousDiff() {
        return this.previousDiff;
    }

    @Nonnull
    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return this.previousToHash;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    public boolean isEmpty() {
        return this.threads.isEmpty();
    }

    @Override
    @Nonnull
    public Iterator<InternalCommentThread> iterator() {
        return this.threads.iterator();
    }

    public void orphan(@Nonnull InternalCommentThread thread) {
        this.updated.add(new InternalCommentThread.Builder(thread).anchor(new InternalCommentThreadDiffAnchor.Builder(InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)((CommentThreadDiffAnchor)thread.getAnchor().get()))).orphaned(true).build()).build());
    }

    public void retain(@Nonnull InternalCommentThread thread) {
        this.updated.add(new InternalCommentThread.Builder(thread).anchor(new InternalCommentThreadDiffAnchor.Builder(InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)((CommentThreadDiffAnchor)thread.getAnchor().get()))).fromHash(this.currentDiff.getSinceId()).toHash(this.currentDiff.getUntilId()).build()).build());
    }

    @Nonnull
    public Stream<InternalCommentThread> stream() {
        return this.threads.stream();
    }
}

