/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.SpanType;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DriftResult {
    private final Map<Long, ProcessedThread> processedThreads;

    public DriftResult() {
        this.processedThreads = new HashMap<Long, ProcessedThread>();
    }

    private DriftResult(Map<Long, ProcessedThread> processedThreads) {
        this.processedThreads = processedThreads;
    }

    public static DriftResult forRetained(@Nonnull Iterable<InternalCommentThread> retainedThreads) {
        return new DriftResult().retain(retainedThreads);
    }

    public void applyTo(@Nonnull DriftContext driftContext) {
        Iterator<InternalCommentThread> threadIterator = driftContext.iterator();
        while (threadIterator.hasNext()) {
            InternalCommentThread thread = threadIterator.next();
            ProcessedThread processed = this.processedThreads.get(thread.getId());
            if (processed == null) continue;
            processed.applyTo(driftContext);
            threadIterator.remove();
        }
    }

    @Nonnull
    public DriftResult drift(int drift, @Nonnull InternalCommentThread thread, SpanType diffType) {
        int srcDrift = diffType == SpanType.SOURCE ? drift : 0;
        int dstDrift = diffType == SpanType.DESTINATION ? drift : 0;
        return this.record(thread, new DriftedThread(thread, srcDrift, dstDrift));
    }

    @Nonnull
    public List<ProcessedThread> getReachableThreads() {
        return (List)this.processedThreads.values().stream().filter(ProcessedThread::isReachable).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public List<ProcessedThread> getUnreachableThreads() {
        return (List)this.processedThreads.values().stream().filter(thread -> !thread.isReachable()).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public DriftResult merge(@Nonnull DriftResult other) {
        Objects.requireNonNull(other, "other");
        HashMap<Long, ProcessedThread> merged = new HashMap<Long, ProcessedThread>(this.processedThreads);
        for (Map.Entry<Long, ProcessedThread> otherThread : other.processedThreads.entrySet()) {
            ProcessedThread commonDriftedThread;
            ProcessedThread processedThread = commonDriftedThread = this.processedThreads.containsKey(otherThread.getKey()) ? this.processedThreads.get(otherThread.getKey()) : null;
            if (commonDriftedThread == null) {
                merged.put(otherThread.getKey(), otherThread.getValue());
                continue;
            }
            if (!commonDriftedThread.anchor.isMultilineAnchor()) {
                throw new IllegalStateException(String.format("Thread [%d] has been mapped to two different processing outcomes: %s and %s", otherThread.getKey(), otherThread.getValue(), commonDriftedThread));
            }
            ProcessedThread mergedThread = commonDriftedThread.merge(otherThread.getValue());
            merged.put(otherThread.getKey(), mergedThread);
        }
        return new DriftResult(merged);
    }

    @Nonnull
    public DriftResult orphan(@Nonnull Iterable<InternalCommentThread> threads) {
        threads.forEach(thread -> this.record((InternalCommentThread)thread, new OrphanedThread((InternalCommentThread)thread)));
        return this;
    }

    @Nonnull
    public DriftResult orphan(@Nonnull InternalCommentThread thread) {
        return this.record(thread, new OrphanedThread(thread));
    }

    @Nonnull
    public DriftResult retain(@Nonnull Iterable<InternalCommentThread> threads) {
        threads.forEach(thread -> this.record((InternalCommentThread)thread, new RetainedThread((InternalCommentThread)thread)));
        return this;
    }

    @Nonnull
    public DriftResult retain(@Nonnull InternalCommentThread thread) {
        return this.record(thread, new RetainedThread(thread));
    }

    @Nonnull
    public DriftResult record(@Nonnull InternalCommentThread thread, @Nonnull ProcessedThread processedThread) {
        Objects.requireNonNull(thread, "thread");
        Objects.requireNonNull(processedThread, "processedThread");
        Preconditions.checkArgument((thread.getId() == processedThread.getThread().getId() ? 1 : 0) != 0, (Object)("Cannot map processed thread to a thread with a different ID (was: thread.id=" + thread.getId() + ", processedThread.id=" + processedThread.getThread().getId()));
        this.processedThreads.put(thread.getId(), processedThread);
        return this;
    }

    public static abstract class ProcessedThread {
        protected final InternalCommentThreadDiffAnchor anchor;
        protected final InternalCommentThread thread;
        protected LineNumberRange destinationSpan;
        protected LineNumberRange sourceSpan;

        protected ProcessedThread(@Nonnull InternalCommentThread thread) {
            this.thread = Objects.requireNonNull(thread, "thread");
            this.anchor = InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)((CommentThreadDiffAnchor)thread.getAnchor().get()));
            this.sourceSpan = this.anchor.getSrcSpanStart().map(start -> new LineNumberRange(start.intValue(), ((Integer)this.anchor.getSrcSpanEnd().get()).intValue())).orElse(null);
            this.destinationSpan = this.anchor.getDstSpanStart().map(start -> new LineNumberRange(start.intValue(), ((Integer)this.anchor.getDstSpanEnd().get()).intValue())).orElse(null);
        }

        @Nonnull
        public Optional<LineNumberRange> getDestinationSpan() {
            return Optional.ofNullable(this.destinationSpan);
        }

        public int getLine() {
            return this.anchor.getLine();
        }

        @Nonnull
        public Optional<Integer> getStartLine() {
            return this.anchor.getMultilineStartLine();
        }

        @Nonnull
        public Optional<DiffSegmentType> getLineType() {
            return this.anchor.getLineType();
        }

        @Nonnull
        public String getPath() {
            return this.anchor.getPath();
        }

        @Nonnull
        public Optional<LineNumberRange> getSourceSpan() {
            return Optional.ofNullable(this.sourceSpan);
        }

        @Nonnull
        public Optional<DiffSegmentType> getStartLineType() {
            return this.anchor.getMultilineStartLineType();
        }

        @Nonnull
        public InternalCommentThread getThread() {
            return this.thread;
        }

        public boolean isMultiline() {
            return this.anchor.isMultilineAnchor();
        }

        @Nonnull
        ProcessedThread merge(@Nonnull ProcessedThread other) {
            if (!this.anchor.equals(other.anchor)) {
                throw new IllegalArgumentException("Cannot merge different threads");
            }
            return this;
        }

        abstract void applyTo(@Nonnull DriftContext var1);

        boolean isReachable() {
            return true;
        }
    }

    private static class DriftedThread
    extends ProcessedThread {
        private final int srcDrift;
        private final int dstDrift;

        private DriftedThread(@Nonnull InternalCommentThread thread, int srcDrift, int dstDrift) {
            super(thread);
            this.srcDrift = srcDrift;
            this.dstDrift = dstDrift;
            this.sourceSpan = this.sourceSpan == null ? null : new LineNumberRange(this.sourceSpan.minimum() + srcDrift, this.sourceSpan.maximum() + srcDrift);
            this.destinationSpan = this.destinationSpan == null ? null : new LineNumberRange(this.destinationSpan.minimum() + dstDrift, this.destinationSpan.maximum() + dstDrift);
        }

        @Override
        public int getLine() {
            return super.getLine() + DriftHelper.driftLineBySegmentType(this.anchor, this.srcDrift, this.dstDrift);
        }

        @Override
        @Nonnull
        public Optional<Integer> getStartLine() {
            return super.getStartLine().map(line -> line + DriftHelper.driftStartLineBySegmentType(this.anchor, this.srcDrift, this.dstDrift));
        }

        @Override
        @Nonnull
        public ProcessedThread merge(@Nonnull ProcessedThread threadToMerge) {
            Objects.requireNonNull(threadToMerge, "threadToMerge");
            super.merge(threadToMerge);
            if (threadToMerge instanceof RetainedThread) {
                return this;
            }
            if (threadToMerge instanceof OrphanedThread) {
                return threadToMerge;
            }
            if (threadToMerge instanceof DriftedThread) {
                DriftedThread otherDriftedThread = (DriftedThread)threadToMerge;
                if (!this.anchor.isMultilineAnchor() || !threadToMerge.anchor.isMultilineAnchor()) {
                    throw new IllegalArgumentException("Trying to merge a single line comment from more than one drift results");
                }
                return new DriftedThread(this.thread, this.srcDrift + otherDriftedThread.srcDrift, this.dstDrift + otherDriftedThread.dstDrift);
            }
            throw new IllegalArgumentException("Unknown processed thread type");
        }

        @Override
        void applyTo(@Nonnull DriftContext context) {
            context.drift(this.thread, this.srcDrift, this.dstDrift);
        }
    }

    private static class OrphanedThread
    extends ProcessedThread {
        private OrphanedThread(@Nonnull InternalCommentThread thread) {
            super(thread);
        }

        @Override
        @Nonnull
        ProcessedThread merge(@Nonnull ProcessedThread threadToMerge) {
            Objects.requireNonNull(threadToMerge, "threadToMerge");
            super.merge(threadToMerge);
            return this;
        }

        @Override
        void applyTo(@Nonnull DriftContext context) {
            context.orphan(this.thread);
        }

        @Override
        boolean isReachable() {
            return false;
        }
    }

    private static class RetainedThread
    extends ProcessedThread {
        private RetainedThread(@Nonnull InternalCommentThread thread) {
            super(thread);
        }

        @Override
        @Nonnull
        ProcessedThread merge(@Nonnull ProcessedThread threadToMerge) {
            Objects.requireNonNull(threadToMerge, "threadToMerge");
            super.merge(threadToMerge);
            return threadToMerge;
        }

        @Override
        void applyTo(@Nonnull DriftContext context) {
            context.retain(this.thread);
        }
    }

    static class DriftHelper {
        DriftHelper() {
        }

        public static int driftLineBySegmentType(InternalCommentThreadDiffAnchor anchor, int srcDrift, int dstDrift) {
            return SpanType.fromSegmentType((DiffSegmentType)anchor.getLineType().get()) == SpanType.SOURCE ? srcDrift : dstDrift;
        }

        public static int driftStartLineBySegmentType(InternalCommentThreadDiffAnchor anchor, int srcDrift, int dstDrift) {
            return SpanType.fromSegmentType((DiffSegmentType)anchor.getMultilineStartLineType().get()) == SpanType.SOURCE ? srcDrift : dstDrift;
        }
    }
}

