/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.DriftScmHelper;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-10)
public class FastForwardCommentDriftStrategy
implements CommentDriftStrategy {
    private static final Logger log = LoggerFactory.getLogger(FastForwardCommentDriftStrategy.class);
    private final DriftScmHelper scmHelper;

    @Autowired
    public FastForwardCommentDriftStrategy(DriftScmHelper scmHelper) {
        this.scmHelper = scmHelper;
    }

    @Override
    public void apply(@Nonnull DriftContext context) {
        Set<String> retainedPaths = this.calculateRetainedPaths(context);
        if (retainedPaths.isEmpty()) {
            log.debug("{}: No threads could be fast-forwarded", (Object)context.getPullRequest().getGlobalId());
            return;
        }
        Iterator<InternalCommentThread> iterator = context.iterator();
        while (iterator.hasNext()) {
            InternalCommentThread thread = iterator.next();
            if (!this.isRetained(retainedPaths, thread)) continue;
            context.retain(thread);
            iterator.remove();
        }
    }

    @Override
    public String getName() {
        return "FastForward";
    }

    @Nonnull
    private Set<String> calculateRetainedPaths(DriftContext context) {
        Timer ignored;
        String timerName;
        String fromHash;
        InternalPullRequest pullRequest = context.getPullRequest();
        Set<String> retainedPaths = context.getRemainingPaths();
        String previousFromHash = context.getPreviousFromHash();
        if (previousFromHash.equals(fromHash = pullRequest.getFromRef().getLatestCommit())) {
            log.debug("{}: The source branch has not been updated and will not be checked for changes", (Object)pullRequest.getGlobalId());
        } else {
            PullRequestEffectiveDiff previousDiff = context.getPreviousDiff();
            PullRequestEffectiveDiff currentDiff = context.getCurrentDiff();
            timerName = "Drift: " + this.getName() + " - Merge changes [" + previousDiff.getUntilId() + "]->[" + currentDiff.getUntilId() + "] " + pullRequest.getGlobalId();
            ignored = TimerUtils.start((String)timerName);
            try {
                this.excludeUpdatedPaths((Repository)context.getRepository(), retainedPaths, currentDiff.getUntilId(), previousDiff.getUntilId());
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            if (retainedPaths.isEmpty()) {
                return Collections.emptySet();
            }
        }
        String previousToHash = context.getPreviousToHash();
        String toHash = pullRequest.getToRef().getLatestCommit();
        if (previousToHash.equals(toHash)) {
            log.debug("{}: The target branch has not been updated and will not be checked for changes", (Object)pullRequest.getGlobalId());
        } else {
            timerName = "Drift: " + this.getName() + " - Target changes [" + previousToHash + "]->[" + toHash + "] " + pullRequest.getGlobalId();
            ignored = TimerUtils.start((String)timerName);
            try {
                this.excludeUpdatedPaths((Repository)context.getRepository(), retainedPaths, toHash, previousToHash);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        return retainedPaths;
    }

    private void excludeUpdatedPaths(Repository repository, Set<String> retainedPaths, String untilId, String sinceId) {
        this.scmHelper.streamChanges(repository, sinceId, untilId, retainedPaths, change -> {
            retainedPaths.remove(change.getPath().toString());
            Path srcPath = change.getSrcPath();
            if (srcPath != null) {
                retainedPaths.remove(srcPath.toString());
            }
            return !retainedPaths.isEmpty();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRetained(Set<String> retainedPaths, InternalCommentThread thread) {
        CommentThreadDiffAnchor anchor = (CommentThreadDiffAnchor)thread.getAnchor().get();
        if (!retainedPaths.contains(anchor.getPath())) return false;
        if (anchor.getSrcPath().map(retainedPaths::contains).orElse(true) == false) return false;
        return true;
    }
}

