/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeSummary;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.DriftResult;
import com.atlassian.stash.internal.pull.comment.drift.DriftScmHelper;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class FileCommentDriftStrategy
implements CommentDriftStrategy {
    private static final Logger log = LoggerFactory.getLogger(FileCommentDriftStrategy.class);
    private final DriftScmHelper scmHelper;

    @Autowired
    public FileCommentDriftStrategy(DriftScmHelper scmHelper) {
        this.scmHelper = scmHelper;
    }

    @Override
    public void apply(@Nonnull DriftContext driftContext) {
        DriftResult driftResult = this.processPullRequestDiff(driftContext);
        driftResult.applyTo(driftContext);
    }

    @Override
    public String getName() {
        return "FileComment";
    }

    private DriftResult processPullRequestDiff(DriftContext context) {
        FileCommentDriftCallback callback = new FileCommentDriftCallback(context);
        if (callback.isEmpty()) {
            log.debug("{}: No file comment threads to process", (Object)context.getPullRequest().getGlobalId());
            return callback.done();
        }
        PullRequestEffectiveDiff currentDiff = context.getCurrentDiff();
        InternalPullRequest pullRequest = context.getPullRequest();
        String timerName = "Drift: " + this.getName() + " - Diff-tree [" + currentDiff.getSinceId() + "]->[" + currentDiff.getUntilId() + "] " + pullRequest.getGlobalId();
        try (Timer ignored = TimerUtils.start((String)timerName);){
            this.scmHelper.streamChanges((Repository)context.getRepository(), currentDiff.getSinceId(), currentDiff.getUntilId(), callback.getPaths(), callback);
        }
        return callback.done();
    }

    private static class FileCommentDriftCallback
    implements ChangeCallback {
        private final DriftResult driftResult = new DriftResult();
        private final Map<String, List<InternalCommentThread>> fileThreadsByPath;

        FileCommentDriftCallback(DriftContext context) {
            this.fileThreadsByPath = context.stream().filter(thread -> thread.getAnchor().map(CommentThreadDiffAnchor::isFileAnchor).orElse(false)).collect(Collectors.groupingBy(thread -> ((CommentThreadDiffAnchor)thread.getAnchor().get()).getPath()));
        }

        public boolean onChange(@Nonnull Change change) {
            List<InternalCommentThread> threads = this.fileThreadsByPath.remove(change.getPath().toString());
            if (threads != null) {
                this.driftResult.retain(threads);
            }
            return true;
        }

        public void onEnd(@Nonnull ChangeSummary summary) {
            this.fileThreadsByPath.values().forEach(this.driftResult::orphan);
            this.fileThreadsByPath.clear();
        }

        DriftResult done() {
            if (this.isEmpty()) {
                return this.driftResult;
            }
            throw new IllegalStateException("This context should be empty after processing all changes");
        }

        Set<String> getPaths() {
            return this.fileThreadsByPath.keySet();
        }

        boolean isEmpty() {
            return this.fileThreadsByPath.isEmpty();
        }
    }
}

