/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.stash.internal.pull.comment.drift.DriftResult;
import com.google.common.base.Preconditions;

public class ProcessedThreadSpanBuilder {
    private final DriftResult.ProcessedThread thread;
    private int destinationSpanEnd = 0;
    private int destinationSpanStart = 0;
    private int sourceSpanEnd = 0;
    private int sourceSpanStart = 0;

    public ProcessedThreadSpanBuilder(DriftResult.ProcessedThread thread, int sourceLine, int destinationLine, DiffSegmentType lineType) {
        Preconditions.checkArgument((sourceLine >= 0 ? 1 : 0) != 0, (Object)"Source line must be a non-negative integer");
        Preconditions.checkArgument((destinationLine >= 0 ? 1 : 0) != 0, (Object)"Destination line must be a non-negative integer");
        Preconditions.checkArgument((boolean)thread.isMultiline(), (Object)"Processed thread must be a multiline thread");
        this.thread = thread;
        this.addToSpansAndCheckIfEnd(sourceLine, destinationLine, lineType);
    }

    public boolean addToSpansAndCheckIfEnd(int sourceLine, int destinationLine, DiffSegmentType lineType) {
        boolean bl;
        Preconditions.checkArgument((sourceLine >= this.sourceSpanEnd ? 1 : 0) != 0, (Object)"Source line must not be smaller than previous source span maximum");
        Preconditions.checkArgument((destinationLine >= this.destinationSpanEnd ? 1 : 0) != 0, (Object)"Destination line must not be smaller than previous destination span maximum");
        switch (lineType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDED: {
                if (this.destinationSpanStart == 0) {
                    this.destinationSpanStart = destinationLine;
                }
                this.destinationSpanEnd = destinationLine;
                if (this.thread.getLineType().get() == lineType && this.destinationSpanEnd >= this.thread.getLine()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case CONTEXT: {
                if (this.destinationSpanStart == 0) {
                    this.destinationSpanStart = destinationLine;
                }
                this.destinationSpanEnd = destinationLine;
            }
            case REMOVED: {
                if (this.sourceSpanStart == 0) {
                    this.sourceSpanStart = sourceLine;
                }
                this.sourceSpanEnd = sourceLine;
                bl = DiffFileType.forSegmentType((DiffSegmentType)this.thread.getLineType().get()) == DiffFileType.forSegmentType((DiffSegmentType)lineType) && this.sourceSpanEnd >= this.thread.getLine();
            }
        }
        return bl;
    }

    public DriftResult.ProcessedThread getThread() {
        return this.thread;
    }

    public boolean spansMatchThread() {
        boolean sourceSpanMatchesThread = this.thread.getSourceSpan().map(range -> range.minimum() == this.sourceSpanStart && range.maximum() == this.sourceSpanEnd).orElse(this.sourceSpanStart == 0 && this.sourceSpanEnd == 0);
        if (sourceSpanMatchesThread) {
            return this.thread.getDestinationSpan().map(range -> range.minimum() == this.destinationSpanStart && range.maximum() == this.destinationSpanEnd).orElse(this.destinationSpanStart == 0 && this.destinationSpanEnd == 0);
        }
        return false;
    }
}

