/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ResolveRefsCommandParameters;
import com.atlassian.bitbucket.scm.pull.BulkRescopeCommandParameters;
import com.atlassian.bitbucket.scm.pull.BulkRescopeContext;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.atlassian.bitbucket.scm.pull.UpdatePullRequestRefsCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.pull.rescope.DeclineOutcome;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.MergeOutcome;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeChain;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcome;
import com.atlassian.stash.internal.pull.rescope.SimpleMinimalPullRequest;
import com.atlassian.stash.internal.pull.rescope.SimplePullRequestRescope;
import com.atlassian.stash.internal.pull.rescope.UpdateOutcome;
import com.atlassian.stash.internal.repository.InternalRefChange;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultPullRequestRescopeService
implements InternalPullRequestRescopeService {
    private static final int MAX_RESCOPE_ATTEMPTS = 3;
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestRescopeService.class);
    private final AuthenticationContext authenticationContext;
    private final RescopeRequestDao dao;
    private final ExecutorService refResolveExecutorService;
    private final InternalPullRequestService pullRequestService;
    private final InternalScmService scmService;
    private final SecurityService securityService;
    @Value(value="${pullrequest.rescope.commits.display}")
    private int maxCommitIds;
    @Value(value="${pullrequest.rescope.chain.resolve.tail.gap}")
    private boolean rescopeChainResolveTailGap;
    @Value(value="${pullrequest.rescope.request.delete.delay}")
    private int rescopeRequestDeleteDelaySeconds;
    @Value(value="${pullrequest.rescope.ref-resolve.max.threads}")
    private int maxRefResolveThreads;

    public DefaultPullRequestRescopeService(AuthenticationContext authenticationContext, RescopeRequestDao dao, InternalPullRequestService pullRequestService, ExecutorService refResolveExecutorService, InternalScmService scmService, SecurityService securityService) {
        this.authenticationContext = authenticationContext;
        this.dao = dao;
        this.refResolveExecutorService = refResolveExecutorService;
        this.pullRequestService = pullRequestService;
        this.scmService = scmService;
        this.securityService = securityService;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean createRequest(@Nonnull InternalRepository repository, @Nonnull InternalApplicationUser user, @Nonnull Collection<? extends RefChange> changes) {
        InternalRescopeRequest request = new InternalRescopeRequest.Builder(repository, user).refChanges(changes).build();
        if (request.getRefChanges().isEmpty() == changes.isEmpty()) {
            log.debug("Creating request for ref changes: {}", InternalRefChange.formatRefChanges((Iterable)request.getRefChanges()));
            this.dao.create((Object)request);
            return true;
        }
        return false;
    }

    @Nonnull
    @Unsecured(value="Permission checks, when necessary, are done prior to calling this method")
    @Transactional
    public RepositoryRescopeResult rescope(@Nonnull Repository repository) {
        try (Timer ignored = TimerUtils.start((String)(String.valueOf(repository) + ": bulk rescoping pull requests "));){
            RepositoryRescopeResult repositoryRescopeResult = (RepositoryRescopeResult)this.securityService.withPermission(Permission.REPO_READ, "Rescoping pull requests").call(() -> this.rescopeInternal(repository));
            return repositoryRescopeResult;
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional
    public RepositoryRescopeResult rescope(@Nonnull Repository repository, @Nonnull List<String> branchIds) {
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
        this.dao.create((Object)new InternalRescopeRequest.Builder(InternalConverter.convertToInternalRepository((Repository)repository), user).branchIds(branchIds).build());
        return this.rescope(repository);
    }

    private RepositoryRescopeResult applyRescopes(RescopeContext rescopeContext, List<PullRequestRescopeChain> chains) {
        int errorCount = 0;
        int skippedCount = 0;
        HashMap<Long, PullRequest> fromRefChangedPullRequests = new HashMap<Long, PullRequest>();
        block5: for (PullRequestRescopeChain chain : chains) {
            List<SimplePullRequestRescope> rescopes = chain.getRescopes();
            if (rescopes.isEmpty()) {
                log.warn("{}: Rescope chain is empty", (Object)chain.getPullRequest());
                continue;
            }
            log.trace("{}: Applying rescopes: {}", (Object)chain.getPullRequest(), rescopes);
            SimpleMinimalPullRequest pullRequest = chain.getPullRequest();
            for (int attempt = 1; attempt <= 3; ++attempt) {
                try {
                    long globalId = pullRequest.getGlobalId();
                    String fromRefLatestCommit = pullRequest.getFromRef().getLatestCommit();
                    PullRequest updated = this.pullRequestService.rescope(globalId, pullRequest.getVersion(), rescopes);
                    if (Objects.equals(updated.getFromRef().getLatestCommit(), fromRefLatestCommit)) continue block5;
                    fromRefChangedPullRequests.put(globalId, updated);
                    continue block5;
                }
                catch (IllegalPullRequestStateException e) {
                    log.info("{} is locked for merging; it will be rechecked after the lock is released", (Object)pullRequest);
                    rescopeContext.markIncomplete(pullRequest);
                    ++skippedCount;
                    continue block5;
                }
                catch (NoSuchPullRequestException e) {
                    log.info("{} has been deleted and no longer requires rescoping", (Object)pullRequest);
                    continue block5;
                }
                catch (PullRequestOutOfDateException e) {
                    PullRequest current = e.getPullRequest();
                    if (current == null) {
                        log.info("{}@{} has been modified since rescoping started; the new scope will be recalculated", (Object)pullRequest, (Object)pullRequest.getVersion());
                    } else {
                        if (current.isClosed()) {
                            log.info("{} is closed and no longer requires rescoping (State: {})", (Object)pullRequest, (Object)current.getState());
                            continue block5;
                        }
                        SimplePullRequestRescope targetScope = (SimplePullRequestRescope)Iterables.getLast(rescopes);
                        log.warn("{}@{} has been modified since rescoping started; the new scope will be recalculated\n\tCurrent scope: From: {} To: {} (Version: {}, State: {})\n\tRescope: From: {} -> {}, To: {} -> {}", new Object[]{pullRequest, pullRequest.getVersion(), current.getFromRef().getLatestCommit(), current.getToRef().getLatestCommit(), current.getVersion(), current.getState(), pullRequest.getFromRef().getLatestCommit(), targetScope.getNewFromHash(), pullRequest.getToRef().getLatestCommit(), targetScope.getNewToHash()});
                    }
                    rescopeContext.markIncomplete(pullRequest);
                    ++skippedCount;
                    continue block5;
                }
                catch (RuntimeException e) {
                    if (attempt < 3) {
                        log.debug("Problem rescoping {} ({}/{})", new Object[]{pullRequest, attempt, 3, e});
                        continue;
                    }
                    log.warn("{} could not be rescoped", (Object)pullRequest, (Object)e);
                    rescopeContext.markIncomplete(pullRequest);
                    ++errorCount;
                    continue;
                }
            }
        }
        this.updatePullRequestRefsInScm(fromRefChangedPullRequests.values());
        return new RepositoryRescopeResult(rescopeContext.getSkippedCount() + skippedCount, rescopeContext.getErrorCount() + errorCount);
    }

    private void deleteHandledRescopeRequests(RescopeContext context, Collection<InternalRescopeRequest> requests) {
        Instant expiry = ZonedDateTime.now().minusDays(1L).toInstant();
        log.trace("Deleting handled rescope requests. Expiry: {}, Incomplete refs: {}", (Object)expiry, context.incompleteDateByRepoRef);
        for (InternalRescopeRequest request : requests) {
            log.trace("Checking rescope request: {}, Request date: {}", InternalRefChange.formatRefChanges((Iterable)request.getRefChanges()), (Object)request.getCreatedDate());
            if (!context.isSafeToDelete(request) && !request.getCreatedDate().toInstant().isBefore(expiry)) continue;
            log.trace("Deleting ref changes: {}", InternalRefChange.formatRefChanges((Iterable)request.getRefChanges()));
            this.dao.delete((Object)request);
        }
    }

    private void determineRescopes(Repository repository, List<PullRequestRescopeChain> chains) {
        this.scmService.bulkRescope(new BulkRescopeCommandParameters.Builder().repository(repository).rescopeContext((BulkRescopeContext)new SimpleBulkRescopeContext(chains, this.maxCommitIds)).build());
    }

    private Set<String> extractChangedRefs(Collection<InternalRescopeRequest> requests) {
        HashSet<String> refs = new HashSet<String>();
        for (InternalRescopeRequest request : requests) {
            if (request.getRefChanges().isEmpty()) {
                return Collections.emptySet();
            }
            request.getRefChanges().stream().map(change -> change.getRef().getId()).forEach(refs::add);
        }
        return refs;
    }

    private Iterable<PullRequest> findAffectedPullRequests(Repository repository, Set<String> branchIds) {
        if (branchIds.contains(null) || branchIds.isEmpty()) {
            return this.getOpenPullRequests(repository, Collections.emptyList());
        }
        Iterable<Object> result = Collections.emptyList();
        for (List partition : Iterables.partition(branchIds, (int)100)) {
            Iterable<PullRequest> pullRequests = this.getOpenPullRequests(repository, partition);
            result = Iterables.concat(result, pullRequests);
        }
        return result;
    }

    private Iterable<PullRequest> getOpenPullRequests(Repository repository, List<String> refIds) {
        return Iterables.concat((Iterable)new PagedIterable(pageRequest -> {
            PullRequestSearchRequest searchRequest = new PullRequestSearchRequest.Builder().toRepositoryId(Integer.valueOf(repository.getId())).toRefIds((Iterable)refIds).state(PullRequestState.OPEN).withProperties(false).build();
            return this.pullRequestService.search(searchRequest, pageRequest);
        }, 100), (Iterable)new PagedIterable(pageRequest -> {
            PullRequestSearchRequest searchRequest = new PullRequestSearchRequest.Builder().fromRepositoryId(Integer.valueOf(repository.getId())).fromRefIds((Iterable)refIds).state(PullRequestState.OPEN).withProperties(false).build();
            return this.pullRequestService.search(searchRequest, pageRequest);
        }, 100));
    }

    private RepositoryRescopeResult rescopeInternal(Repository repository) {
        try (Timer timer = TimerUtils.start((String)"load rescope requests");){
            List<PullRequestRescopeChain.Builder> chainBuilders;
            ArrayList<InternalRescopeRequest> rescopeRequests = new ArrayList<InternalRescopeRequest>(this.dao.findByRepositories(Collections.singletonList(repository.getId())));
            if (rescopeRequests.isEmpty()) {
                RepositoryRescopeResult repositoryRescopeResult = new RepositoryRescopeResult(0, 0);
                return repositoryRescopeResult;
            }
            if (log.isTraceEnabled()) {
                log.trace("Loaded ref changes: {}", InternalRefChange.formatRefChanges((Iterable)rescopeRequests.stream().flatMap(r -> r.getRefChanges().stream()).collect(Collectors.toList())));
            }
            timer.mark("create rescope chain builders");
            RescopeContext rescopeContext = new RescopeContext(repository, this.rescopeRequestDeleteDelaySeconds, this.rescopeChainResolveTailGap);
            Iterable<PullRequest> affectedPullRequests = this.findAffectedPullRequests(repository, this.extractChangedRefs(rescopeRequests));
            if (log.isTraceEnabled()) {
                log.trace("Loaded affected pull requests: {}", MoreStreams.streamIterable(affectedPullRequests).map(pr -> String.valueOf(InternalConverter.convertToInternalPullRequest((PullRequest)pr).getScopeRepository()) + "#" + pr.getId()).collect(Collectors.toList()));
            }
            if ((chainBuilders = rescopeContext.createChainBuilders(affectedPullRequests)).isEmpty()) {
                log.debug("{}: No chain builders available for processing", (Object)repository);
                timer.mark("delete handled rescope requests");
                this.deleteHandledRescopeRequests(rescopeContext, rescopeRequests);
                RepositoryRescopeResult repositoryRescopeResult = new RepositoryRescopeResult(rescopeContext.getSkippedCount(), rescopeContext.getErrorCount());
                return repositoryRescopeResult;
            }
            timer.mark("determine rescope targets");
            this.setTargetStateOnRescopeChains(rescopeContext, chainBuilders);
            timer.mark("load rescope requests again");
            Set relatedRepositoryIds = rescopeContext.getAlternates().stream().map(Repository::getId).filter(id -> repository.getId() != id.intValue()).collect(Collectors.toSet());
            relatedRepositoryIds.remove(repository.getId());
            rescopeRequests.addAll(this.dao.findByRepositories(relatedRepositoryIds));
            Collections.sort(rescopeRequests);
            timer.mark("build rescope chains");
            for (InternalRescopeRequest rescopeRequest : rescopeRequests) {
                for (PullRequestRescopeChain.Builder chainBuilder : chainBuilders) {
                    chainBuilder.request(rescopeRequest);
                }
            }
            List<PullRequestRescopeChain> chains = chainBuilders.stream().map(PullRequestRescopeChain.Builder::build).filter(chain -> {
                if (chain.getRescopes().isEmpty()) {
                    log.debug("{}: Skipping empty rescope chain", (Object)chain.getPullRequest());
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            chainBuilders = null;
            timer.mark("determine rescopes");
            this.determineRescopes(repository, chains);
            timer.mark("apply rescopes");
            RepositoryRescopeResult result = this.applyRescopes(rescopeContext, chains);
            timer.mark("delete handled rescope requests");
            this.deleteHandledRescopeRequests(rescopeContext, rescopeRequests);
            RepositoryRescopeResult repositoryRescopeResult = result;
            return repositoryRescopeResult;
        }
    }

    private void resolveRefs(RescopeContext context) {
        if (this.maxRefResolveThreads <= 1 || context.getAlternates().isEmpty()) {
            this.resolveRefsSimple(context);
        } else {
            this.resolveRefsMultithreaded(context);
        }
    }

    private void resolveRefs(Repository repository, RescopeContext context) {
        Map<String, String> repoRefs = context.getResolvedRefs(repository);
        ResolveRefsCommandParameters.Builder builder = new ResolveRefsCommandParameters.Builder();
        repoRefs.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).forEach(refId -> {
            if (refId.startsWith("refs/tags/")) {
                builder.tagId(refId);
            } else {
                builder.branchId(refId);
            }
        });
        ResolveRefsCommandParameters parameters = builder.build();
        if (parameters.getBranchIds().isEmpty() && parameters.getTagIds().isEmpty()) {
            return;
        }
        ((Map)this.scmService.getCommandFactory(repository).resolveRefs(parameters).call()).forEach((refId, ref) -> repoRefs.put((String)refId, ref.getLatestCommit()));
    }

    private void resolveRefsMultithreaded(RescopeContext context) {
        try (Timer timer = TimerUtils.start((String)"resolve refs multi-threaded");){
            ExecutorCompletionService completionService = new ExecutorCompletionService(this.refResolveExecutorService);
            HashSet<Future<Object>> futures = new HashSet<Future<Object>>(1 + context.getAlternates().size());
            try {
                Future completed;
                for (Repository repo : Iterables.concat(Collections.singletonList(context.getRepository()), context.getAlternates())) {
                    timer.mark("resolve refs");
                    futures.add(completionService.submit(() -> this.resolveRefs(repo, context), null));
                }
                while (!futures.isEmpty() && (completed = completionService.take()) != null) {
                    futures.remove(completed);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for refs to resolve", e);
            }
            finally {
                futures.forEach(future -> future.cancel(true));
            }
        }
    }

    private void resolveRefsSimple(RescopeContext context) {
        this.resolveRefs(context.getRepository(), context);
        for (Repository alternate : context.getAlternates()) {
            this.resolveRefs(alternate, context);
        }
    }

    private void setTargetStateOnRescopeChains(RescopeContext context, List<PullRequestRescopeChain.Builder> chainBuilders) {
        Date now = new Date();
        this.resolveRefs(context);
        for (PullRequestRescopeChain.Builder chain : chainBuilders) {
            SimpleMinimalPullRequest pullRequest = chain.getPullRequest();
            String targetFromHash = context.resolve(pullRequest.getFromRef());
            String targetToHash = context.resolve(pullRequest.getToRef());
            log.trace("{}: Resolved target from-hash: {}; to-hash: {}", new Object[]{chain.getPullRequest(), targetFromHash, targetToHash});
            chain.targetState(now, targetFromHash, targetToHash);
        }
    }

    private void updatePullRequestRefsInScm(Collection<PullRequest> pullRequests) {
        if (!pullRequests.isEmpty()) {
            this.scmService.updatePullRequestRefs(new UpdatePullRequestRefsCommandParameters.Builder().pullRequests(pullRequests).build());
        }
    }

    private static class RescopeContext {
        private static final BinaryOperator<Instant> OLDEST = (date1, date2) -> {
            if (date1 == null) {
                return date2;
            }
            if (date2 == null) {
                return date1;
            }
            return date1.isBefore((Instant)date2) ? date1 : date2;
        };
        private final Set<Repository> alternates;
        private final Instant deleteRequestsAfter;
        private final Map<Integer, Map<String, Instant>> incompleteDateByRepoRef;
        private final Repository repository;
        private final boolean resolveTailGap;
        private final Map<Repository, Map<String, String>> resolvedRefs;
        private int errorCount;
        private int skippedCount;

        RescopeContext(Repository repository, int deleteDelaySeconds, boolean resolveTailGap) {
            this.repository = repository;
            this.resolveTailGap = resolveTailGap;
            this.alternates = new HashSet<Repository>();
            this.deleteRequestsAfter = Instant.now().minus(deleteDelaySeconds, ChronoUnit.SECONDS);
            this.incompleteDateByRepoRef = new HashMap<Integer, Map<String, Instant>>();
            this.resolvedRefs = new ConcurrentHashMap<Repository, Map<String, String>>();
        }

        public Set<Repository> getAlternates() {
            return this.alternates;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public String resolve(PullRequestRef ref) {
            return this.getResolvedRefs(ref.getRepository()).get(ref.getId());
        }

        List<PullRequestRescopeChain.Builder> createChainBuilders(Iterable<PullRequest> pullRequests) {
            ArrayList<PullRequestRescopeChain.Builder> builders = new ArrayList<PullRequestRescopeChain.Builder>();
            HashSet<Long> globalIds = new HashSet<Long>();
            for (PullRequest pr : pullRequests) {
                InternalPullRequest pullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)pr);
                if (!globalIds.add(pullRequest.getGlobalId())) continue;
                if (!pullRequest.isLocked()) {
                    try {
                        builders.add(new PullRequestRescopeChain.Builder(pullRequest, this.resolveTailGap));
                        this.add((PullRequestRef)pullRequest.getFromRef());
                        this.add((PullRequestRef)pullRequest.getToRef());
                        continue;
                    }
                    catch (IllegalStateException e) {
                        log.warn("{}: Could not create chain builder, skipping", (Object)pullRequest, (Object)e);
                        ++this.errorCount;
                    }
                } else {
                    ++this.skippedCount;
                }
                this.markIncomplete((PullRequestRef)pullRequest.getFromRef(), pullRequest.getRescopedDate().toInstant());
                this.markIncomplete((PullRequestRef)pullRequest.getToRef(), pullRequest.getRescopedDate().toInstant());
            }
            return builders;
        }

        int getErrorCount() {
            return this.errorCount;
        }

        Map<String, String> getResolvedRefs(Repository repository) {
            return this.resolvedRefs.computeIfAbsent(repository, repo -> new HashMap());
        }

        int getSkippedCount() {
            return this.skippedCount;
        }

        boolean isSafeToDelete(InternalRescopeRequest request) {
            if (!request.getRepository().equals((Object)this.repository)) {
                return false;
            }
            if (!request.getRefChanges().isEmpty() && request.getCreatedDate().toInstant().isAfter(this.deleteRequestsAfter)) {
                return false;
            }
            Map<String, Instant> incompleteByRefId = this.incompleteDateByRepoRef.get(request.getRepository().getId());
            if (incompleteByRefId == null) {
                return true;
            }
            if (request.getRefChanges().isEmpty()) {
                return incompleteByRefId.values().stream().noneMatch(incompleteAfter -> request.getCreatedDate().toInstant().isAfter((Instant)incompleteAfter));
            }
            for (RefChange change : request.getRefChanges()) {
                Instant incompleteAfter2 = incompleteByRefId.get(change.getRef().getId());
                if (incompleteAfter2 == null || !request.getCreatedDate().toInstant().isAfter(incompleteAfter2)) continue;
                return false;
            }
            return true;
        }

        void markIncomplete(PullRequestRef ref, Instant incompleteAfter) {
            Map incompleteByRefId = this.incompleteDateByRepoRef.computeIfAbsent(ref.getRepository().getId(), repoId -> new HashMap());
            incompleteByRefId.merge(ref.getId(), incompleteAfter, OLDEST);
        }

        void markIncomplete(SimpleMinimalPullRequest pullRequest) {
            this.markIncomplete(pullRequest.getFromRef(), pullRequest.getRescopeDate().toInstant());
            this.markIncomplete(pullRequest.getToRef(), pullRequest.getRescopeDate().toInstant());
        }

        private void add(PullRequestRef ref) {
            this.getResolvedRefs(ref.getRepository()).putIfAbsent(ref.getId(), null);
            if (!ref.getRepository().equals((Object)this.repository)) {
                this.alternates.add(ref.getRepository());
            }
        }
    }

    private static class SimpleBulkRescopeContext
    implements BulkRescopeContext {
        private final List<PullRequestRescopeChain> chains;
        private final int maxCommitIds;

        private SimpleBulkRescopeContext(List<PullRequestRescopeChain> chains, int maxCommitIds) {
            this.chains = chains;
            this.maxCommitIds = maxCommitIds;
        }

        public void decline(@Nonnull PullRequestRescope rescope) {
            this.asSimpleRescope(rescope).setOutcome((RescopeOutcome)new DeclineOutcome());
        }

        public int getMaxCommitIds() {
            return this.maxCommitIds;
        }

        @Nonnull
        public Iterator<PullRequestRescope> iterator() {
            return ((List)this.chains.stream().flatMap(chain -> chain.getRescopes().stream()).filter(rescope -> rescope.getOutcome() == null).collect(MoreCollectors.toImmutableList())).iterator();
        }

        public void merge(@Nonnull PullRequestRescope rescope, @Nullable String mergeHash) {
            this.asSimpleRescope(rescope).setOutcome((RescopeOutcome)new MergeOutcome(mergeHash));
        }

        public void update(@Nonnull PullRequestRescope rescope, @Nonnull RescopeDetails addedCommits, @Nonnull RescopeDetails removedCommits) {
            this.asSimpleRescope(rescope).setOutcome((RescopeOutcome)new UpdateOutcome(addedCommits, removedCommits));
        }

        private SimplePullRequestRescope asSimpleRescope(PullRequestRescope rescope) {
            if (rescope instanceof SimplePullRequestRescope) {
                return (SimplePullRequestRescope)rescope;
            }
            throw new IllegalArgumentException("Only rescopes from the context can be used");
        }
    }
}

