/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.pull.SimpleRescopeDetails;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetails;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetailsProvider;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="pullRequestRescopeActivityDetailsProvider")
public class DefaultRescopeActivityDetailsProvider
implements InternalRescopeActivityDetailsProvider {
    private final CommitService commitService;
    private final int displayCommits;
    private final int maxCommits;

    @Autowired
    public DefaultRescopeActivityDetailsProvider(CommitService commitService, @Value(value="${pullrequest.rescope.commits.display}") int displayCommits, @Value(value="${pullrequest.rescope.commits.max}") int maxCommits) {
        this.commitService = commitService;
        this.displayCommits = displayCommits;
        this.maxCommits = maxCommits;
    }

    @Nonnull
    public InternalRescopeActivityDetails getDetails(@Nonnull InternalPullRequestRescopeActivity activity) {
        InternalPullRequest pullRequest = activity.getPullRequest();
        InternalRepository repository = pullRequest.getScopeRepository();
        InternalRepository secondaryRepository = pullRequest.isCrossRepository() ? pullRequest.getFromRef().getRepository() : null;
        HashMap<String, Commit> cache = new HashMap<String, Commit>(this.maxCommits);
        Set<String> current = this.getCommitsBetween(repository, secondaryRepository, activity.getToHash(), activity.getFromHash(), cache);
        Set<String> previous = this.getCommitsBetween(repository, secondaryRepository, activity.getPreviousToHash(), activity.getPreviousFromHash(), cache);
        return new InternalRescopeActivityDetails(this.toRescopeDetails(current, previous, cache), this.toRescopeDetails(previous, current, cache));
    }

    private Set<String> getCommitsBetween(InternalRepository repository, InternalRepository secondaryRepository, String untilId, String sinceId, Map<String, Commit> cache) {
        MappingCommitCallback currentCallback = new MappingCommitCallback(cache, this.maxCommits);
        this.commitService.streamCommitsBetween(((CommitsBetweenRequest.Builder)new CommitsBetweenRequest.Builder((Repository)repository).exclude(untilId, new String[0]).ignoreMissing(true)).include(sinceId, new String[0]).secondaryRepository((Repository)secondaryRepository).build(), (CommitCallback)currentCallback);
        return currentCallback.getCommitIds();
    }

    private SimpleRescopeDetails toRescopeDetails(Set<String> include, Set<String> exclude, Map<String, Commit> cache) {
        HashSet<String> difference = new HashSet<String>(include);
        difference.removeAll(exclude);
        if (difference.isEmpty()) {
            return SimpleRescopeDetails.EMPTY;
        }
        List<Object> commits = new ArrayList<Commit>(difference.size());
        for (String commitId : difference) {
            Commit commit = cache.get(commitId);
            if (commit == null) continue;
            commits.add(commit);
        }
        if (commits.size() > this.displayCommits) {
            Collections.sort(commits, SimpleRescopeDetails.DATE_ORDER);
            commits = commits.subList(0, this.displayCommits);
        }
        return new SimpleRescopeDetails.Builder().commits(commits).total(difference.size()).build();
    }

    private static class MappingCommitCallback
    extends AbstractCommitCallback {
        private final Map<String, Commit> cache;
        private final Set<String> commitIds;
        private final int maxCommits;

        private MappingCommitCallback(Map<String, Commit> cache, int maxCommits) {
            this.cache = cache;
            this.maxCommits = maxCommits;
            this.commitIds = new HashSet<String>();
        }

        private Set<String> getCommitIds() {
            return this.commitIds;
        }

        public boolean onCommit(@Nonnull Commit commit) {
            String commitId = commit.getId();
            if (this.cache.size() < this.maxCommits) {
                this.cache.put(commitId, commit);
            }
            this.commitIds.add(commitId);
            return true;
        }
    }
}

