/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.concurrent.ExecutionIdManager;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeScheduler;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeTask;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
@DefaultApplicationMode
public class PullRequestRescopeBucketProcessor
extends AbstractSmartLifecycle
implements PullRequestRescopeScheduler,
BucketProcessor<PullRequestRescopeTask> {
    private static final Logger log = LoggerFactory.getLogger(PullRequestRescopeBucketProcessor.class);
    private final RescopeRequestDao dao;
    private final ExecutionIdManager executionManager;
    private final BucketedExecutor<PullRequestRescopeTask> executor;
    private final RepositoryService repositoryService;
    private final InternalPullRequestRescopeService rescopeService;
    private final TransactionTemplate transactionTemplate;
    private final EscalatedSecurityContext withRepoRead;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${pullrequest.rescope.retry.delay.increment}")
    private Duration delayIncrement;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${pullrequest.rescope.retry.delay.offline}")
    private Duration delayOffline;
    @Value(value="${pullrequest.rescope.max.attempts}")
    private int maxAttempts;

    @Autowired
    public PullRequestRescopeBucketProcessor(ConcurrencyService concurrencyService, RescopeRequestDao dao, ExecutionIdManager executionManager, RepositoryService repositoryService, InternalPullRequestRescopeService rescopeService, SecurityService securityService, PlatformTransactionManager transactionManager, @Value(value="${pullrequest.rescope.threads}") int maxThreads) {
        this.dao = dao;
        this.repositoryService = repositoryService;
        this.rescopeService = rescopeService;
        this.executionManager = executionManager;
        this.executor = concurrencyService.getBucketedExecutor("pull-request-rescoping", new BucketedExecutorSettings.Builder(PullRequestRescopeTask.TO_BUCKET_ID, (BucketProcessor)this).maxAttempts(2).maxConcurrency(maxThreads, ConcurrencyPolicy.PER_NODE).build());
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, ((Object)((Object)this)).getClass().getSimpleName());
    }

    public int getPhase() {
        return 1600;
    }

    public void process(@Nonnull String bucketId, @Nonnull List<PullRequestRescopeTask> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        Repository repository = (Repository)this.withRepoRead.call(() -> this.repositoryService.getById(Integer.parseInt(bucketId)));
        if (repository == null) {
            log.debug("-/-[{}]: Rescope processing skipped due to repository deletion", (Object)bucketId);
            return;
        }
        if (repository.getState() == Repository.State.OFFLINE) {
            log.debug("{}: Rescope processing skipped due to offline repository - retrying in {}", (Object)repository, (Object)this.delayOffline);
            int maxAttempt = tasks.stream().mapToInt(PullRequestRescopeTask::getAttempt).max().orElse(1);
            this.scheduleTask(repository, maxAttempt, this.delayOffline.toMillis());
            return;
        }
        RepositoryRescopeResult result = (RepositoryRescopeResult)this.executionManager.run(() -> this.rescopeService.rescope(repository));
        if (!result.isDone()) {
            int attempt = tasks.stream().mapToInt(PullRequestRescopeTask::getAttempt).max().orElse(1) + 1;
            if (attempt <= this.maxAttempts || result.hasSkippedAny()) {
                long delayMs = attempt <= this.maxAttempts ? this.getDelayMillis(attempt) : InternalPullRequest.LOCK_TIMEOUT_MILLIS;
                log.info("{}: Some pull requests were not rescoped. ({} failed, {} locked). Scheduling attempt {} in {}ms", new Object[]{repository, result.getErrorCount(), result.getSkippedCount(), attempt, delayMs});
                this.scheduleTask(repository, attempt, delayMs);
            } else {
                log.warn("{}: Failed to rescope one or more pull requests ({} attempts)", (Object)repository, (Object)attempt);
            }
        } else {
            log.debug("{}: Rescoping completed ({} errors, {} skipped)", new Object[]{repository, result.getErrorCount(), result.getSkippedCount()});
        }
    }

    public void schedule(@Nonnull InternalRepository repository, @Nonnull InternalApplicationUser user, @Nonnull Collection<? extends RefChange> refChanges) {
        log.debug("{}: Requesting rescope processing", (Object)repository);
        if (this.rescopeService.createRequest(repository, user, refChanges)) {
            if (this.isRunning()) {
                this.scheduleTask((Repository)repository, 1, 0L);
            } else {
                log.debug("{}: Not scheduling rescoping; the processor has not started yet", (Object)repository);
            }
        } else {
            log.debug("{}: Not scheduling rescoping; no relevant refs were changed", (Object)repository);
        }
    }

    public void start() {
        super.start();
        List repositoryIds = (List)this.transactionTemplate.execute(status -> this.dao.findPendingRepositoryIds());
        Iterator iterator = repositoryIds.iterator();
        while (iterator.hasNext()) {
            int repositoryId = (Integer)iterator.next();
            this.executor.submit((Serializable)new PullRequestRescopeTask(repositoryId, 1));
        }
        if (!repositoryIds.isEmpty()) {
            log.info("Rescheduled rescope processing for {} repositories: {}", (Object)repositoryIds.size(), (Object)repositoryIds);
        }
    }

    public void stop() {
        this.executor.shutdown();
        super.stop();
    }

    @VisibleForTesting
    void setDelayIncrement(Duration delayIncrement) {
        this.delayIncrement = delayIncrement;
    }

    @VisibleForTesting
    void setDelayOffline(Duration delayOffline) {
        this.delayOffline = delayOffline;
    }

    @VisibleForTesting
    void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    private long getDelayMillis(long attempt) {
        return TimeUnit.SECONDS.toMillis(Math.max(0L, (attempt - 1L) * this.delayIncrement.getSeconds()));
    }

    private void scheduleTask(Repository repository, int attempt, long delayMs) {
        this.executor.schedule((Serializable)new PullRequestRescopeTask(repository.getId(), attempt), delayMs, TimeUnit.MILLISECONDS);
    }
}

