/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.rescope.SimpleMinimalPullRequest;
import com.atlassian.stash.internal.pull.rescope.SimplePullRequestRescope;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestRescopeChain {
    private static final Logger log = LoggerFactory.getLogger(PullRequestRescopeChain.class);
    private static final String DELETED_REF = "deleted-ref";
    private final SimpleMinimalPullRequest pullRequest;
    private final List<SimplePullRequestRescope> rescopes;

    private PullRequestRescopeChain(SimpleMinimalPullRequest pullRequest, List<SimplePullRequestRescope> rescopes) {
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        this.rescopes = Objects.requireNonNull(rescopes, "rescopes");
    }

    @Nonnull
    public SimpleMinimalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public List<SimplePullRequestRescope> getRescopes() {
        return this.rescopes;
    }

    private static class GapMatch {
        private final boolean gapAfterFiller;
        private final boolean gapBeforeFiller;
        private final boolean failed;
        private final MinimalRefChange remainingGap;

        private GapMatch(String gapOldHash, String gapNewHash, MinimalRefChange filler) {
            boolean startAligns = false;
            boolean endAligns = false;
            if (filler != null) {
                startAligns = ShaUtils.hashesMatch((String)gapOldHash, (String)filler.oldHash);
                endAligns = ShaUtils.hashesMatch((String)gapNewHash, (String)filler.newHash);
            }
            boolean bl = this.failed = filler != null && !startAligns && !endAligns;
            this.remainingGap = this.failed ? null : (startAligns && (endAligns || gapNewHash == null) ? null : (startAligns ? new MinimalRefChange(filler.newHash, gapNewHash) : (endAligns ? new MinimalRefChange(gapOldHash, filler.oldHash) : (gapNewHash != null && !ShaUtils.hashesMatch((String)gapOldHash, (String)gapNewHash) ? new MinimalRefChange(gapOldHash, gapNewHash) : null))));
            this.gapBeforeFiller = this.remainingGap != null && endAligns;
            this.gapAfterFiller = this.remainingGap != null && startAligns && this.remainingGap.newHash.equals(gapNewHash);
        }
    }

    private static class Segment {
        private final Instant date;
        private final MinimalRefChange fromRefChange;
        private final MinimalRefChange toRefChange;
        private final ApplicationUser user;

        private Segment(MinimalRefChange fromRefChange, MinimalRefChange toRefChange) {
            this(null, null, fromRefChange, toRefChange);
        }

        private Segment(Instant date, ApplicationUser user, MinimalRefChange fromRefChange, MinimalRefChange toRefChange) {
            this.date = date;
            this.fromRefChange = fromRefChange;
            this.toRefChange = toRefChange;
            this.user = user;
        }

        public String toString() {
            return "{user: " + (this.user == null ? "<unknown>" : this.user.getName()) + ", date: " + Objects.toString(this.date, "<unknown>") + ", from-ref: " + Objects.toString(this.fromRefChange, "<unchanged>") + ", to-ref: " + Objects.toString(this.toRefChange, "<unchanged>") + "}";
        }

        private String getNewFromHash() {
            return this.fromRefChange == null ? null : this.fromRefChange.newHash;
        }

        private String getNewToHash() {
            return this.toRefChange == null ? null : this.toRefChange.newHash;
        }

        private String getOldFromHash() {
            return this.fromRefChange == null ? null : this.fromRefChange.oldHash;
        }

        private String getOldToHash() {
            return this.toRefChange == null ? null : this.toRefChange.oldHash;
        }
    }

    private static class MinimalRefChange {
        private final String oldHash;
        private final String newHash;

        MinimalRefChange(@Nonnull String oldHash, @Nonnull String newHash) {
            this.oldHash = Objects.requireNonNull(oldHash, "oldHash");
            this.newHash = Objects.requireNonNull(newHash, "newHash");
        }

        public String toString() {
            return "{old-hash: " + this.oldHash + ", new-hash: " + this.newHash + "}";
        }

        private static MinimalRefChange valueOf(RefChange change) {
            if (change == null) {
                return null;
            }
            switch (change.getType()) {
                case ADD: {
                    throw new IllegalArgumentException("Adds should be ignored");
                }
                case DELETE: {
                    return new MinimalRefChange(change.getFromHash(), PullRequestRescopeChain.DELETED_REF);
                }
            }
            return new MinimalRefChange(change.getFromHash(), change.getToHash());
        }
    }

    public static class Builder {
        private final List<InternalRescopeRequest> fullRepoRescopes;
        private final SimpleMinimalPullRequest pullRequest;
        private final Instant startDate;
        private final boolean resolveTailGap;
        private final LinkedList<Segment> segments;
        private Instant targetDate;
        private String targetFromRefHash;
        private String targetToRefHash;

        public Builder(@Nonnull SimpleMinimalPullRequest pullRequest, boolean resolveTailGap) {
            this.pullRequest = pullRequest;
            this.startDate = pullRequest.getRescopeDate().toInstant();
            this.resolveTailGap = resolveTailGap;
            this.fullRepoRescopes = new ArrayList<InternalRescopeRequest>(2);
            this.segments = new LinkedList();
            this.targetDate = Instant.now();
        }

        @VisibleForTesting
        Builder(InternalPullRequest pullRequest, boolean resolveTailGap) {
            this(new SimpleMinimalPullRequest(pullRequest), resolveTailGap);
        }

        @Nonnull
        public PullRequestRescopeChain build() {
            return new PullRequestRescopeChain(this.pullRequest, this.buildRescopes());
        }

        @Nonnull
        public SimpleMinimalPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @Nonnull
        public Builder request(InternalRescopeRequest request) {
            InternalRepository repository = request.getRepository();
            boolean matchFrom = repository.equals((Object)this.pullRequest.getFromRef().getRepository());
            boolean matchTo = repository.equals((Object)this.pullRequest.getToRef().getRepository());
            if (!matchFrom && !matchTo) {
                log.debug("{}: Rescope request ignored as it targets a different repository (repository={})", (Object)this.pullRequest, (Object)repository);
                return this;
            }
            if (request.getRefChanges().isEmpty()) {
                log.debug("{}: Adding full repository rescope request", (Object)repository);
                this.fullRepoRescopes.add(request);
                return this;
            }
            MinimalRefChange fromChange = null;
            MinimalRefChange toChange = null;
            String fromRefId = this.pullRequest.getFromRef().getId();
            String toRefId = this.pullRequest.getToRef().getId();
            for (RefChange change : request.getRefChanges()) {
                if (matchFrom && fromChange == null && change.getRef().getId().equals(fromRefId)) {
                    fromChange = MinimalRefChange.valueOf(change);
                    continue;
                }
                if (!matchTo || toChange != null || !change.getRef().getId().equals(toRefId)) continue;
                toChange = MinimalRefChange.valueOf(change);
            }
            if (fromChange == null && toChange == null) {
                log.debug("{}: Ignoring rescope request {} since it contains no ref changes relevant to this pull request", (Object)this.pullRequest, (Object)request.getId());
            } else {
                Segment segment = new Segment(request.getCreatedDate().toInstant(), (ApplicationUser)request.getUser(), fromChange, toChange);
                log.debug("{}: Adding segment to rescope chain - {}", (Object)this.pullRequest, (Object)segment);
                this.segments.add(segment);
            }
            return this;
        }

        @Nonnull
        public Builder targetState(@Nonnull Date targetDate, @Nullable String targetFromHash, @Nullable String targetToHash) {
            this.targetDate = targetDate.toInstant();
            this.targetFromRefHash = targetFromHash == null ? PullRequestRescopeChain.DELETED_REF : targetFromHash;
            this.targetToRefHash = targetToHash == null ? PullRequestRescopeChain.DELETED_REF : targetToHash;
            return this;
        }

        private static String resolveSegmentHash(String segmentHash, @Nonnull String previousHash) {
            if (PullRequestRescopeChain.DELETED_REF.equals(segmentHash)) {
                return null;
            }
            return (String)MoreObjects.firstNonNull((Object)segmentHash, (Object)previousHash);
        }

        @Nonnull
        private List<SimplePullRequestRescope> buildRescopes() {
            List<Segment> chain = this.buildSegmentChain();
            String fromHash = this.pullRequest.getFromRef().getLatestCommit();
            String toHash = this.pullRequest.getToRef().getLatestCommit();
            ImmutableList.Builder result = ImmutableList.builder();
            for (Segment segment : chain) {
                SimplePullRequestRescope rescope = this.createPullRequestRescope(segment, fromHash, toHash);
                fromHash = rescope.getNewFromHash();
                toHash = rescope.getNewToHash();
                result.add((Object)rescope);
                if (toHash != null && fromHash != null) continue;
                return result.build();
            }
            return result.build();
        }

        @Nonnull
        private List<Segment> buildSegmentChain() {
            Instant nextDate;
            Instant prevDate;
            Segment resolvedGap;
            Segment gap = this.maybeCreateGap(this.pullRequest.getFromRef().getLatestCommit(), this.pullRequest.getToRef().getLatestCommit(), this.targetFromRefHash, this.targetToRefHash);
            Instant pullRequestRescopeDate = this.pullRequest.getRescopeDate().toInstant();
            ArrayList<Segment> previousSegments = new ArrayList<Segment>();
            ArrayList newSegments = new ArrayList();
            for (Segment segment : this.segments) {
                (segment.date.isBefore(pullRequestRescopeDate) ? previousSegments : newSegments).add(segment);
            }
            int gapIndex = 0;
            ArrayList<Segment> chain = new ArrayList<Segment>(Math.max(1, this.segments.size()));
            block1: for (List availableSegments : Arrays.asList(newSegments, previousSegments)) {
                while (gap != null && !availableSegments.isEmpty()) {
                    int chainSize = chain.size();
                    Iterator it = availableSegments.iterator();
                    while (gap != null && it.hasNext()) {
                        boolean endGapRemains;
                        Segment segment = (Segment)it.next();
                        GapMatch from = new GapMatch(gap.getOldFromHash(), gap.getNewFromHash(), segment.fromRefChange);
                        GapMatch to = new GapMatch(gap.getOldToHash(), gap.getNewToHash(), segment.toRefChange);
                        boolean startGapRemains = from.gapBeforeFiller || to.gapBeforeFiller;
                        boolean bl = endGapRemains = from.gapAfterFiller || to.gapAfterFiller;
                        if (from.failed || to.failed || startGapRemains && endGapRemains) continue;
                        if (startGapRemains) {
                            this.insertAtOrAfter(gapIndex, segment, chain);
                        } else {
                            chain.add(gapIndex, segment);
                            ++gapIndex;
                        }
                        it.remove();
                        gap = from.remainingGap == null && to.remainingGap == null ? null : new Segment(from.remainingGap, to.remainingGap);
                    }
                    if (chainSize != chain.size()) continue;
                    continue block1;
                }
            }
            if (gap != null && (resolvedGap = this.resolve(gap, prevDate = gapIndex > 0 ? ((Segment)chain.get((int)(gapIndex - 1))).date : this.startDate, nextDate = gapIndex < chain.size() ? ((Segment)chain.get((int)gapIndex)).date : this.targetDate)) != null) {
                chain.add(gapIndex, resolvedGap);
            }
            return chain;
        }

        private void insertAtOrAfter(int index, Segment segment, List<Segment> segments) {
            int insertIndex = index;
            boolean fromUpdated = segment.fromRefChange != null;
            boolean toUpdated = segment.toRefChange != null;
            ListIterator<Segment> it = segments.listIterator(index);
            while (it.hasNext()) {
                Segment s = (Segment)it.next();
                if (fromUpdated && s.fromRefChange != null || toUpdated && s.toRefChange != null || segment.date.isBefore(s.date)) break;
                ++insertIndex;
            }
            segments.add(insertIndex, segment);
        }

        private Segment maybeCreateGap(String oldFrom, String oldTo, String newFrom, String newTo) {
            MinimalRefChange fromRefGap = null;
            MinimalRefChange toRefGap = null;
            if (newFrom != null && !ShaUtils.hashesMatch((String)oldFrom, (String)newFrom)) {
                fromRefGap = new MinimalRefChange(oldFrom, newFrom);
            }
            if (newTo != null && !ShaUtils.hashesMatch((String)oldTo, (String)newTo)) {
                toRefGap = new MinimalRefChange(oldTo, newTo);
            }
            if (fromRefGap != null || toRefGap != null) {
                return new Segment(fromRefGap, toRefGap);
            }
            return null;
        }

        private SimplePullRequestRescope createPullRequestRescope(Segment segment, @Nonnull String prevFromHash, @Nonnull String prevToHash) {
            String oldFromHash = Objects.requireNonNull(Builder.resolveSegmentHash(segment.getOldFromHash(), prevFromHash), "oldFromHash");
            String newFromHash = Builder.resolveSegmentHash(segment.getNewFromHash(), prevFromHash);
            String oldToHash = Objects.requireNonNull(Builder.resolveSegmentHash(segment.getOldToHash(), prevToHash), "oldToHash");
            String newToHash = Builder.resolveSegmentHash(segment.getNewToHash(), prevToHash);
            return new SimplePullRequestRescope(this.pullRequest, Date.from(segment.date), segment.user, oldFromHash, oldToHash, newFromHash, newToHash);
        }

        private ApplicationUser getBestUser(Segment gap) {
            int fromWeight = gap.fromRefChange != null ? 5 : 1;
            int toWeight = gap.toRefChange != null ? 3 : 1;
            HashMap userScores = new HashMap();
            this.segments.stream().filter(s -> s.user != null).forEach(segment -> {
                int score = fromWeight * (segment.fromRefChange == null ? 0 : 1) + toWeight * (segment.toRefChange == null ? 0 : 1);
                userScores.compute(segment.user, (user, value) -> value == null ? score : value + score);
            });
            this.fullRepoRescopes.forEach(req -> userScores.compute(req.getUser(), (user, value) -> value == null ? 1 : value + 1));
            return userScores.entrySet().stream().reduce((entry, best) -> best == null || (Integer)best.getValue() < (Integer)entry.getValue() ? entry : best).map(Map.Entry::getKey).orElse(this.pullRequest.getAuthor());
        }

        private Segment resolve(Segment segment, Instant lowerBound, Instant upperBound) {
            Iterator<InternalRescopeRequest> it = this.fullRepoRescopes.iterator();
            while (it.hasNext()) {
                InternalRescopeRequest request = it.next();
                Instant date = request.getCreatedDate().toInstant();
                if (date.isBefore(lowerBound) || date.isAfter(upperBound) || !request.getRefChanges().isEmpty()) continue;
                it.remove();
                return new Segment(date, (ApplicationUser)request.getUser(), segment.fromRefChange, segment.toRefChange);
            }
            if (!this.resolveTailGap) {
                if (segment.fromRefChange != null && Objects.equals(this.targetFromRefHash, segment.fromRefChange.newHash)) {
                    log.debug("{}: A gap was detected at the end of the from-ref pull request history: ({} -> {}). Skipping.", new Object[]{this.pullRequest, segment.fromRefChange.oldHash, this.targetFromRefHash});
                    segment = new Segment(segment.date, segment.user, null, segment.toRefChange);
                }
                if (segment.toRefChange != null && Objects.equals(this.targetToRefHash, segment.toRefChange.newHash)) {
                    log.debug("{}: A gap was detected at the end of the to-ref pull request history: ({} -> {}). Skipping.", new Object[]{this.pullRequest, segment.toRefChange.oldHash, this.targetToRefHash});
                    segment = new Segment(segment.date, segment.user, segment.fromRefChange, null);
                }
                if (segment.toRefChange == null && segment.fromRefChange == null) {
                    return null;
                }
            }
            Instant date = upperBound.minusSeconds(1L);
            ApplicationUser bestUser = this.getBestUser(segment);
            log.warn("{}: A gap was detected in the pull request history: ({}). Attributing the scope change to user {} and setting the rescope date to {} based on known changes", new Object[]{this.pullRequest, segment, bestUser == null ? "unknown" : bestUser.getName(), date});
            return new Segment(date, bestUser, segment.fromRefChange, segment.toRefChange);
        }
    }
}

