/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.dmz.commit.DmzCommitEnricher;
import com.atlassian.bitbucket.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.SimpleRescopeDetails;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RescopePullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private final DmzCommitEnricher commitEnricher;
    private final RescopeProcessor rescopeProcessor;
    private final ScmService scmService;

    @Autowired
    public RescopePullRequestActivityEnricher(DmzCommitEnricher commitEnricher, RescopeProcessor rescopeProcessor, ScmService scmService) {
        this.commitEnricher = commitEnricher;
        this.rescopeProcessor = rescopeProcessor;
        this.scmService = scmService;
    }

    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Iterable<InternalPullRequestActivity> activities) {
        String timerName = "Enrich: Rescopes from " + pullRequest.getGlobalId() + " (" + Iterables.size(activities) + ")";
        try (Timer ignored = TimerUtils.start((String)timerName);){
            new ActivityEnricher(pullRequest).enrich(activities);
        }
    }

    private class ActivityEnricher
    extends AbstractPullRequestActivityVisitor {
        private final Set<String> commitIds;
        private final List<InternalPullRequestRescopeActivity> pendingRescopes;
        private final List<InternalPullRequestRescopeActivity> precalculatedRescopes;
        private final InternalPullRequest pullRequest;

        private ActivityEnricher(InternalPullRequest pullRequest) {
            this.pullRequest = pullRequest;
            this.commitIds = new HashSet<String>();
            this.pendingRescopes = new ArrayList<InternalPullRequestRescopeActivity>();
            this.precalculatedRescopes = new ArrayList<InternalPullRequestRescopeActivity>();
        }

        public void enrich(Iterable<InternalPullRequestActivity> activities) {
            activities.forEach(activity -> activity.accept((PullRequestActivityVisitor)this));
            RescopePullRequestActivityEnricher.this.rescopeProcessor.processAll(this.pullRequest, this.pendingRescopes);
            this.applyPrecalculatedCommits();
        }

        public void visit(@Nonnull PullRequestRescopeActivity activity) {
            InternalPullRequestRescopeActivity rescopeActivity = (InternalPullRequestRescopeActivity)activity;
            if (rescopeActivity.isPrecalculated()) {
                rescopeActivity.getCommits().stream().map(InternalPullRequestRescopeCommit::getCommitId).forEach(this.commitIds::add);
                this.precalculatedRescopes.add(rescopeActivity);
            } else {
                this.pendingRescopes.add(rescopeActivity);
            }
        }

        private void applyPrecalculatedCommits() {
            if (this.precalculatedRescopes.isEmpty()) {
                return;
            }
            ImmutableMap commitsById = Maps.uniqueIndex(this.loadCommits(), MinimalCommit::getId);
            for (InternalPullRequestRescopeActivity activity : this.precalculatedRescopes) {
                SimpleRescopeDetails.Builder added = new SimpleRescopeDetails.Builder().total(activity.getTotalAdded());
                SimpleRescopeDetails.Builder removed = new SimpleRescopeDetails.Builder().total(activity.getTotalRemoved());
                for (InternalPullRequestRescopeCommit rescopeCommit : activity.getCommits()) {
                    Commit commit = (Commit)commitsById.get(rescopeCommit.getCommitId());
                    if (commit == null) continue;
                    if (rescopeCommit.getAction() == PullRequestRescopeCommitAction.ADDED) {
                        added.commit(commit);
                        continue;
                    }
                    removed.commit(commit);
                }
                activity.setAdded(added.build());
                activity.setRemoved(removed.build());
            }
        }

        private Iterable<Commit> loadCommits() {
            if (this.commitIds.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList commits = new ArrayList(this.commitIds.size());
            RescopePullRequestActivityEnricher.this.scmService.getCommandFactory((Repository)this.pullRequest.getScopeRepository()).commits(new CommitsCommandParameters.Builder().ignoreMissing(true).include(this.commitIds).secondaryRepository((Repository)this.pullRequest.getFromRef().getRepository()).traverse(false).build(), commit -> {
                commits.add(commit);
                return true;
            }).call();
            return RescopePullRequestActivityEnricher.this.commitEnricher.enrichAll((Repository)this.pullRequest.getScopeRepository(), commits, null);
        }
    }
}

