/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.reviewer;

import com.atlassian.bitbucket.dmz.pull.reviewer.DmzReviewerGroupService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.pull.reviewer.DuplicateReviewerGroupException;
import com.atlassian.bitbucket.pull.reviewer.EmptyReviewerGroupException;
import com.atlassian.bitbucket.pull.reviewer.NoSuchReviewerGroupException;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupCreateRequest;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupService;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupUpdateRequest;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupUserLimitException;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.pull.reviewer.InternalReviewerGroup;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupCreatedEvent;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupDao;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupDeletedEvent;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={DmzReviewerGroupService.class, ReviewerGroupService.class})
@Service(value="reviewerGroupService")
public class DefaultReviewerGroupService
extends AbstractService
implements DmzReviewerGroupService {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final int maxReviewerGroups;
    private final int maxUsers;
    private final PermissionValidationService permissionValidationService;
    private final ReviewerGroupDao reviewerGroupDao;

    @Autowired
    public DefaultReviewerGroupService(ReviewerGroupDao reviewerGroupDao, I18nService i18nService, PermissionValidationService permissionValidationService, EventPublisher eventPublisher, @Value(value="${page.max.reviewergroups}") int maxReviewerGroups, @Value(value="${pullrequest.reviewergroups.max.size}") int maxUsers) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.reviewerGroupDao = reviewerGroupDao;
        this.maxReviewerGroups = maxReviewerGroups;
        this.maxUsers = maxUsers;
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public InternalReviewerGroup create(@Nonnull ReviewerGroupCreateRequest request) {
        Objects.requireNonNull(request, "request");
        if (request.getUsers().isEmpty()) {
            throw new EmptyReviewerGroupException(this.i18nService.createKeyedMessage("bitbucket.service.reviewergroup.empty", new Object[0]));
        }
        this.checkUserSizeLimit(request.getUsers());
        this.validateAdminPermission(request.getScope());
        this.checkForNameDuplicate(request.getScope(), request.getName());
        InternalReviewerGroup reviewerGroup = new InternalReviewerGroup.Builder(request.getName(), request.getScope()).description(request.getDescription()).users((Iterable)request.getUsers()).build();
        this.eventPublisher.publish((Object)new ReviewerGroupCreatedEvent(this, (ReviewerGroup)reviewerGroup));
        return (InternalReviewerGroup)this.reviewerGroupDao.create((Object)reviewerGroup);
    }

    @Transactional
    @Secured(value="Permission check performed internally")
    public void delete(long reviewerGroupId) {
        InternalReviewerGroup reviewerGroup = this.getById(reviewerGroupId);
        this.validateAdminPermission(reviewerGroup.getScope());
        this.eventPublisher.publish((Object)new ReviewerGroupDeletedEvent(this, (ReviewerGroup)reviewerGroup));
        this.reviewerGroupDao.deleteById((Object)reviewerGroupId);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    public Page<ReviewerGroup> findByScope(@Nonnull Scope scope, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(scope, "scope");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxReviewerGroups);
        this.validateReadPermission(scope);
        Page reviewerGroup = this.reviewerGroupDao.findInheritedByScopes(scope, pageRequest);
        return PageUtils.asPageOf(ReviewerGroup.class, (Page)reviewerGroup);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    public InternalReviewerGroup getById(long reviewerGroupId) {
        InternalReviewerGroup reviewerGroup = (InternalReviewerGroup)this.reviewerGroupDao.getById((Object)reviewerGroupId);
        if (reviewerGroup == null) {
            throw new NoSuchReviewerGroupException(this.i18nService.createKeyedMessage("bitbucket.service.reviewergroup.notfound", new Object[]{reviewerGroupId}), reviewerGroupId);
        }
        this.validateReadPermission(reviewerGroup.getScope());
        return reviewerGroup;
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    public Set<ReviewerGroup> getByIds(@Nonnull Set<Long> reviewerGroupIds, @Nonnull Scope scope) {
        Objects.requireNonNull(reviewerGroupIds, "reviewerGroupIds");
        Objects.requireNonNull(scope, "scope");
        this.validateReadPermission(scope);
        Set byIdsAndScope = this.reviewerGroupDao.getByIdsAndScope(reviewerGroupIds, scope);
        return new HashSet<ReviewerGroup>(byIdsAndScope);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    public Optional<ReviewerGroup> getByName(@Nonnull Scope scope, @Nonnull String reviewerGroupName) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(reviewerGroupName, "reviewerGroupName");
        this.validateReadPermission(scope);
        return Optional.ofNullable(this.reviewerGroupDao.getByName(scope, reviewerGroupName));
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    public Page<ReviewerGroup> findByName(@Nonnull Scope scope, @Nonnull String name, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(name, "name");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxReviewerGroups);
        this.validateReadPermission(scope);
        Page reviewerGroup = this.reviewerGroupDao.findByName(scope, name, pageRequest);
        return PageUtils.asPageOf(ReviewerGroup.class, (Page)reviewerGroup);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public InternalReviewerGroup update(@Nonnull ReviewerGroupUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        this.checkUserSizeLimit(request.getUsers());
        InternalReviewerGroup existing = this.getById(request.getId());
        InternalReviewerGroup copyOfExisting = new InternalReviewerGroup.Builder(existing).build();
        this.validateAdminPermission(existing.getScope());
        if (!request.getName().toLowerCase(Locale.ROOT).equals(existing.getName().toLowerCase(Locale.ROOT))) {
            this.checkForNameDuplicate(existing.getScope(), request.getName());
        }
        InternalReviewerGroup.Builder builder = request.getUsers().isEmpty() ? new InternalReviewerGroup.Builder(existing) : new InternalReviewerGroup.Builder(existing, request.getUsers());
        InternalReviewerGroup updatedReviewerGroup = builder.description(request.getDescription()).name(request.getName()).build();
        this.eventPublisher.publish((Object)new ReviewerGroupUpdatedEvent(this, (ReviewerGroup)updatedReviewerGroup, (ReviewerGroup)copyOfExisting));
        return (InternalReviewerGroup)this.reviewerGroupDao.update((Object)updatedReviewerGroup);
    }

    @VisibleForTesting
    void checkForNameDuplicate(@Nonnull Scope scope, @Nonnull String name) {
        InternalReviewerGroup existingReviewerGroup = this.reviewerGroupDao.getByName(scope, name);
        if (existingReviewerGroup != null) {
            throw new DuplicateReviewerGroupException(this.i18nService.createKeyedMessage("bitbucket.service.reviewergroup.duplicate", new Object[]{scope.getType().toString().toLowerCase(), name}));
        }
    }

    private void checkUserSizeLimit(Set<ApplicationUser> users) {
        if (users.size() > this.maxUsers) {
            throw new ReviewerGroupUserLimitException(this.i18nService.createKeyedMessage("bitbucket.service.reviewergroup.userlimit", new Object[]{this.maxUsers, users.size() - this.maxUsers}));
        }
    }

    private void validateAdminPermission(@Nonnull Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                throw new UnsupportedOperationException(DefaultReviewerGroupService.this.i18nService.getMessage("bitbucket.service.reviewergroup.invalidscope", new Object[]{scope.getType()}));
            }

            public Void visit(final @Nonnull ProjectScope scope) {
                return (Void)scope.getProject().accept((ProjectVisitor)new ProjectVisitor<Void>(){

                    public Void visit(@Nonnull Project project) {
                        DefaultReviewerGroupService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                        return null;
                    }

                    public Void visit(@Nonnull PersonalProject project) {
                        throw new UnsupportedOperationException(DefaultReviewerGroupService.this.i18nService.getMessage("bitbucket.service.reviewergroup.invalidscope", new Object[]{scope.getType()}));
                    }
                });
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultReviewerGroupService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateReadPermission(@Nonnull Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                throw new UnsupportedOperationException(DefaultReviewerGroupService.this.i18nService.getMessage("bitbucket.service.reviewergroup.invalidscope", new Object[]{scope.getType()}));
            }

            public Void visit(final @Nonnull ProjectScope scope) {
                return (Void)scope.getProject().accept((ProjectVisitor)new ProjectVisitor<Void>(){

                    public Void visit(@Nonnull Project project) {
                        DefaultReviewerGroupService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_READ);
                        return null;
                    }

                    public Void visit(@Nonnull PersonalProject project) {
                        throw new UnsupportedOperationException(DefaultReviewerGroupService.this.i18nService.getMessage("bitbucket.service.reviewergroup.invalidscope", new Object[]{scope.getType()}));
                    }
                });
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultReviewerGroupService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_READ);
                return null;
            }
        });
    }
}

