/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.template;

import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.pull.template.DmzPullRequestTemplateService;
import com.atlassian.bitbucket.dmz.pull.template.PullRequestTemplate;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.pull.template.InternalPullRequestTemplate;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateCreatedEvent;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateDao;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateDeletedEvent;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateUpdatedEvent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@AvailableToPlugins(interfaces={DmzPullRequestTemplateService.class})
@Service(value="pullRequestTemplateService")
@RequireFeature(value=StandardFeature.PULL_REQUEST_TEMPLATES)
public class DefaultPullRequestTemplateService
implements DmzPullRequestTemplateService {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestTemplateDao pullRequestTemplateDao;
    private final Validator validator;

    public DefaultPullRequestTemplateService(EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PullRequestTemplateDao pullRequestTemplateDao, Validator validator) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestTemplateDao = pullRequestTemplateDao;
        this.validator = validator;
    }

    @Secured(value="Permission check performed internally")
    @Transactional
    public boolean deleteTemplate(@Nonnull Scope scope) {
        this.validateAdminPermission(scope);
        this.eventPublisher.publish((Object)new PullRequestTemplateDeletedEvent(this, scope));
        return this.pullRequestTemplateDao.deleteByScope(scope);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    public Optional<PullRequestTemplate> getTemplate(@Nonnull Scope scope) {
        this.validateReadPermission(scope);
        return Optional.ofNullable((PullRequestTemplate)scope.accept((ScopeVisitor)new ScopeVisitor<InternalPullRequestTemplate>(){

            public InternalPullRequestTemplate visit(@Nonnull GlobalScope scope) {
                throw new ArgumentValidationException(DefaultPullRequestTemplateService.this.i18nService.createKeyedMessage("bitbucket.service.pullrequesttemplate.error.invalidscope", new Object[0]));
            }

            public InternalPullRequestTemplate visit(@Nonnull ProjectScope projectScope) {
                return DefaultPullRequestTemplateService.this.pullRequestTemplateDao.findByScope((Scope)projectScope).orElse(null);
            }

            public InternalPullRequestTemplate visit(@Nonnull RepositoryScope repositoryScope) {
                return DefaultPullRequestTemplateService.this.pullRequestTemplateDao.findByScope((Scope)repositoryScope).orElseGet(() -> this.visit(Scopes.project((Project)repositoryScope.getProject())));
            }
        }));
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public PullRequestTemplate setTemplate(@Nonnull Scope scope, @Nullable String description, boolean enabled) {
        this.validateAdminPermission(scope);
        Optional oldTemplate = this.pullRequestTemplateDao.findByScope(scope);
        InternalPullRequestTemplate template = new InternalPullRequestTemplate.Builder(scope).description(description).enabled(enabled).build();
        ValidationUtils.validate((Validator)this.validator, (Object)template, (Class[])new Class[0]);
        this.eventPublisher.publish((Object)oldTemplate.map(old -> new PullRequestTemplateUpdatedEvent(this, (PullRequestTemplate)old, (PullRequestTemplate)template)).orElseGet(() -> new PullRequestTemplateCreatedEvent((Object)this, (PullRequestTemplate)template)));
        return this.pullRequestTemplateDao.setTemplate(template);
    }

    private void validateAdminPermission(@Nonnull Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                throw new ArgumentValidationException(DefaultPullRequestTemplateService.this.i18nService.createKeyedMessage("bitbucket.service.pullrequesttemplate.error.invalidscope", new Object[0]));
            }

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultPullRequestTemplateService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultPullRequestTemplateService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateReadPermission(@Nonnull Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                throw new ArgumentValidationException(DefaultPullRequestTemplateService.this.i18nService.createKeyedMessage("bitbucket.service.pullrequesttemplate.error.invalidscope", new Object[0]));
            }

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultPullRequestTemplateService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_VIEW);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultPullRequestTemplateService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_READ);
                return null;
            }
        });
    }
}

