/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.template;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.pull.template.PullRequestTemplate;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateEvent;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.pullrequesttemplate.updated")
public class PullRequestTemplateUpdatedEvent
extends PullRequestTemplateEvent {
    private final boolean descriptionUpdated;
    private final boolean enabled;
    private final PullRequestTemplate newTemplate;
    private final PullRequestTemplate oldTemplate;

    public PullRequestTemplateUpdatedEvent(@Nonnull Object source, @Nonnull PullRequestTemplate oldTemplate, @Nonnull PullRequestTemplate newTemplate) {
        super(source, newTemplate.getScope());
        this.oldTemplate = oldTemplate;
        this.newTemplate = newTemplate;
        this.enabled = newTemplate.isEnabled();
        this.descriptionUpdated = !Objects.equals(oldTemplate.getDescription(), newTemplate.getDescription());
    }

    @Nonnull
    public PullRequestTemplate getNewTemplate() {
        return this.newTemplate;
    }

    @Nonnull
    public PullRequestTemplate getOldTemplate() {
        return this.oldTemplate;
    }

    public boolean isDescriptionUpdated() {
        return this.descriptionUpdated;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

