/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.internal.repository.DefaultBranchSource;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.repository.created")
public class AnalyticsRepositoryCreatedEvent
extends RepositoryCreatedEvent {
    private final DefaultBranchSource defaultBranchSource;
    private final Duration duration;

    public AnalyticsRepositoryCreatedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull DefaultBranchSource defaultBranchSource, @Nonnull Duration duration) {
        super(source, repository);
        this.defaultBranchSource = Objects.requireNonNull(defaultBranchSource, "defaultBranchSource");
        this.duration = Objects.requireNonNull(duration, "duration");
    }

    @Nonnull
    public DefaultBranchSource getDefaultBranchSource() {
        return this.defaultBranchSource;
    }

    public long getDuration() {
        return this.duration.toMillis();
    }
}

