/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.AbstractProjectVisitor;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.repository.deleted")
public class AnalyticsRepositoryDeletedEvent
extends RepositoryDeletedEvent {
    private final boolean orphan = !this.getRepository().isFork();
    private final PermissionService permissionService;

    public AnalyticsRepositoryDeletedEvent(@Nonnull Object source, @Nonnull Iterable<Integer> forkIds, @Nonnull PermissionService permissionService, @Nonnull Repository repository) {
        super(source, repository, forkIds);
        this.permissionService = permissionService;
    }

    public Boolean getDeletedUser() {
        return (Boolean)this.getRepository().getProject().accept((ProjectVisitor)new AbstractProjectVisitor<Boolean>(this){

            public Boolean visit(@Nonnull PersonalProject project) {
                return !project.getOwner().isActive();
            }
        });
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public Permission getPermission() {
        return this.permissionService.getHighestGlobalPermission(this.getUser());
    }
}

