/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.project.AbstractProjectVisitor;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.repository.updated")
public class AnalyticsRepositoryModifiedEvent
extends RepositoryModifiedEvent {
    private final boolean orphan = !this.getRepository().isFork();

    public AnalyticsRepositoryModifiedEvent(@Nonnull Object source, @Nonnull Repository oldValue, @Nonnull Repository newValue) {
        super(source, oldValue, newValue);
    }

    public Boolean getDeletedUser() {
        if (this.isMoved()) {
            return (Boolean)this.getOldValue().getProject().accept((ProjectVisitor)new AbstractProjectVisitor<Boolean>(this){

                public Boolean visit(@Nonnull PersonalProject project) {
                    return !project.getOwner().isActive();
                }
            });
        }
        return null;
    }

    public boolean isOrphan() {
        return this.orphan;
    }
}

