/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

class BoostingBranchCallback
implements BranchCallback {
    private final String filterText;
    private final int maxBoostedBranches;
    private final int maxSearchBranches;
    private final List<Branch> otherList;
    private final PageRequest pageRequest;
    private final List<Branch> prefixList;
    private Branch exact;
    private int searchedBranches;

    BoostingBranchCallback(@Nonnull String filterText, int maxBoostedBranches, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(filterText);
        Objects.requireNonNull(pageRequest);
        this.filterText = StringUtils.lowerCase((String)filterText);
        this.maxBoostedBranches = maxBoostedBranches;
        this.pageRequest = pageRequest;
        this.maxSearchBranches = Math.max(maxBoostedBranches, pageRequest.getStart() + pageRequest.getLimit());
        this.prefixList = new ArrayList<Branch>();
        this.otherList = new ArrayList<Branch>();
    }

    public boolean onBranch(@Nonnull Branch branch) {
        String displayId = branch.getDisplayId().toLowerCase();
        if (this.searchedBranches++ < this.maxBoostedBranches) {
            if (this.exact == null && displayId.equals(this.filterText)) {
                this.exact = branch;
            } else if (displayId.startsWith(this.filterText)) {
                this.prefixList.add(branch);
            } else {
                this.otherList.add(branch);
            }
        } else {
            this.otherList.add(branch);
        }
        return this.searchedBranches < this.maxSearchBranches;
    }

    @Nonnull
    Page<Branch> getPage() {
        ArrayList<Branch> ordered = new ArrayList<Branch>(this.prefixList.size() + this.otherList.size() + 1);
        if (this.exact != null) {
            ordered.add(this.exact);
        }
        ordered.addAll(this.prefixList);
        ordered.addAll(this.otherList);
        int start = this.pageRequest.getStart();
        int end = Math.min(this.pageRequest.getStart() + this.pageRequest.getLimit() + 1, ordered.size());
        if (start > end) {
            return PageUtils.createEmptyPage((PageRequest)this.pageRequest);
        }
        return PageUtils.createPage(ordered.subList(start, end), (PageRequest)this.pageRequest);
    }
}

