/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.event.branch.BranchCreatedEvent;
import com.atlassian.bitbucket.event.branch.BranchCreationHookRequest;
import com.atlassian.bitbucket.event.repository.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.bitbucket.event.tag.TagCreatedEvent;
import com.atlassian.bitbucket.event.tag.TagCreationHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.repository.CreateBranchRequest;
import com.atlassian.bitbucket.repository.CreateTagRequest;
import com.atlassian.bitbucket.repository.IllegalRepositoryStateException;
import com.atlassian.bitbucket.repository.MetadataMap;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.NoSuchTagException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataContext;
import com.atlassian.bitbucket.repository.RefMetadataRequest;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryBranchesRequest;
import com.atlassian.bitbucket.repository.RepositoryTagsRequest;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.ResolveRefsRequest;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.SimpleTag;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.repository.TagCallback;
import com.atlassian.bitbucket.scm.BranchesCommandParameters;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.ResolveRefCommandParameters;
import com.atlassian.bitbucket.scm.ResolveRefsCommandParameters;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.TagsCommandParameters;
import com.atlassian.bitbucket.scm.UpdateDefaultBranchCommandParameters;
import com.atlassian.bitbucket.scm.ref.CreateBranchCommandParameters;
import com.atlassian.bitbucket.scm.ref.CreateTagCommandParameters;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.repository.BoostingBranchCallback;
import com.atlassian.stash.internal.repository.RefMetadataMapProvider;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=RefService.class)
@Service(value="refService")
public class DefaultRefService
extends AbstractScmService
implements RefService {
    private static final String FQ_BRANCH_PATH = "refs/heads/";
    private static final String FQ_TAG_PATH = "refs/tags/";
    private static final String MAX_REF_METADATA_REQUEST_COUNT = "${ref.metadata.max.request.count}";
    private static final int MIN_BRANCHES_COUNT = 25;
    private static final int MIN_REF_METADATA_REQUEST_COUNT = 25;
    private static final int MIN_TAGS_COUNT = 25;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final RefMetadataMapProvider refMetadataMapProvider;
    private final RepositoryHookService repositoryHookService;
    private int maxBoostedBranches;
    private int maxBranches;
    private int maxRefMetadataRequestCount;
    private int maxTags;

    @Autowired
    public DefaultRefService(InternalScmService scmService, EventPublisher eventPublisher, I18nService i18nService, RefMetadataMapProvider refMetadataMapProvider, RepositoryHookService repositoryHookService) {
        super(scmService);
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.refMetadataMapProvider = refMetadataMapProvider;
        this.repositoryHookService = repositoryHookService;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request?.repository, 'REPO_WRITE')")
    public Branch createBranch(@Nonnull CreateBranchRequest request) {
        Branch branch;
        Objects.requireNonNull(request, "request");
        Repository repository = request.getRepository();
        if (this.scmService.isEmpty(repository)) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("bitbucket.service.branch.creationempty", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        BranchCreationHookRequest hookRequest = new BranchCreationHookRequest.Builder(repository, (Branch)((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().id(this.qualify(request.getName(), FQ_BRANCH_PATH))).displayId(request.getName())).latestCommit(request.getStartPoint())).build()).build();
        RepositoryHookResult result = this.repositoryHookService.preUpdate((RepositoryHookRequest)hookRequest);
        if (result.isRejected()) {
            throw new RepositoryHookVetoedException(this.i18nService.createKeyedMessage("bitbucket.service.branch.creationcanceled", new Object[0]), (RepositoryHookRequest)hookRequest, result.getVetoes());
        }
        CreateBranchCommandParameters.Builder builder = (CreateBranchCommandParameters.Builder)((CreateBranchCommandParameters.Builder)new CreateBranchCommandParameters.Builder().name(request.getName())).startPoint(request.getStartPoint());
        if (StringUtils.isNotBlank((CharSequence)request.getMessage())) {
            builder.message(request.getMessage());
        }
        if ((branch = (Branch)this.scmService.getRefCommandFactory(repository).createBranch(builder.build()).call()) == null) {
            throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.branch.creationerror", new Object[]{request.getName()}), request.getName());
        }
        this.eventPublisher.publish((Object)new BranchCreatedEvent((Object)this, repository, branch));
        return branch;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request?.repository, 'REPO_WRITE')")
    public Tag createTag(@Nonnull CreateTagRequest request) {
        Tag tag;
        Objects.requireNonNull(request, "request");
        Repository repository = request.getRepository();
        if (this.scmService.isEmpty(repository)) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("bitbucket.service.tag.creationempty", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        TagCreationHookRequest hookRequest = new TagCreationHookRequest.Builder(repository, (Tag)((SimpleTag.Builder)((SimpleTag.Builder)((SimpleTag.Builder)new SimpleTag.Builder().id(this.qualify(request.getName(), FQ_TAG_PATH))).displayId(request.getName())).latestCommit(request.getStartPoint())).build()).build();
        RepositoryHookResult result = this.repositoryHookService.preUpdate((RepositoryHookRequest)hookRequest);
        if (result.isRejected()) {
            throw new RepositoryHookVetoedException(this.i18nService.createKeyedMessage("bitbucket.service.tag.creationcanceled", new Object[0]), (RepositoryHookRequest)hookRequest, result.getVetoes());
        }
        CreateTagCommandParameters.Builder builder = (CreateTagCommandParameters.Builder)((CreateTagCommandParameters.Builder)new CreateTagCommandParameters.Builder().name(request.getName())).startPoint(request.getStartPoint());
        if (StringUtils.isNotBlank((CharSequence)request.getMessage())) {
            builder.message(request.getMessage());
        }
        if ((tag = (Tag)this.scmService.getRefCommandFactory(repository).createTag(builder.build()).call()) == null) {
            throw new NoSuchTagException(this.i18nService.createKeyedMessage("bitbucket.service.tag.creationerror", new Object[]{request.getName()}), request.getName());
        }
        this.eventPublisher.publish((Object)new TagCreatedEvent((Object)this, repository, tag));
        return tag;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Page<Branch> getBranches(@Nonnull RepositoryBranchesRequest request, @Nonnull PageRequest pageRequest) {
        Page<Branch> page;
        boolean shouldBoostMatches;
        Objects.requireNonNull(request, "request");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxBranches);
        boolean bl = shouldBoostMatches = request.isBoostMatches() && pageRequest.getStart() < this.maxBoostedBranches && request.getFilterText() != null;
        if (shouldBoostMatches) {
            BoostingBranchCallback callback = new BoostingBranchCallback(request.getFilterText(), this.maxBoostedBranches, pageRequest);
            this.getCommandFactory(request.getRepository()).branches(((BranchesCommandParameters.Builder)((BranchesCommandParameters.Builder)new BranchesCommandParameters.Builder().filterText(request.getFilterText())).order(request.getOrder())).build(), (BranchCallback)callback).call();
            page = callback.getPage();
        } else {
            page = (Page<Branch>)this.getCommandFactory(request.getRepository()).branches(((BranchesCommandParameters.Builder)((BranchesCommandParameters.Builder)new BranchesCommandParameters.Builder().filterText(request.getFilterText())).order(request.getOrder())).build(), pageRequest).call();
            if (page == null) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
        }
        return page;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    @Transactional(noRollbackFor={NoDefaultBranchException.class}, propagation=Propagation.SUPPORTS, readOnly=true)
    public Branch getDefaultBranch(@Nonnull Repository repository) {
        Branch defaultBranch = (Branch)this.getCommandFactory(repository).defaultBranch().call();
        if (defaultBranch == null) {
            throw new NoDefaultBranchException(this.i18nService.createKeyedMessage("bitbucket.service.repository.nodefaultbranch", new Object[0]), repository.getName(), null);
        }
        return defaultBranch;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Map<Ref, MetadataMap> getMetadataByRefs(@Nonnull RefMetadataRequest request) {
        Objects.requireNonNull(request, "request");
        Ref baseRef = request.getBaseRef();
        if (baseRef == null) {
            baseRef = this.getDefaultBranch(request.getRepository());
        }
        SimpleRefMetadataContext context = new SimpleRefMetadataContext(request.getRepository(), baseRef, Iterables.limit((Iterable)request.getRefs(), (int)this.maxRefMetadataRequestCount), request.getContext());
        return this.refMetadataMapProvider.getMetadata(context);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Page<Tag> getTags(@Nonnull RepositoryTagsRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxTags);
        Page page = (Page)this.getCommandFactory(request.getRepository()).tags(((TagsCommandParameters.Builder)((TagsCommandParameters.Builder)new TagsCommandParameters.Builder().filterText(request.getFilterText())).order(request.getOrder())).build(), pageRequest).call();
        if (page == null) {
            page = PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return page;
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Ref resolveRef(@Nonnull ResolveRefRequest request) {
        Optional refId = Objects.requireNonNull(request, "request").getRefId();
        if (refId.isPresent()) {
            return (Ref)this.getCommandFactory(request.getRepository()).resolveRef(new ResolveRefCommandParameters.Builder((String)refId.get()).type((RefType)request.getType().orElse(null)).build()).call();
        }
        return this.getDefaultBranch(request.getRepository());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Map<String, Ref> resolveRefs(@Nonnull ResolveRefsRequest request) {
        Map refsById = (Map)this.getCommandFactory(request.getRepository()).resolveRefs(new ResolveRefsCommandParameters.Builder(request).build()).call();
        return refsById == null ? Collections.emptyMap() : refsById;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void setDefaultBranch(@Nonnull Repository repository, @Nonnull String branchName) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(branchName, "branchName");
        if (!this.scmService.isSupported(repository, ScmFeature.UPDATE_DEFAULT_BRANCH)) {
            throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("bitbucket.service.repository.scm.noupdatedefaultbranchfeature", new Object[]{repository.getProject().getKey(), repository.getSlug(), this.scmService.getScmName(repository)}), repository.getScmId(), ScmFeature.UPDATE_DEFAULT_BRANCH);
        }
        String oldId = this.scmService.getDefaultBranch(repository).getId();
        if (branchName.equals(oldId)) {
            return;
        }
        this.scmService.getExtendedCommandFactory(repository).updateDefaultBranch(new UpdateDefaultBranchCommandParameters.Builder(branchName).build()).call();
        String newId = this.scmService.getDefaultBranch(repository).getId();
        if (!oldId.equals(newId)) {
            this.eventPublisher.publish((Object)new RepositoryDefaultBranchModifiedEvent((Object)this, repository, newId, oldId));
        }
    }

    @Value(value="${ref.search.boost.branches.max}")
    public void setMaxBoostedBranches(int maxBoostedBranches) {
        this.maxBoostedBranches = maxBoostedBranches;
    }

    @Value(value="${page.max.branches}")
    public void setMaxBranches(int maxBranches) {
        this.maxBranches = Math.max(maxBranches, 25);
    }

    @Value(value="${ref.metadata.max.request.count}")
    public void setMaxRefMetadataRequestCount(int maxRefMetadataRequestCount) {
        this.maxRefMetadataRequestCount = Math.max(maxRefMetadataRequestCount, 25);
    }

    @Value(value="${page.max.tags}")
    public void setMaxTags(int maxTags) {
        this.maxTags = Math.max(maxTags, 25);
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamBranches(@Nonnull RepositoryBranchesRequest request, @Nonnull BranchCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.getCommandFactory(request.getRepository()).branches(new BranchesCommandParameters.Builder(request).build(), callback).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamTags(@Nonnull RepositoryTagsRequest request, @Nonnull TagCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.getCommandFactory(request.getRepository()).tags(new TagsCommandParameters.Builder(request).build(), callback).call();
    }

    private String qualify(@Nonnull String ref, @Nonnull String path) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)Objects.requireNonNull(ref, "ref")), (Object)"No ref was provided to qualify");
        if (ref.indexOf(47) > 0) {
            int index = 0;
            do {
                if (!ref.startsWith(path.substring(index))) continue;
                return path.substring(0, index) + ref;
            } while ((index = path.indexOf(47, index) + 1) < path.length());
        }
        return path + ref;
    }

    private static class SimpleRefMetadataContext
    implements RefMetadataContext {
        private final Ref baseRef;
        private final Map<String, Object> context;
        private final Set<Ref> refs;
        private final Repository repository;

        private SimpleRefMetadataContext(Repository repository, Ref baseRef, Iterable<? extends Ref> refs, Map<String, Object> context) {
            this.repository = repository;
            this.baseRef = baseRef;
            this.refs = ImmutableSet.copyOf(refs);
            this.context = context;
        }

        @Nonnull
        public Ref getBaseRef() {
            return this.baseRef;
        }

        @Nonnull
        public Map<String, Object> getContext() {
            return this.context;
        }

        @Nonnull
        public Set<Ref> getRefs() {
            return this.refs;
        }

        @Nonnull
        public Repository getRepository() {
            return this.repository;
        }
    }
}

