/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.mesh.AssignPartitionRequest;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.policy.DmzPolicyService;
import com.atlassian.bitbucket.dmz.repository.DmzRepositoryService;
import com.atlassian.bitbucket.dmz.repository.RepositoryCallback;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivity;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivityBranchesRequest;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivitySearchRequest;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionGrantedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreationFailedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreationRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeleteBlockedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkFailedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryImportedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModificationRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.AbstractRepositoryRequest;
import com.atlassian.bitbucket.repository.ArchiveRepositoryFailedException;
import com.atlassian.bitbucket.repository.ForkingDisabledException;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.PersonalRepositoryDisabledException;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryAlreadyExistsException;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryCreationCanceledException;
import com.atlassian.bitbucket.repository.RepositoryDeletionCanceledException;
import com.atlassian.bitbucket.repository.RepositoryForkCanceledException;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryModificationCanceledException;
import com.atlassian.bitbucket.repository.RepositoryOperationException;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.repository.RepositoryUpdateRequest;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.bitbucket.scm.CommandException;
import com.atlassian.bitbucket.scm.CreateCommandParameters;
import com.atlassian.bitbucket.scm.DeleteCommandParameters;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.ForkCommandParameters;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.SimpleNamedLink;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.repository.AnalyticsRepositoryArchivedEvent;
import com.atlassian.stash.internal.repository.AnalyticsRepositoryCreatedEvent;
import com.atlassian.stash.internal.repository.AnalyticsRepositoryDeletedEvent;
import com.atlassian.stash.internal.repository.AnalyticsRepositoryForkedEvent;
import com.atlassian.stash.internal.repository.AnalyticsRepositoryModifiedEvent;
import com.atlassian.stash.internal.repository.AnalyticsRepositoryUnarchivedEvent;
import com.atlassian.stash.internal.repository.DefaultBranchSource;
import com.atlassian.stash.internal.repository.DefaultRepositorySupplier;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryAlias;
import com.atlassian.stash.internal.repository.InternalRepositoryCreatedActivity;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.repository.InternalRepositoryUpdatedActivity;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.repository.RepositoryAliasDao;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.internal.repository.RepositoryReadOnlyChangedEvent;
import com.atlassian.stash.internal.repository.RepositorySearchCriteria;
import com.atlassian.stash.internal.repository.RepositorySizeCache;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.atlassian.stash.internal.server.InternalDataStoreService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.retry.RetryFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={DmzRepositoryService.class, RepositoryService.class, RepositorySupplier.class})
@Service(value="repositoryService")
public class DefaultRepositoryService
extends DefaultRepositorySupplier
implements InternalRepositoryService {
    static final String CACHE_NAME = "com.atlassian.bitbucket.repository.RepositoryService#isEmpty";
    private static final int MAX_REPOSITORY_CREATE_ATTEMPTS = 5;
    private static final int MINIMUM_MAX_REPOSITORIES = 50;
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryService.class);
    private final InternalAuthenticationContext authenticationContext;
    private final InternalDataStoreService dataStoreService;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService executorService;
    private final FeatureManager featureManager;
    private final Cache<Integer, Boolean> isEmptyCache;
    private final DmzMeshService meshService;
    private final PermissionPredicateFactory predicateFactory;
    private final DmzPolicyService policyService;
    private final InternalProjectService projectService;
    private final ProjectSettingsRestrictionService projectSettingsRestriction;
    private final InternalApplicationPropertiesService propertiesService;
    private final PullRequestDao pullRequestDao;
    private final RefService refService;
    private final RepositoryActivityDao repositoryActivityDao;
    private final RepositoryPermissionDao repositoryPermissionDao;
    private final RepositorySizeCache repositorySizeCache;
    private final InternalScmService scmService;
    private final SecureTokenGenerator tokenGenerator;
    private final TransactionTemplate transactionTemplate;
    private final Validator validator;
    private int maxRepositoriesPerPage;
    private int maxRepositoryCreateAttempts;

    @Autowired
    public DefaultRepositoryService(RepositoryAliasDao aliasDao, InternalAuthenticationContext authenticationContext, CacheFactory cacheFactory, InternalDataStoreService dataStoreService, EventPublisher eventPublisher, ScheduledExecutorService executorService, FeatureManager featureManager, I18nService i18nService, DmzMeshService meshService, PermissionPredicateFactory predicateFactory, InternalPermissionService permissionService, DmzPolicyService policyService, InternalProjectService projectService, ProjectSettingsRestrictionService projectSettingsRestrictionService, InternalApplicationPropertiesService propertiesService, PullRequestDao pullRequestDao, RefService refService, RepositoryDao repositoryDao, RepositoryActivityDao repositoryActivityDao, RepositoryPermissionDao repositoryPermissionDao, RepositorySizeCache repositorySizeCache, InternalScmService scmService, SecureTokenGenerator tokenGenerator, PlatformTransactionManager transactionManager, Validator validator) {
        super(i18nService, aliasDao, permissionService, repositoryDao);
        this.authenticationContext = authenticationContext;
        this.dataStoreService = dataStoreService;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.featureManager = featureManager;
        this.meshService = meshService;
        this.predicateFactory = predicateFactory;
        this.policyService = policyService;
        this.projectService = projectService;
        this.projectSettingsRestriction = projectSettingsRestrictionService;
        this.propertiesService = propertiesService;
        this.pullRequestDao = pullRequestDao;
        this.refService = refService;
        this.repositoryActivityDao = repositoryActivityDao;
        this.repositoryPermissionDao = repositoryPermissionDao;
        this.repositorySizeCache = repositorySizeCache;
        this.scmService = scmService;
        this.tokenGenerator = tokenGenerator;
        this.validator = validator;
        this.isEmptyCache = cacheFactory.getCache(CACHE_NAME, null, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build());
        this.maxRepositoriesPerPage = 50;
        this.maxRepositoryCreateAttempts = 5;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Secured(value="by the delegated method")
    @Transactional(readOnly=true)
    public int countByProject(@Nonnull Project project) {
        return this.permissionService.getCountOfAccessibleRepositories(project);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'REPO_CREATE')")
    @Throttled(value="scm-command")
    @Transactional(propagation=Propagation.SUPPORTS)
    public InternalRepository create(@Nonnull RepositoryCreateRequest request) {
        Objects.requireNonNull(request, "request");
        Project project = request.getProject();
        this.checkCanCreateRepository(request.getProject());
        String defaultBranch = request.getDefaultBranch();
        if (defaultBranch == null) {
            defaultBranch = this.propertiesService.getDefaultBranch();
        }
        return this.createRepositoryWithRetry((AbstractRepositoryRequest)request, project, request.getScmId(), null, null, defaultBranch, Repository.State.AVAILABLE, true);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public void delete(@Nonnull Repository repository) {
        this.checkCanDeleteRepository(repository);
        InternalRepository internal = InternalConverter.convertToInternalRepository((Repository)repository);
        Iterable forkIds = (Iterable)this.transactionTemplate.execute(transactionStatus -> {
            Iterable forks = this.repositoryDao.getForkIds(internal);
            this.fireRepositoryDeletionRequested((Repository)internal, forks);
            this.deleteInDatabase(internal, forks);
            return forks;
        });
        this.executorService.submit(() -> {
            DeleteCommandParameters.Builder builder = new DeleteCommandParameters.Builder();
            if (forkIds == null || Iterables.isEmpty((Iterable)forkIds)) {
                this.transactionTemplate.execute(status -> {
                    status.setRollbackOnly();
                    if (this.repositoryDao.countByHierarchy(internal.getHierarchyId()) == 0L) {
                        builder.lastInHierarchy();
                    }
                    if (internal.getOrigin() != null && Iterables.isEmpty((Iterable)this.repositoryDao.getForkIds(internal.getOrigin()))) {
                        builder.lastForkOfOrigin();
                    }
                    return null;
                });
            } else {
                builder.forkIds(forkIds);
            }
            this.scmService.delete((Repository)internal, builder.build());
        });
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRED)
    @Unsecured(value="This is an internal method")
    public Repository finalizeImport(@Nonnull Repository repository) {
        Repository.State state = repository.getState();
        if (state != Repository.State.INITIALISING) {
            log.debug("{}: Skipped finalizing import; the repository is not in the expected state", (Object)repository);
            return repository;
        }
        Repository importedRepository = this.setState(repository, Repository.State.AVAILABLE);
        this.eventPublisher.publish((Object)new RepositoryImportedEvent((Object)this, importedRepository));
        return importedRepository;
    }

    @Nonnull
    @Unsecured(value="This is an internal method")
    public Page<Repository> findByHierarchyId(@Nonnull String hierarchyId, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByHierarchyId(hierarchyId, pageRequest));
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findAll(@Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findAll(pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request?.repository, 'REPO_ADMIN')")
    public Page<MinimalRef> findBranchesWithRefChangeActivities(@Nonnull RepositoryRefChangeActivityBranchesRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return this.repositoryActivityDao.findBranchesWithRefChangeActivities(request, pageRequest);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Map<Integer, Repository> findByIds(@Nonnull Set<Integer> repositoryIds) {
        return this.repositoryDao.getByIds((Collection)Objects.requireNonNull(repositoryIds, "repositoryIds")).stream().filter(this.predicateFactory.createRepositoryAccessiblePredicate()).collect(Collectors.toUnmodifiableMap(Repository::getId, Function.identity()));
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#origin)")
    public Page<Repository> findByOrigin(@Nonnull Repository origin, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(origin, "origin");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByOrigin(InternalConverter.convertToInternalRepository((Repository)origin), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findByOwner(@Nonnull ApplicationUser owner, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(owner, "owner");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByOwner(owner.getId(), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findByProjectId(int projectId, @Nonnull PageRequest pageRequest) throws NoSuchProjectException {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (this.projectService.getById(projectId) == null) {
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.service.project.nosuchid", new Object[]{projectId}));
        }
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByProjectId(projectId, pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findByProjectKey(@Nonnull String projectKey, @Nonnull PageRequest pageRequest) throws NoSuchProjectException {
        Objects.requireNonNull(projectKey, "projectKey");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (this.projectService.getByKey(projectKey) == null) {
            if (InternalPersonalProject.isPersonalProjectKey((String)projectKey)) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.service.project.notfound", new Object[]{projectKey}));
        }
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByProjectKey(projectKey, pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @PreAuthorize(value="isAuthenticated() and isRepositoryAccessible(#repository)")
    public InternalRepository findPersonalFork(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        PersonalProject personalProject = this.projectService.getPersonalProject(false);
        if (personalProject == null) {
            return null;
        }
        return this.repositoryDao.findByOriginInProject(InternalConverter.convertToInternalRepository((Repository)repository), personalProject.getId());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Page<Repository> findRelated(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByHierarchy(InternalConverter.convertToInternalRepository((Repository)repository), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'REPO_CREATE') and hasRepositoryPermission(#request.parent, 'REPO_READ')")
    @Throttled(value="scm-command")
    @Transactional(propagation=Propagation.SUPPORTS)
    public InternalRepository fork(@Nonnull RepositoryForkRequest request) {
        Repository parent = Objects.requireNonNull(request, "request").getParent();
        if (!this.isForkingEnabled()) {
            throw new ForkingDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.forkingdisabled", new Object[0]), parent);
        }
        if (!this.scmService.isSupported(parent, ScmFeature.FORK)) {
            throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("bitbucket.service.repository.scm.noforkfeature", new Object[]{parent.getProject().getKey(), parent.getSlug(), this.scmService.getScmName(parent)}), parent.getScmId(), ScmFeature.FORK);
        }
        this.checkCanForkRepository(parent, request.getProject());
        return this.internalFork(request, Repository.State.AVAILABLE, true);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    @Transactional(propagation=Propagation.SUPPORTS)
    public Set<NamedLink> getCloneLinks(@Nonnull RepositoryCloneLinksRequest request) {
        Objects.requireNonNull(request, "request");
        Repository repository = request.getRepository();
        ApplicationUser user = request.isUseCurrentUser() ? this.authenticationContext.getCurrentUser() : request.getUser();
        return this.scmService.getProtocols(repository).stream().filter(protocol -> request.getProtocolName() == null || request.getProtocolName().equalsIgnoreCase(protocol.getName())).map(protocol -> {
            String cloneUrl = protocol.getCloneUrl(repository, user);
            return cloneUrl == null ? null : new SimpleNamedLink(cloneUrl, protocol.getName());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Unsecured(value="Internal service method, this method is also exposed via JMX")
    public long getCount() {
        return this.repositoryDao.countAll();
    }

    @PreAuthorize(value="isAuthenticated()")
    public String getDefaultBranch() {
        return this.propertiesService.getDefaultBranch();
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public MinimalRef getDefaultBranch(@Nonnull Repository repository) {
        return this.scmService.getDefaultBranch(repository);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long getSize(@Nonnull Repository repository) {
        return this.getSize(repository, false);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long getSize(@Nonnull Repository repository, boolean forceCalculation) {
        Objects.requireNonNull(repository, "repository");
        if (forceCalculation) {
            return this.repositorySizeCache.refresh(repository);
        }
        return this.repositorySizeCache.getOrRefresh(repository);
    }

    @Nonnull
    @Throttled(value="scm-command")
    @Transactional(propagation=Propagation.SUPPORTS)
    @Unsecured(value="This is an internal method")
    public InternalRepository importFork(@Nonnull RepositoryForkRequest request) {
        Objects.requireNonNull(request, "request");
        return this.internalFork(request, Repository.State.INITIALISING, false);
    }

    @Nonnull
    @Throttled(value="scm-command")
    @Transactional(propagation=Propagation.SUPPORTS)
    @Unsecured(value="This is an internal method")
    public InternalRepository importRepository(@Nonnull RepositoryCreateRequest request, @Nonnull String hierarchyId) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        return this.createRepositoryWithRetry((AbstractRepositoryRequest)request, request.getProject(), request.getScmId(), hierarchyId, null, null, Repository.State.INITIALISING, false);
    }

    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isEmpty(@Nonnull Repository repository) {
        Boolean isEmpty = (Boolean)this.isEmptyCache.get((Object)Objects.requireNonNull(repository, "repository").getId());
        if (isEmpty != null) {
            return isEmpty;
        }
        if (this.scmService.isEmpty(repository)) {
            return true;
        }
        this.isEmptyCache.putIfAbsent((Object)repository.getId(), (Object)false);
        return false;
    }

    @Unsecured(value="Allow anonymous users to check whether forking is enabled")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isForkingEnabled() {
        return this.featureManager.isEnabled((Feature)StandardFeature.FORKS);
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.isEmptyCache.removeAll();
        }
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.isEmptyCache.remove((Object)event.getRepository().getId());
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        if (event.getRefChanges().stream().allMatch(refChange -> refChange.getType().equals((Object)RefChangeType.DELETE))) {
            this.isEmptyCache.remove((Object)event.getRepository().getId());
        }
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#repository.project, 'REPO_CREATE')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository retryCreate(@Nonnull Repository repository) {
        Project project = Objects.requireNonNull(repository, "repository").getProject();
        this.checkCanCreateRepository(project);
        String projectName = Objects.requireNonNull(project, "project").getName();
        String name = repository.getName();
        InternalRepository existing = this.repositoryDao.getBySlug(project.getKey(), repository.getSlug());
        if (existing == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.nosuchreponame", new Object[]{name, projectName});
            throw new NoSuchEntityException(message);
        }
        if (existing.getState() == Repository.State.INITIALISATION_FAILED) {
            this.repositoryDao.delete((Object)existing);
            String defaultBranch = this.propertiesService.getDefaultBranch();
            InternalRepository newRepository = this.createRepositoryInDatabase((AbstractRepositoryRequest)new RepositoryCreateRequest.Builder((Repository)existing).build(), project, existing.getScmId(), null, existing.getOrigin(), defaultBranch, false);
            this.createRepositoryInScm(newRepository, defaultBranch, Repository.State.AVAILABLE);
            existing = newRepository;
        }
        return existing;
    }

    @Nonnull
    @Unsecured(value="Permission checks are applied while searching for repositories matching the provided criteria")
    public Page<Repository> search(@Nonnull RepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (this.authenticationContext.getCurrentToken() == null && (request.hasPermission() || request.getVisibility() == RepositoryVisibility.PRIVATE)) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        RepositorySearchCriteria criteria = this.createSearchCriteria(request);
        if (criteria == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        if (request.hasProjectKey() && this.projectService.getByKey(request.getProjectKey()) == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Predicate permissionPredicate = request.hasPermission() ? this.predicateFactory.createRepositoryPermissionPredicate(request.getPermission()) : (criteria.getVisibility() == RepositoryVisibility.PUBLIC ? p -> true : this.predicateFactory.createRepositoryAccessiblePredicate());
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.search(criteria, pageRequest, permissionPredicate));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request?.repository, 'REPO_ADMIN')")
    public Page<RepositoryRefChangeActivity> searchRefChangeActivities(@Nonnull RepositoryRefChangeActivitySearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return this.repositoryActivityDao.findRefChangeActivities(request, pageRequest);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setDefaultBranch(@Nullable String defaultBranch) {
        this.propertiesService.setDefaultBranch(defaultBranch);
    }

    @Value(value="${page.max.repositories}")
    public void setMaxRepositoriesPerPage(int maxRepositoriesPerPage) {
        this.maxRepositoriesPerPage = Math.max(maxRepositoriesPerPage, 50);
    }

    @Value(value="${repository.create.max.attempts}")
    public void setMaxRepositoryCreateAttempts(int maxRepositoryCreateAttempts) {
        if (maxRepositoryCreateAttempts > 0 && maxRepositoryCreateAttempts <= 1000) {
            this.maxRepositoryCreateAttempts = maxRepositoryCreateAttempts;
        } else {
            this.maxRepositoryCreateAttempts = 5;
            log.warn("Configuration property 'repository.create.max.attempts' is invalid, expected an integer value greater than 0 and less or equal to 1000, but got {}. Using default value of {}", (Object)maxRepositoryCreateAttempts, (Object)5);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public Repository setReadOnly(@Nonnull Repository repository, boolean readOnly) {
        Objects.requireNonNull(repository, "repository");
        InternalRepository updated = (InternalRepository)this.repositoryDao.getById((Object)repository.getId());
        if (updated == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.nosuchrepo", new Object[]{repository.getId()});
            throw new NoSuchRepositoryException(message, repository.getProject());
        }
        if (updated.isReadOnly() != readOnly) {
            if (!readOnly && updated.isArchived()) {
                throw new RepositoryArchivedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.archive.readonlyrequired", new Object[]{updated.getProject().getKey(), updated.getSlug()}));
            }
            updated = (InternalRepository)this.repositoryDao.update((Object)updated.copy().readOnly(readOnly).build());
            this.eventPublisher.publish((Object)new RepositoryReadOnlyChangedEvent((Object)this, (Repository)updated, readOnly));
        }
        return updated;
    }

    @Unsecured(value="This is an internal method")
    public void streamReadOnly(@Nonnull RepositoryCallback callback) {
        Objects.requireNonNull(callback, "callback");
        this.repositoryDao.streamReadOnly(callback);
    }

    @Unsecured(value="This is an internal method")
    public void streamReadOnlyByHierarchy(@Nonnull String hierarchyId, @Nonnull RepositoryCallback callback) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        this.repositoryDao.streamReadOnlyByHierarchy(hierarchyId, callback);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.id, 'REPO_ADMIN') and (#request.project == null or hasProjectPermission(#request.project, 'REPO_CREATE'))")
    @Transactional
    public InternalRepository update(@Nonnull RepositoryUpdateRequest request) {
        ApplicationUser user;
        String defaultBranch;
        InternalProject project;
        Objects.requireNonNull(request, "request");
        InternalRepository repository = (InternalRepository)this.repositoryDao.getById((Object)request.getId());
        if (repository == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.repository.nosuchrepo", new Object[]{request.getId()}));
        }
        InternalRepository current = repository.copy().build();
        boolean archived = (Boolean)MoreObjects.firstNonNull((Object)request.getArchived(), (Object)repository.isArchived());
        boolean readOnly = repository.isReadOnly();
        if (archived != repository.isArchived()) {
            this.checkArchiveRepositoryPermission((Repository)repository);
            if (archived) {
                this.checkNoOpenPullRequest((Repository)repository);
                this.eventPublisher.publish((Object)new AnalyticsRepositoryArchivedEvent(this, (PermissionService)this.permissionService));
            } else {
                this.eventPublisher.publish((Object)new AnalyticsRepositoryUnarchivedEvent(this, (PermissionService)this.permissionService));
            }
            if (archived != readOnly) {
                readOnly = archived;
                this.eventPublisher.publish((Object)new RepositoryReadOnlyChangedEvent((Object)this, (Repository)current, readOnly));
            }
        } else if (repository.isArchived()) {
            throw new RepositoryArchivedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.updatearchived", new Object[0]));
        }
        if (!this.permissionService.hasProjectPermission((Project)(project = (InternalProject)MoreObjects.firstNonNull((Object)InternalConverter.convertToInternalProject((Project)request.getProject()), (Object)repository.getProject())), Permission.PROJECT_ADMIN) && this.projectSettingsRestriction.hasRestriction((Project)project, ProjectSettingsRestrictionKeys.REPOSITORY_PERMISSIONS) && current.isPublic() != request.isPublic()) {
            throw new ForbiddenException(this.i18nService.createKeyedMessage("bitbucket.service.repository.restrictionexists.public", new Object[]{repository.getName(), repository.getProject().getName()}));
        }
        InternalRepository updated = current.copy().archived(archived).description(request.getDescription()).forkable(request.isForkable()).name(request.getName()).project(project).publiclyAccessible(request.isPublic()).readOnly(readOnly).build();
        ValidationUtils.validate((Validator)this.validator, (Object)updated, (Class[])new Class[]{Update.class});
        this.fireRepositoryModificationRequested((Repository)current, (Repository)updated);
        updated = (InternalRepository)this.repositoryDao.update((Object)updated);
        if (!Objects.equals(updated.getSlug(), current.getSlug()) || !Objects.equals(updated.getProject(), current.getProject())) {
            this.aliasDao.deleteBySlug(project.getKey(), updated.getSlug());
            this.aliasDao.create((Object)new InternalRepositoryAlias.Builder(current).build());
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultBranch = request.getDefaultBranch()))) {
            this.refService.setDefaultBranch((Repository)updated, defaultBranch);
        }
        if ((user = this.authenticationContext.getCurrentUser()) != null) {
            this.repositoryActivityDao.create((Object)((InternalRepositoryUpdatedActivity.Builder)((InternalRepositoryUpdatedActivity.Builder)new InternalRepositoryUpdatedActivity.Builder(updated).createdDate(new Date())).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
        }
        this.eventPublisher.publish((Object)new AnalyticsRepositoryModifiedEvent(this, (Repository)current, (Repository)updated));
        return updated;
    }

    @Transactional
    @Unsecured(value="This is an internal method")
    public void updatePartitionForHierarchy(@Nonnull String hierarchyId, int partition) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        this.repositoryDao.updatePartitionForHierarchy(hierarchyId, partition);
    }

    private InternalRepository.Builder assignStorageLocation(InternalRepository.Builder builder, InternalRepository parent, String providedHierarchyId, String scmId) {
        Page page;
        InternalRepository existing = parent;
        if (existing == null && providedHierarchyId != null && (page = this.repositoryDao.findByHierarchyId(providedHierarchyId, PageUtils.newRequest((int)0, (int)1))).getSize() > 0) {
            existing = (InternalRepository)page.getValues().iterator().next();
        }
        if (existing != null) {
            return builder.dataStore((InternalDataStore)existing.getDataStore().orElse(null)).hierarchyId(existing.getHierarchyId()).partition(existing.getPartition());
        }
        String hierarchyId = providedHierarchyId == null ? this.generateToken() : providedHierarchyId;
        int partition = this.meshService.assignPartitionForHierarchy(new AssignPartitionRequest.Builder(scmId, hierarchyId).build());
        if (partition >= 0) {
            return builder.hierarchyId(hierarchyId).partition(partition);
        }
        return builder.dataStore((InternalDataStore)this.dataStoreService.assignForHierarchy(hierarchyId).orElse(null)).hierarchyId(hierarchyId);
    }

    private void checkArchiveRepositoryPermission(Repository repository) {
        boolean hasPermission;
        Permission repoArchivePermission = this.policyService.getRepositoryArchivePolicy();
        switch (repoArchivePermission) {
            case PROJECT_ADMIN: {
                hasPermission = this.permissionService.hasProjectPermission(repository.getProject().getId(), repoArchivePermission);
                break;
            }
            case ADMIN: 
            case SYS_ADMIN: {
                hasPermission = this.permissionService.hasGlobalPermission(repoArchivePermission);
                break;
            }
            default: {
                return;
            }
        }
        if (!hasPermission) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.archive.accessdenied", new Object[]{repoArchivePermission.name()}));
        }
    }

    private void checkCanCreateRepository(Project project) {
        if (project.getType() == ProjectType.PERSONAL && !this.featureManager.isEnabled((Feature)StandardFeature.PERSONAL_REPOS)) {
            throw new PersonalRepositoryDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.create.personalrepositorydisabled", new Object[0]));
        }
    }

    private void checkCanDeleteRepository(Repository repository) {
        boolean hasPermission;
        if (!this.featureManager.isEnabled((Feature)StandardFeature.REPOSITORY_DELETE_POLICY)) {
            return;
        }
        Permission repoDeletePermission = this.policyService.getRepositoryDeletePolicy();
        switch (repoDeletePermission) {
            case PROJECT_ADMIN: {
                hasPermission = this.permissionService.hasProjectPermission(repository.getProject().getId(), repoDeletePermission);
                break;
            }
            case ADMIN: 
            case SYS_ADMIN: {
                hasPermission = this.permissionService.hasGlobalPermission(repoDeletePermission);
                break;
            }
            default: {
                return;
            }
        }
        if (!hasPermission) {
            this.eventPublisher.publish((Object)new RepositoryDeleteBlockedEvent((Object)this, repository, this.permissionService.getHighestGlobalPermission(this.authenticationContext.getCurrentUser()), repository.getProject().getType() == ProjectType.PERSONAL, repository.isPublic()));
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.delete.accessdenied", new Object[]{repoDeletePermission.name()}));
        }
    }

    private void checkCanForkRepository(Repository parent, Project project) {
        if (!parent.isForkable()) {
            throw new ForkingDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.notforkable", new Object[]{parent.getProject().getKey(), parent.getSlug()}), parent);
        }
        if (!(project != null && project.getType() != ProjectType.PERSONAL || this.featureManager.isEnabled((Feature)StandardFeature.PERSONAL_REPOS))) {
            throw new PersonalRepositoryDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.fork.personalrepositorydisabled", new Object[0]));
        }
    }

    private void checkNoOpenPullRequest(Repository repository) {
        Long openPullRequests = (Long)this.pullRequestDao.countByState(repository.getId()).get(PullRequestState.OPEN);
        if (openPullRequests > 0L) {
            throw new ArchiveRepositoryFailedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.archive.pullrequest", new Object[]{repository.getProject().getKey(), repository.getSlug(), openPullRequests}));
        }
    }

    private DefaultBranchSource chooseDefaultBranchSource(String defaultBranch) {
        if (defaultBranch == null) {
            return DefaultBranchSource.SCM;
        }
        if (defaultBranch.equals(this.propertiesService.getDefaultBranch())) {
            return DefaultBranchSource.GLOBAL;
        }
        return DefaultBranchSource.USER;
    }

    private InternalRepository createRepositoryInDatabase(AbstractRepositoryRequest request, Project project, String scmId, String providedHierarchyId, InternalRepository parent, String defaultBranch, boolean cancelable) {
        InternalRepository.Builder builder = new InternalRepository.Builder().description(request.getDescription()).forkable(request.isForkable()).name(request.getName()).origin(parent).project(InternalConverter.convertToInternalProject((Project)project)).publiclyAccessible(request.isPublic()).scmId(scmId);
        InternalRepository repository = this.assignStorageLocation(builder, parent, providedHierarchyId, scmId).build();
        ValidationUtils.validate((Validator)this.validator, (Object)repository, (Class[])new Class[]{Create.class});
        if (cancelable) {
            if (repository.isFork()) {
                this.fireRepositoryForkRequested((Repository)repository, defaultBranch);
            } else {
                this.fireRepositoryCreationRequested((Repository)repository, defaultBranch);
            }
        }
        this.aliasDao.deleteBySlug(project.getKey(), repository.getSlug());
        InternalRepository createdRepository = (InternalRepository)this.repositoryDao.create((Object)repository);
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            this.repositoryActivityDao.create((Object)((InternalRepositoryCreatedActivity.Builder)((InternalRepositoryCreatedActivity.Builder)new InternalRepositoryCreatedActivity.Builder(createdRepository).createdDate(new Date())).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
            if (!this.permissionService.hasRepositoryPermission((Repository)createdRepository, Permission.REPO_ADMIN)) {
                this.grantRepoAdmin(createdRepository, user);
            }
        }
        return createdRepository;
    }

    private InternalRepository createRepositoryInScm(InternalRepository repository, String defaultBranch, Repository.State targetState) {
        Repository.State state = Repository.State.INITIALISATION_FAILED;
        Duration duration = null;
        try {
            Instant startTime = Instant.now();
            InternalRepository origin = repository.getOrigin();
            if (origin == null) {
                this.scmService.create((Repository)repository, new CreateCommandParameters.Builder().defaultBranch(defaultBranch).build());
            } else {
                this.scmService.fork((Repository)origin, new ForkCommandParameters.Builder((Repository)repository).defaultBranch(defaultBranch).build());
            }
            duration = Duration.between(startTime, Instant.now());
            state = targetState;
        }
        catch (ServiceException e) {
            try {
                throw this.stripLocation(e, repository.getName());
            }
            catch (Throwable throwable) {
                repository = InternalConverter.convertToInternalRepository((Repository)this.setState((Repository)repository, state));
                if (state == Repository.State.AVAILABLE) {
                    Object event = repository.isFork() ? new AnalyticsRepositoryForkedEvent(this, (Repository)repository, duration) : new AnalyticsRepositoryCreatedEvent(this, (Repository)repository, this.chooseDefaultBranchSource(defaultBranch), duration);
                    this.eventPublisher.publish(event);
                } else if (state != targetState) {
                    this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
                }
                throw throwable;
            }
        }
        repository = InternalConverter.convertToInternalRepository((Repository)this.setState((Repository)repository, state));
        if (state == Repository.State.AVAILABLE) {
            Object event = repository.isFork() ? new AnalyticsRepositoryForkedEvent(this, (Repository)repository, duration) : new AnalyticsRepositoryCreatedEvent(this, (Repository)repository, this.chooseDefaultBranchSource(defaultBranch), duration);
            this.eventPublisher.publish(event);
        } else if (state != targetState) {
            this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
        }
        return repository;
    }

    private InternalRepository createRepositoryWithRetry(AbstractRepositoryRequest request, Project project, String scmId, String hierarchyId, InternalRepository parent, String defaultBranch, Repository.State targetState, boolean cancelable) {
        return (InternalRepository)RetryFactory.create(() -> (InternalRepository)this.transactionTemplate.execute(state -> this.createRepositoryInScm(this.createRepositoryInDatabase(request, project, scmId, hierarchyId, parent, defaultBranch, cancelable), defaultBranch, targetState)), (int)this.maxRepositoryCreateAttempts, e -> {
            if (!(e instanceof RepositoryAlreadyExistsException)) {
                log.debug("Could not create repository {}/{}", new Object[]{project.getKey(), InternalRepository.slugify((String)request.getName()), e});
                throw e;
            }
            log.error("The directory for repository {}/{} already exists on the filesystem at [{}]. Administrator intervention is required to recover the data contained within or to remove the folder to recover disk space.", new Object[]{project.getKey(), InternalRepository.slugify((String)request.getName()), ((RepositoryAlreadyExistsException)e).getRepositoryDir()});
        }).get();
    }

    private RepositorySearchCriteria createSearchCriteria(RepositorySearchRequest request) {
        RepositoryVisibility visibility = this.authenticationContext.getCurrentToken() == null ? RepositoryVisibility.PUBLIC : request.getVisibility();
        RepositorySearchCriteria.Builder criteria = new RepositorySearchCriteria.Builder().archived(request.getArchived()).name(request.getName()).projectName(request.getProjectName()).projectKey(request.getProjectKey()).state(request.getState());
        if (visibility != null) {
            if (this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS)) {
                criteria.visibility(visibility);
            } else {
                if (visibility == RepositoryVisibility.PUBLIC) {
                    return null;
                }
                if (visibility == RepositoryVisibility.PRIVATE) {
                    criteria.visibility(null);
                }
            }
            criteria.order(RepositoryOrder.PROJECT_NAME);
        } else {
            criteria.order(RepositoryOrder.REPO_NAME);
        }
        return criteria.build();
    }

    private void deleteInDatabase(InternalRepository repository, Iterable<Integer> forkIds) {
        if (!Iterables.isEmpty(forkIds)) {
            this.repositoryDao.updateOrigin(repository, repository.getOrigin());
        }
        this.repositoryDao.deleteById((Object)repository.getId());
        this.fireRepositoryDeleted(repository, forkIds);
    }

    private void fireRepositoryCreationRequested(Repository repository, String defaultBranch) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryCreationRequestedEvent((Object)this, repository, defaultBranch, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.creationcanceled", new Object[0]);
            throw new RepositoryCreationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryDeleted(InternalRepository repository, Iterable<Integer> forkIds) {
        this.eventPublisher.publish((Object)new AnalyticsRepositoryDeletedEvent(this, forkIds, (PermissionService)this.permissionService, (Repository)repository));
    }

    private void fireRepositoryDeletionRequested(Repository repository, Iterable<Integer> forkIds) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryDeletionRequestedEvent((Object)this, repository, (CancelState)cancelState, forkIds));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.deletioncanceled", new Object[0]);
            throw new RepositoryDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryForkRequested(Repository repository, String defaultBranch) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryForkRequestedEvent((Object)this, repository, defaultBranch, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.forkcanceled", new Object[0]);
            throw new RepositoryForkCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryModificationRequested(Repository current, Repository updated) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryModificationRequestedEvent((Object)this, current, updated, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.updatecanceled", new Object[0]);
            throw new RepositoryModificationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    @Nonnull
    private String generateToken() {
        String token = this.tokenGenerator.generateToken();
        if (token.length() > 20) {
            token = token.substring(0, 20);
        }
        return token;
    }

    private void grantRepoAdmin(InternalRepository repository, ApplicationUser user) {
        InternalRepositoryPermission permission = ((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(Permission.REPO_ADMIN)).repository(repository).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build();
        this.repositoryPermissionDao.create((Object)permission);
        this.eventPublisher.publish((Object)new RepositoryPermissionGrantedEvent((Object)this, Permission.REPO_ADMIN, (Repository)repository, null, user));
        log.debug("{} : Granted REPO_ADMIN to {}", (Object)repository, (Object)user.getName());
    }

    private InternalRepository internalFork(RepositoryForkRequest request, Repository.State targetState, boolean cancelable) {
        Objects.requireNonNull(targetState, "targetState");
        Preconditions.checkArgument((targetState != Repository.State.INITIALISATION_FAILED ? 1 : 0) != 0, (String)"targetState %s is not valid", (Object)targetState);
        Repository parent = request.getParent();
        Project project = request.getProject();
        if (project == null) {
            project = this.projectService.getPersonalProject();
        }
        return this.createRepositoryWithRetry((AbstractRepositoryRequest)request, project, parent.getScmId(), null, InternalConverter.convertToInternalRepository((Repository)parent), request.getDefaultBranch(), targetState, cancelable);
    }

    @Nonnull
    private Repository setState(Repository repository, Repository.State state) {
        InternalRepository refreshed = (InternalRepository)this.repositoryDao.getById((Object)repository.getId());
        if (refreshed == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.nosuchrepo", new Object[]{repository.getId()});
            throw new NoSuchEntityException(message);
        }
        return (Repository)this.repositoryDao.update((Object)refreshed.copy().state(state).build());
    }

    private ServiceException stripLocation(ServiceException exceptionToStrip, String repositoryName) {
        Throwable rootCause = Throwables.getRootCause((Throwable)exceptionToStrip);
        if (rootCause instanceof CommandException || rootCause instanceof RepositoryOperationException) {
            return new ServerException(this.i18nService.createKeyedMessage("bitbucket.web.repository.create.processerror", new Object[]{repositoryName, rootCause.getClass().getSimpleName()}));
        }
        return exceptionToStrip;
    }
}

