/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.dmz.repository.DmzRepositorySizesCalculatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryPushEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.RepositorySize;
import com.atlassian.bitbucket.scm.RepositorySizeCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepositorySize;
import com.atlassian.stash.internal.repository.RepositorySizeCache;
import com.atlassian.stash.internal.repository.RepositorySizeDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="repositorySizeCache")
public class DefaultRepositorySizeCache
implements RepositorySizeCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositorySizeCache.class);
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final TransactionTemplate readOnlyTx;
    private final TransactionTemplate readWriteTx;
    private final RepositoryLock repositoryLock;
    private final RepositorySizeDao repositorySizeDao;
    private final ScmService scmService;
    @DurationUnit(value=ChronoUnit.MINUTES)
    @Value(value="${repository.size.cache.update.interval}")
    private Duration cacheUpdateInterval;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${repository.size.timeout}")
    private Duration repositorySizeTimeout;

    @Autowired
    public DefaultRepositorySizeCache(EventPublisher eventPublisher, ExecutorService executorService, LockService lockService, RepositorySizeDao repositorySizeDao, ScmService scmService, PlatformTransactionManager transactionManager) {
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.repositorySizeDao = repositorySizeDao;
        this.scmService = scmService;
        this.repositoryLock = lockService.getRepositoryLock(RepositorySizeCache.class.getCanonicalName());
        this.readOnlyTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.readWriteTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @VisibleForTesting
    protected DefaultRepositorySizeCache(EventPublisher eventPublisher, ExecutorService executorService, Duration cacheUpdateInterval, LockService lockService, RepositorySizeDao repositorySizeDao, Duration repositorySizeTimeout, ScmService scmService, PlatformTransactionManager transactionManager) {
        this(eventPublisher, executorService, lockService, repositorySizeDao, scmService, transactionManager);
        this.cacheUpdateInterval = cacheUpdateInterval;
        this.repositorySizeTimeout = repositorySizeTimeout;
    }

    public void bulkRefresh(@Nonnull List<Repository> repositories) {
        HashMap repositorySizes = new HashMap();
        for (Repository repository : repositories) {
            ((Optional)this.repositoryLock.withLock(repository, () -> this.updateSize(repository))).ifPresent(rs -> repositorySizes.put(repository.getId(), rs.getTotal()));
        }
        if (!repositorySizes.isEmpty()) {
            this.eventPublisher.publish((Object)new DmzRepositorySizesCalculatedEvent((Object)this, repositorySizes));
        }
    }

    public InternalRepositorySize get(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return (InternalRepositorySize)this.readOnlyTx.execute(status -> (InternalRepositorySize)this.repositorySizeDao.getById((Object)repository.getId()));
    }

    public long getOrRefresh(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        InternalRepositorySize internalRepositorySize = this.get(repository);
        if (internalRepositorySize == null) {
            return this.maybeRefresh(repository);
        }
        return internalRepositorySize.getTotal();
    }

    public long maybeRefresh(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return (Long)this.repositoryLock.withLock(repository, () -> (Long)this.readWriteTx.execute(status -> {
            InternalRepositorySize repositorySize = this.get(repository);
            if (this.needsRefresh(repositorySize)) {
                return this.refreshSingle(repository);
            }
            return repositorySize.getTotal();
        }));
    }

    @EventListener
    public void onRepositoryPushEvent(RepositoryPushEvent event) {
        if ("git".equals(event.getRepository().getScmId())) {
            return;
        }
        this.executorService.submit(() -> {
            Repository repository = event.getRepository();
            InternalRepositorySize repositorySize = this.get(repository);
            if (this.needsRefresh(repositorySize)) {
                this.maybeRefresh(repository);
            }
        });
    }

    public long refresh(@Nonnull Repository repository) {
        return (Long)this.repositoryLock.withLock(repository, () -> (Long)this.readWriteTx.execute(status -> this.refreshSingle(repository)));
    }

    public void updateSize(@Nonnull Repository repository, @Nonnull RepositorySize repositorySize) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(repositorySize, "repositorySize");
        log.trace("{}: Updating size to {}", (Object)repository, (Object)repositorySize.getTotal());
        this.repositoryLock.withLock(repository, () -> (RepositorySize)this.readWriteTx.execute(status -> {
            this.eventPublisher.publish((Object)new DmzRepositorySizesCalculatedEvent((Object)this, (Map)ImmutableMap.of((Object)repository.getId(), (Object)repositorySize.getTotal())));
            return this.save(repository, repositorySize);
        }));
    }

    private boolean needsRefresh(InternalRepositorySize repositorySize) {
        return repositorySize == null || !repositorySize.isUpdatedSince(Instant.now().minus(this.cacheUpdateInterval));
    }

    private long refreshSingle(Repository repository) {
        log.trace("{}: Refreshing size", (Object)repository);
        return this.updateSize(repository).map(rs -> {
            long size = rs.getTotal();
            this.eventPublisher.publish((Object)new DmzRepositorySizesCalculatedEvent((Object)this, (Map)ImmutableMap.of((Object)repository.getId(), (Object)size)));
            return size;
        }).orElse(0L);
    }

    private RepositorySize save(Repository repository, RepositorySize repositorySize) {
        InternalRepositorySize internalRepositorySize = new InternalRepositorySize.Builder((Repository)InternalConverter.convertToInternalRepository((Repository)repository)).totalSize(repositorySize.getTotal()).build();
        return (RepositorySize)this.repositorySizeDao.update((Object)internalRepositorySize);
    }

    private Optional<RepositorySize> updateSize(Repository repository) {
        try {
            Command command = this.scmService.getCommandFactory(repository).repositorySize(repository, new RepositorySizeCommandParameters.Builder().build());
            command.setTimeout(this.repositorySizeTimeout);
            return Optional.ofNullable((RepositorySize)command.call()).map(rs -> this.save(repository, (RepositorySize)rs));
        }
        catch (RuntimeException e) {
            log.warn("{}: Size calculation failed", (Object)repository, (Object)e);
            return Optional.empty();
        }
    }
}

