/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.RewriteExceptions;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryAlias;
import com.atlassian.stash.internal.repository.RepositoryAliasDao;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.user.InternalPermissionService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.transaction.annotation.Transactional;

@RewriteExceptions
public class DefaultRepositorySupplier
extends AbstractService
implements RepositorySupplier {
    protected final RepositoryAliasDao aliasDao;
    protected final I18nService i18nService;
    protected final InternalPermissionService permissionService;
    protected final RepositoryDao repositoryDao;

    public DefaultRepositorySupplier(I18nService i18nService, RepositoryAliasDao aliasDao, InternalPermissionService permissionService, RepositoryDao repositoryDao) {
        this.aliasDao = aliasDao;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.repositoryDao = repositoryDao;
    }

    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    public InternalRepository getById(int id) {
        return (InternalRepository)this.repositoryDao.getById((Object)id);
    }

    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    @Transactional(readOnly=true, noRollbackFor={RepositoryMovedException.class})
    public InternalRepository getBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        InternalRepositoryAlias alias;
        Objects.requireNonNull(projectKey, "projectKey");
        Objects.requireNonNull(slug, "slug");
        InternalRepository repository = this.repositoryDao.getBySlug(projectKey, slug);
        if (repository == null && (alias = this.aliasDao.getBySlug(projectKey, slug)) != null && this.permissionService.isRepositoryAccessible((Repository)(repository = alias.getRepository()))) {
            throw new RepositoryMovedException((Repository)repository, projectKey, slug, this.i18nService.createKeyedMessage("bitbucket.repository.moved", new Object[]{this.getRepositoryLocation(repository)}));
        }
        return repository;
    }

    private String getRepositoryLocation(InternalRepository repository) {
        return repository.getProject().getKey() + "/" + repository.getSlug();
    }
}

