/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.MetadataMap;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataContext;
import com.atlassian.bitbucket.repository.SimpleMetadataMap;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.plugin.RefMetadataProviderModuleDescriptor;
import com.atlassian.stash.internal.repository.RefMetadataMapProvider;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="refMetadataMapProvider")
public class PluginRefMetadataMapProvider
implements RefMetadataMapProvider {
    private static final Logger log = LoggerFactory.getLogger(PluginRefMetadataMapProvider.class);
    private final ExecutorService executorService;
    private final PluginAccessor pluginAccessor;
    private int timeout;

    @Autowired
    public PluginRefMetadataMapProvider(ExecutorService executorService, PluginAccessor pluginAccessor) {
        this.executorService = executorService;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public Map<Ref, MetadataMap> getMetadata(@Nonnull RefMetadataContext context) {
        HashMap builders = Maps.newHashMap();
        for (ModuleMetadata promisedMetadata : this.getModuleMetadata(context)) {
            try {
                this.collectMetadata(builders, promisedMetadata.getDescriptor(), promisedMetadata.getFuture().get());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException ignored) {
                log.info("Timed out when retrieving ref metadata for {}", (Object)promisedMetadata.getDescriptor().getCompleteKey());
            }
            catch (ExecutionException e) {
                Throwables.propagateIfInstanceOf((Throwable)e.getCause(), Error.class);
                log.warn("Failed to retrieve ref metadata for {}", (Object)promisedMetadata.getDescriptor().getCompleteKey(), (Object)e.getCause());
            }
        }
        return this.buildMetadataMaps(builders);
    }

    @Value(value="${ref.metadata.timeout}")
    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private Map<Ref, MetadataMap> buildMetadataMaps(Map<Ref, ImmutableMap.Builder<String, Object>> builders) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(builders, builder -> new SimpleMetadataMap((Map)builder.build())));
    }

    private void collectMetadata(Map<Ref, ImmutableMap.Builder<String, Object>> builders, RefMetadataProviderModuleDescriptor descriptor, Map<Ref, ?> metadata) {
        metadata.forEach((key, value) -> {
            ImmutableMap.Builder builder = builders.computeIfAbsent((Ref)key, k -> ImmutableMap.builder());
            builder.put((Object)descriptor.getCompleteKey(), value);
        });
    }

    private List<Callable<Map<Ref, ?>>> createCallables(List<RefMetadataProviderModuleDescriptor> descriptors, RefMetadataContext context) {
        return descriptors.stream().map(descriptor -> () -> {
            try (Timer ignored = TimerUtils.start((String)String.format("Ref metadata [%s]", descriptor.getCompleteKey()));){
                Map metadata = descriptor.getModule().getMetadata(context);
                Map map = metadata == null ? Collections.emptyMap() : Maps.filterValues((Map)Maps.filterKeys((Map)metadata, (Predicate)Predicates.notNull()), (Predicate)Predicates.notNull());
                return map;
            }
        }).collect(Collectors.toList());
    }

    private Iterable<ModuleMetadata> getModuleMetadata(RefMetadataContext context) {
        Iterator<Future<Map<Ref, ?>>> futures;
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(RefMetadataProviderModuleDescriptor.class);
        try {
            futures = this.executorService.invokeAll(this.createCallables(descriptors, context), this.timeout, TimeUnit.SECONDS).iterator();
        }
        catch (InterruptedException ignored) {
            return Collections.emptySet();
        }
        ArrayList<ModuleMetadata> moduleMetadata = new ArrayList<ModuleMetadata>(descriptors.size());
        for (RefMetadataProviderModuleDescriptor descriptor : descriptors) {
            moduleMetadata.add(new ModuleMetadata(descriptor, futures.next()));
        }
        return moduleMetadata;
    }

    static class ModuleMetadata {
        private final RefMetadataProviderModuleDescriptor descriptor;
        private final Future<Map<Ref, ?>> future;

        ModuleMetadata(RefMetadataProviderModuleDescriptor descriptor, Future<Map<Ref, ?>> future) {
            this.descriptor = descriptor;
            this.future = future;
        }

        RefMetadataProviderModuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        Future<Map<Ref, ?>> getFuture() {
            return this.future;
        }
    }
}

