/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositorySizeCache;
import com.atlassian.stash.internal.repository.RepositorySizeDao;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
@DefaultApplicationMode
@UpgradeTask(value="core-backfill-repo-size")
public class RepositorySizeBackfillJob
implements ScheduledJobSource {
    public static final String KEY_TASK = "core-backfill-repo-size";
    private static final Logger log = LoggerFactory.getLogger(RepositorySizeBackfillJob.class);
    private static final JobId JOB_ID = JobId.of((String)RepositorySizeBackfillJobRunner.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)RepositorySizeBackfillJobRunner.class.getName());
    private final LockService lockService;
    private final RepositorySizeBackfillProgress progress;
    private final RepositorySizeCache repositorySizeCache;
    private final RepositorySizeDao repositorySizeDao;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${repository.size.backfill.initial.delay}")
    private Duration initialDelay;
    @Value(value="${repository.size.backfill.batch.size}")
    private int repositoryBatchSize;

    @Autowired
    public RepositorySizeBackfillJob(HomeLayout homeLayout, LockService lockService, RepositorySizeCache repositorySizeCache, RepositorySizeDao repositorySizeDao, SecurityService securityService, PlatformTransactionManager transactionManager) {
        this.lockService = lockService;
        this.repositorySizeCache = repositorySizeCache;
        this.repositorySizeDao = repositorySizeDao;
        this.securityService = securityService;
        this.progress = new RepositorySizeBackfillProgress(homeLayout);
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    @VisibleForTesting
    protected RepositorySizeBackfillJob(Duration initialDelay, int repositoryBatchSize, HomeLayout homeLayout, LockService lockService, RepositorySizeCache repositorySizeCache, RepositorySizeDao repositorySizeDao, SecurityService securityService, PlatformTransactionManager transactionManager) {
        this(homeLayout, lockService, repositorySizeCache, repositorySizeDao, securityService, transactionManager);
        this.initialDelay = initialDelay;
        this.repositoryBatchSize = repositoryBatchSize;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        if (this.progress.isComplete()) {
            log.debug("Backfilling of repository size cache is already complete, job wil not be scheduled");
            return;
        }
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new RepositorySizeBackfillJobRunner());
        Date startTime = Date.from(Instant.now().plus(this.initialDelay));
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)startTime)));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private static class RepositorySizeBackfillProgress {
        private static final int PROGRESS_COMPLETED = -1;
        private static final int PROGRESS_NOT_STARTED = Integer.MIN_VALUE;
        private static final int PROGRESS_STARTED = 0;
        private final Path progressMarker;

        private RepositorySizeBackfillProgress(HomeLayout homeLayout) {
            this.progressMarker = homeLayout.getUpgradesDir().resolve(RepositorySizeBackfillJob.KEY_TASK);
        }

        public void complete() {
            this.update(-1);
        }

        public int get() {
            if (!Files.exists(this.progressMarker, new LinkOption[0])) {
                return Integer.MIN_VALUE;
            }
            String progress = this.readFromFile();
            if (StringUtils.isEmpty((CharSequence)progress)) {
                return Integer.MIN_VALUE;
            }
            return Integer.parseInt(progress);
        }

        public boolean isComplete() {
            return this.get() == -1;
        }

        public boolean isStarted() {
            return this.get() == 0;
        }

        public void start() {
            if (Integer.MIN_VALUE == this.get()) {
                MoreFiles.mkdir((Path)this.progressMarker.getParent());
                this.update(0);
            }
        }

        public void update(int progress) {
            this.writeToFile(String.valueOf(progress));
        }

        private String readFromFile() {
            try {
                return MoreFiles.toString((Path)this.progressMarker);
            }
            catch (IOException e) {
                log.error("Error while reading progress marker file {}", (Object)this.progressMarker, (Object)e);
                throw new UncheckedIOException(e);
            }
        }

        private void writeToFile(String value) {
            try {
                MoreFiles.write((Path)this.progressMarker, (String)value, (OpenOption[])new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private class RepositorySizeBackfillJobRunner
    implements JobRunner {
        private RepositorySizeBackfillJobRunner() {
        }

        @Nonnull
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            Objects.requireNonNull(request, "request");
            try {
                if (RepositorySizeBackfillJob.this.progress.isComplete()) {
                    log.debug("Backfilling of repository size cache is complete, skipping job execution");
                } else {
                    this.doRunJob();
                }
                return JobRunnerResponse.success();
            }
            catch (RuntimeException e) {
                log.error("An exception was encountered while backfilling repository size cache, it will be re-attempted on next application startup", (Throwable)e);
                return JobRunnerResponse.failed((Throwable)e);
            }
        }

        private void doRunJob() {
            try (LockGuard guard = LockGuard.tryLock((Lock)RepositorySizeBackfillJob.this.lockService.getLock(RepositorySizeBackfillJob.KEY_TASK));){
                if (guard == null) {
                    log.debug("Lock could not be acquired, skipping backfill of repository size cache");
                    return;
                }
                log.trace("Acquired lock to perform backfilling of repository size cache");
                if (RepositorySizeBackfillJob.this.progress.isComplete()) {
                    log.debug("Backfilling of repository size cache is already complete");
                    return;
                }
                RepositorySizeBackfillJob.this.progress.start();
                log.debug("Starting backfilling of repository size cache");
                RepositorySizeBackfillJob.this.securityService.withPermission(Permission.ADMIN, "Backfill repository size cache").call(() -> {
                    Page<InternalRepository> repositoryPage;
                    do {
                        repositoryPage = this.refreshRepositories();
                        log.debug("Updated repository size cache for {} repositories", (Object)repositoryPage.getSize());
                    } while (!repositoryPage.getIsLastPage());
                    return null;
                });
                RepositorySizeBackfillJob.this.progress.complete();
                log.debug("Completed backfilling of repository size cache");
            }
        }

        private Page<InternalRepository> refreshRepositories() {
            return (Page)RepositorySizeBackfillJob.this.transactionTemplate.execute(status -> {
                PageRequest pageRequest = PageUtils.newRequest((int)0, (int)RepositorySizeBackfillJob.this.repositoryBatchSize);
                Page repositoryPage = RepositorySizeBackfillJob.this.repositorySizeDao.findRepositoriesWithoutSize(RepositorySizeBackfillJob.this.progress.get(), pageRequest);
                if (repositoryPage.getSize() > 0) {
                    ImmutableList repositories = ImmutableList.copyOf((Iterable)repositoryPage.getValues());
                    RepositorySizeBackfillJob.this.repositorySizeCache.bulkRefresh((List)repositories);
                    RepositorySizeBackfillJob.this.progress.update(((Repository)repositories.get(repositories.size() - 1)).getId());
                }
                return repositoryPage;
            });
        }
    }
}

