/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.atst.SupportDataConstraints;
import com.atlassian.stash.internal.atst.SupportDataHelper;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="repositorySupportData")
public class RepositorySupportData
implements SupportDataAppender<Project> {
    public static final String REPOSITORIES = "bitbucket.atst.repositories";
    private static final String REPOSITORY = "bitbucket.atst.repository";
    private static final String REPOSITORY_ID = "bitbucket.atst.repository.id";
    private static final String REPOSITORY_IS_AVAILABLE = "bitbucket.atst.repository.is.available";
    private static final String REPOSITORY_IS_FORK = "bitbucket.atst.repository.is.fork";
    private static final String REPOSITORY_IS_PUBLIC = "bitbucket.atst.repository.is.public";
    private static final String REPOSITORY_IS_REMOTE = "bitbucket.atst.repository.is.remote";
    private static final String REPOSITORY_MARKED_AS_PUBLIC = "bitbucket.atst.repository.marked.public";
    private static final String REPOSITORY_NAME = "bitbucket.atst.repository.name";
    private static final String REPOSITORY_ORIGIN = "bitbucket.atst.repository.origin";
    private static final String REPOSITORY_PARTITION = "bitbucket.atst.repository.partition";
    private static final String REPOSITORY_SIZE = "bitbucket.atst.repository.size";
    private static final String REPOSITORY_SKIPPED = "bitbucket.atst.skipped";
    private static final String REPOSITORY_SLUG = "bitbucket.atst.repository.slug";
    private static final String REPOSITORY_STATE = "bitbucket.atst.repository.state";
    private static final String REPOSITORY_STATUS_MESSAGE = "bitbucket.atst.repository.status-message";
    private static final String REPOSITORY_TYPE = "bitbucket.atst.repository.type";
    private static final String PROP_PREFIX = "atst.repository.report.";
    private static final String PROP_INCLUDE_CONTEXT = "${atst.repository.report.context}";
    private static final String PROP_INCLUDE_SIZE = "${atst.repository.report.size}";
    private final boolean includeContext;
    private final boolean includeSize;
    private final PermissionService permissionService;
    private final RepositoryService repositoryService;
    private final SupportDataHelper supportDataHelper;

    @Autowired
    public RepositorySupportData(PermissionService permissionService, RepositoryService repositoryService, SupportDataHelper supportDataHelper, @Value(value="${atst.repository.report.context}") boolean includeContext, @Value(value="${atst.repository.report.size}") boolean includeSize) {
        this.includeContext = includeContext;
        this.includeSize = includeSize;
        this.permissionService = permissionService;
        this.repositoryService = repositoryService;
        this.supportDataHelper = supportDataHelper;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Project project) {
        SupportDataConstraints constraints = this.supportDataHelper.getConstraints(supportDataBuilder.getBuilderContext());
        boolean warnOnSkip = false;
        for (Repository repository : this.getRepositories(project)) {
            SupportDataBuilder repoBuilder = supportDataBuilder.addCategory(REPOSITORY).addValue(REPOSITORY_ID, Integer.toString(repository.getId())).addValue(REPOSITORY_SLUG, repository.getSlug());
            if (constraints.addRepository()) {
                this.addRepositoryDetails(repoBuilder, repository);
                warnOnSkip = true;
                continue;
            }
            repoBuilder.addValue(REPOSITORY_SKIPPED, Boolean.TRUE.toString());
            if (!warnOnSkip) continue;
            LoggerFactory.getLogger(this.getClass()).warn("Further project and repository details will be omitted due to configured constraints");
            warnOnSkip = false;
        }
    }

    private void addOrigins(SupportDataBuilder builder, Repository origin) {
        while (origin != null) {
            builder = builder.addCategory(REPOSITORY_ORIGIN).addValue("bitbucket.atst.project.key", origin.getProject().getKey()).addValue(REPOSITORY_SLUG, origin.getSlug()).addValue(REPOSITORY_IS_FORK, Boolean.toString(origin.isFork()));
            origin = origin.getOrigin();
        }
    }

    private void addRepositoryDetails(SupportDataBuilder repoBuilder, Repository repository) {
        repoBuilder.addValue(REPOSITORY_NAME, repository.getName()).addValue(REPOSITORY_TYPE, repository.getScmId()).addValue(REPOSITORY_SIZE, this.includeSize ? this.sizeOf(repository) : "Unknown").addValue(REPOSITORY_STATE, repository.getState().toString()).addValue(REPOSITORY_STATUS_MESSAGE, repository.getStatusMessage()).addValue(REPOSITORY_MARKED_AS_PUBLIC, Boolean.toString(repository.isPublic())).addValue(REPOSITORY_IS_PUBLIC, Boolean.toString(this.permissionService.isPubliclyAccessible(repository))).addValue(REPOSITORY_IS_FORK, Boolean.toString(repository.isFork()));
        this.addRemoteRepositoryDetails(repoBuilder, repository);
        this.addOrigins(repoBuilder, repository.getOrigin());
        if (this.includeContext) {
            repoBuilder.addContext((Object)repository);
        } else {
            repoBuilder.addValue(REPOSITORY_SKIPPED, Boolean.TRUE.toString());
        }
    }

    private void addRemoteRepositoryDetails(SupportDataBuilder repoBuilder, Repository repository) {
        if (repository instanceof DmzRepository) {
            DmzRepository dmzRepo = (DmzRepository)repository;
            repoBuilder.addValue(REPOSITORY_IS_REMOTE, Boolean.toString(dmzRepo.isRemote())).addValue(REPOSITORY_PARTITION, Integer.toString(dmzRepo.getPartition())).addValue(REPOSITORY_IS_AVAILABLE, String.valueOf(!dmzRepo.isOffline()));
        } else {
            repoBuilder.addValue(REPOSITORY_IS_REMOTE, Boolean.toString(false));
        }
    }

    private Iterable<Repository> getRepositories(Project project) {
        String key = project.getKey();
        return new PagedIterable(pageRequest -> this.repositoryService.findByProjectKey(key, pageRequest), 500);
    }

    private String sizeOf(Repository repository) {
        return NumberUtils.formatSize((double)this.repositoryService.getSize(repository));
    }
}

