/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.bitbucket.dmz.request.DmzRequestContext;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.request.DefaultRequestLocal;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRequestContext
implements DmzRequestContext {
    private static final CallbackRegistry IMMEDIATE_REGISTRY = new CallbackRegistry(){

        @Override
        public void register(Runnable callback) {
            CallbackRegistry.run(callback);
        }

        @Override
        public void run() {
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestContext.class);
    private final RequestInfoProvider delegate;
    private final String id;
    private final SortedSet<String> labels;
    private final ConcurrentMap<DefaultRequestLocal<?>, Object> localValues;
    private final Map<Long, CallbackRegistry> registriesByThread;
    private final long start;
    private final TransferableStateManager transferableStateManager;
    private volatile boolean active;
    private volatile ApplicationUser authenticatedUser;
    private volatile long bytesRead;
    private volatile long bytesWritten;
    private volatile Duration duration;
    private volatile int responseCode;

    DefaultRequestContext(RequestInfoProvider delegate, String id, TransferableStateManager transferableStateManager) {
        this.delegate = delegate;
        this.id = id;
        this.transferableStateManager = transferableStateManager;
        this.active = true;
        this.labels = new TreeSet<String>();
        this.localValues = new ConcurrentHashMap();
        this.registriesByThread = new ConcurrentHashMap<Long, CallbackRegistry>();
        this.start = System.currentTimeMillis();
    }

    public void addCleanupCallback(@Nonnull Runnable callback) {
        this.registriesByThread.computeIfAbsent(Thread.currentThread().getId(), id -> new DefaultCallbackRegistry()).register(callback);
    }

    public void addLabel(@Nonnull String label) {
        this.labels.add(label);
    }

    @Nonnull
    public String getAction() {
        return this.delegate.getAction();
    }

    @Nonnull
    public Optional<ApplicationUser> getAuthenticatedUser() {
        return Optional.ofNullable(this.authenticatedUser);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public String getDetails() {
        return this.delegate.getDetails();
    }

    @Nonnull
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    @Nonnull
    public Object getRawRequest() {
        return this.delegate.getRawRequest();
    }

    @Nonnull
    public Object getRawResponse() {
        return this.delegate.getRawResponse();
    }

    public String getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    public String getSessionId() {
        return this.delegate.getSessionId();
    }

    public boolean hasSessionId() {
        return this.delegate.hasSessionId();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public void setAuthenticatedUser(@Nonnull ApplicationUser user) {
        this.authenticatedUser = Objects.requireNonNull(user, "user");
    }

    public void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Nonnull
    public <T> Callable<T> wrap(@Nonnull Callable<T> callable) {
        Objects.requireNonNull(callable, "callable");
        return this.transferableStateManager.wrap(callable);
    }

    @Nonnull
    public Runnable wrap(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        return this.transferableStateManager.wrap(runnable);
    }

    void cleanThread() {
        this.registriesByThread.compute(Thread.currentThread().getId(), (id, registry) -> {
            if (registry != null) {
                registry.run();
            }
            return IMMEDIATE_REGISTRY;
        });
    }

    @Nonnull
    ConcurrentMap<DefaultRequestLocal<?>, Object> getRequestLocalValues() {
        return this.localValues;
    }

    void finish() {
        this.localValues.forEach(DefaultRequestLocal::cleanup);
        this.cleanThread();
        this.active = false;
    }

    @Nonnull
    String getLabels() {
        return StringUtils.join(this.labels, (String)", ").replace("|", "\\|");
    }

    long getRequestTime() {
        return System.currentTimeMillis() - this.start;
    }

    int getResponseCode() {
        return this.responseCode;
    }

    void setDuration(@Nonnull Duration duration) {
        this.duration = Objects.requireNonNull(duration, "duration");
    }

    private static interface CallbackRegistry {
        public void register(Runnable var1);

        public void run();

        public static void run(Runnable callback) {
            try {
                callback.run();
            }
            catch (Exception e) {
                log.warn("Request cleanup callback failed", (Throwable)e);
            }
        }
    }

    private class DefaultCallbackRegistry
    implements CallbackRegistry {
        private final List<Runnable> callbacks = new ArrayList<Runnable>();

        DefaultCallbackRegistry() {
        }

        @Override
        public void register(Runnable callback) {
            this.callbacks.add(DefaultRequestContext.this.transferableStateManager.wrap(callback));
        }

        @Override
        public void run() {
            this.callbacks.forEach(CallbackRegistry::run);
        }
    }
}

