/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.bitbucket.request.RequestLocal;
import com.atlassian.stash.internal.request.DefaultRequestManager;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRequestLocal<T>
implements RequestLocal<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestLocal.class);
    private final Consumer<T> cleanupCallback;
    private final DefaultRequestManager requestManager;

    DefaultRequestLocal(DefaultRequestManager requestManager, Consumer<T> cleanupCallback) {
        this.cleanupCallback = cleanupCallback;
        this.requestManager = requestManager;
    }

    public T compute(@Nonnull Function<? super T, ? extends T> mappingFunction) {
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        if (localValuesMap != null) {
            return (T)localValuesMap.compute(this, (ignored, value) -> mappingFunction.apply(value));
        }
        return mappingFunction.apply(null);
    }

    public T computeIfAbsent(@Nonnull Supplier<? extends T> missingValueSupplier) {
        Objects.requireNonNull(missingValueSupplier, "missingValueSupplier");
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        if (localValuesMap != null) {
            return (T)localValuesMap.compute(this, (ignored, value) -> value == null ? missingValueSupplier.get() : value);
        }
        return missingValueSupplier.get();
    }

    public T get() {
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        if (localValuesMap != null) {
            return (T)localValuesMap.get(this);
        }
        return null;
    }

    public void ifPresent(@Nonnull Consumer<? super T> consumer) {
        Object localValue;
        Objects.requireNonNull(consumer, "consumer");
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        if (localValuesMap != null && (localValue = localValuesMap.get(this)) != null) {
            consumer.accept(localValue);
        }
    }

    public boolean isActive() {
        return this.getLocalValuesMap() != null;
    }

    public boolean isPresent() {
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        return localValuesMap != null && localValuesMap.get(this) != null;
    }

    public T remove() {
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        if (localValuesMap == null) {
            return null;
        }
        return (T)localValuesMap.remove(this);
    }

    public T removeIf(@Nonnull Predicate<? super T> predicate) {
        Object value;
        Objects.requireNonNull(predicate, "predicate");
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        if (localValuesMap == null) {
            return null;
        }
        for (int i = 0; i < 3 && (value = localValuesMap.get(this)) != null && predicate.test(value); ++i) {
            if (!localValuesMap.remove(this, value)) continue;
            return (T)value;
        }
        return null;
    }

    public boolean set(T value) {
        ConcurrentMap<DefaultRequestLocal<?>, Object> localValuesMap = this.getLocalValuesMap();
        if (localValuesMap != null) {
            if (value == null) {
                localValuesMap.remove(this);
            } else {
                localValuesMap.put(this, value);
            }
            return true;
        }
        return false;
    }

    void cleanup(Object value) {
        if (this.cleanupCallback != null && value != null) {
            try {
                this.cleanupCallback.accept(value);
            }
            catch (RuntimeException e) {
                log.warn("RequestLocal cleanup listener {} threw an exception", (Object)this.cleanupCallback.getClass().getName(), (Object)e);
            }
        }
    }

    private ConcurrentMap<DefaultRequestLocal<?>, Object> getLocalValuesMap() {
        return this.requestManager.getRequestLocalValues();
    }
}

