/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.event.cluster.ClusterMembershipEvent;
import com.atlassian.bitbucket.event.request.RequestEndedEvent;
import com.atlassian.bitbucket.event.request.RequestStartedEvent;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.request.RequestLocal;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.web.AsyncListenerSupport;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.logback.LoggingConstants;
import com.atlassian.stash.internal.request.DefaultRequestContext;
import com.atlassian.stash.internal.request.DefaultRequestLocal;
import com.atlassian.stash.internal.request.ImmutableRequestMetadata;
import com.atlassian.stash.internal.request.InternalRequestManager;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=RequestManager.class)
@Component(value="requestManager")
public class DefaultRequestManager
implements InternalRequestManager,
StatefulService {
    private static final Logger accessLog = LoggerFactory.getLogger((String)LoggingConstants.LOGGER_ACCESS);
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestManager.class);
    private final AuthenticationContext authenticationContext;
    private final Clock clock;
    private final AtomicLong concurrentCounter;
    private final AtomicLong requestCounter;
    private final EventPublisher eventPublisher;
    private final ThreadLocal<DefaultRequestContext> currentRequestContext;
    private final ThreadLocal<RequestTransferableState> requestTransferableState;
    private final TransferableStateManager transferableStateManager;
    private volatile boolean clustered;
    private String nodeId;

    @Autowired
    public DefaultRequestManager(AuthenticationContext authenticationContext, Clock clock, EventPublisher eventPublisher, TransferableStateManager transferableStateManager) {
        this.authenticationContext = authenticationContext;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.transferableStateManager = transferableStateManager;
        this.concurrentCounter = new AtomicLong(0L);
        this.currentRequestContext = new ThreadLocal();
        this.requestCounter = new AtomicLong(0L);
        this.requestTransferableState = new ThreadLocal();
    }

    public <T, E extends Exception> T doAsRequest(@Nonnull RequestCallback<T, E> callback, @Nonnull RequestInfoProvider requestInfoProvider) throws E {
        if (this.currentRequestContext.get() == null) {
            DefaultRequestContext requestContext = new DefaultRequestContext(requestInfoProvider, this.generateRequestId(), this.transferableStateManager);
            try {
                Object object;
                block10: {
                    Ticker ignored = Timers.start((String)requestContext.getAction());
                    try {
                        this.concurrentCounter.incrementAndGet();
                        this.currentRequestContext.set(requestContext);
                        this.logStartRequest(requestContext);
                        this.eventPublisher.publish((Object)new RequestStartedEvent((Object)this, (RequestContext)requestContext));
                        object = callback.withRequest((RequestContext)requestContext);
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return (T)object;
            }
            finally {
                this.afterRequest(requestContext);
            }
        }
        return (T)callback.withRequest((RequestContext)this.currentRequestContext.get());
    }

    public DefaultRequestContext getRequestContext() {
        return this.currentRequestContext.get();
    }

    public String getRequestId() {
        RequestTransferableState state = this.requestTransferableState.get();
        if (state == null) {
            DefaultRequestContext context = this.getRequestContext();
            return context == null ? null : context.getId();
        }
        return state.requestId;
    }

    public RequestMetadata getRequestMetadata() {
        RequestTransferableState state = this.requestTransferableState.get();
        if (state == null) {
            return this.getRequestContext();
        }
        return state.metadata;
    }

    @Nonnull
    public TransferableState getState() {
        RequestTransferableState state = this.requestTransferableState.get();
        return state == null ? new RequestTransferableState((RequestContext)this.getRequestContext()) : state;
    }

    @Nonnull
    public <T> RequestLocal<T> newRequestLocal() {
        return new DefaultRequestLocal(this, null);
    }

    @Nonnull
    public <T> RequestLocal<T> newRequestLocal(Consumer<T> cleanupCallback) {
        return new DefaultRequestLocal<T>(this, cleanupCallback);
    }

    @EventListener
    public void onClusterMembershipChanged(ClusterMembershipEvent event) {
        this.clustered = event.getCurrentNodes().size() > 1;
    }

    @Autowired
    public void setClusterService(ClusterService clusterService) {
        this.clustered = clusterService.isClustered();
        this.nodeId = DefaultRequestManager.hashNodeId(clusterService.getNodeId());
    }

    @Nonnull
    public Runnable wrapForAsync(@Nonnull Runnable runnable) {
        DefaultRequestContext requestContext = this.currentRequestContext.get();
        if (requestContext == null) {
            return runnable;
        }
        return () -> {
            this.currentRequestContext.set(requestContext);
            try (Ticker ignored = Timers.start((String)("async: " + requestContext.getAction()));){
                runnable.run();
            }
            finally {
                requestContext.cleanThread();
                this.currentRequestContext.remove();
            }
        };
    }

    @Nullable
    ConcurrentMap<DefaultRequestLocal<?>, Object> getRequestLocalValues() {
        RequestTransferableState state = this.requestTransferableState.get();
        if (state == null) {
            DefaultRequestContext context = this.getRequestContext();
            return context == null ? null : context.getRequestLocalValues();
        }
        return state.localValues;
    }

    private static String hashNodeId(String clusterNodeId) {
        CRC32 crc = new CRC32();
        crc.update(DigestUtils.sha1((String)clusterNodeId));
        return Long.toString(crc.getValue(), 36).toUpperCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterRequest(DefaultRequestContext requestContext) {
        HttpServletRequest request;
        this.currentRequestContext.remove();
        Object rawRequest = requestContext.getRawRequest();
        if (rawRequest instanceof HttpServletRequest && (request = (HttpServletRequest)rawRequest).isAsyncStarted()) {
            request.getAsyncContext().addListener((AsyncListener)new RequestAsyncListener(requestContext));
            requestContext.cleanThread();
            MDC.clear();
            return;
        }
        try {
            this.wrapUpRequest(requestContext);
        }
        finally {
            MDC.clear();
        }
    }

    private void checkStaleMDCUsername() {
        String username;
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null && (username = MDC.get((String)"a-username")) != null) {
            log.debug("No current user for the current request but MDC contains a request username: {}", (Object)username);
            MDC.remove((String)"a-username");
        }
    }

    private String generateRequestId() {
        long count = this.requestCounter.incrementAndGet();
        ZonedDateTime now = ZonedDateTime.ofInstant(this.clock.instant(), ZoneId.systemDefault());
        int minuteOfDay = now.getHour() * 60 + now.getMinute();
        return (this.clustered ? "*" : "@") + this.nodeId + "x" + minuteOfDay + "x" + count + "x" + this.concurrentCounter.get();
    }

    private void logEndRequest(DefaultRequestContext requestContext, long requestTime) {
        this.setupMdc(requestContext);
        MDC.put((String)"a-request-bytes-read", (String)Long.toString(requestContext.getBytesRead()));
        MDC.put((String)"a-request-labels", (String)requestContext.getLabels());
        MDC.put((String)"a-request-time", (String)Long.toString(requestTime));
        MDC.put((String)"a-response-bytes-written", (String)Long.toString(requestContext.getBytesWritten()));
        MDC.put((String)"a-status-code", (String)Integer.toString(requestContext.getResponseCode()));
        accessLog.info("o");
        requestContext.setDuration(Duration.ofMillis(requestTime));
    }

    private void logStartRequest(DefaultRequestContext requestContext) {
        this.checkStaleMDCUsername();
        this.setupMdc(requestContext);
        accessLog.info("i");
    }

    private void setupMdc(DefaultRequestContext requestContext) {
        MDC.put((String)"a-protocol", (String)requestContext.getProtocol());
        MDC.put((String)"a-remote-address", (String)requestContext.getRemoteAddress());
        MDC.put((String)"a-request-action", (String)requestContext.getAction());
        MDC.put((String)"a-request-details", (String)requestContext.getDetails());
        MDC.put((String)"a-request-id", (String)requestContext.getId());
        MDC.put((String)"a-session-id", (String)requestContext.getSessionId());
        ApplicationUser user = requestContext.getAuthenticatedUser().orElseGet(() -> ((AuthenticationContext)this.authenticationContext).getCurrentUser());
        if (user != null) {
            MDC.put((String)"a-username", (String)user.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapUpRequest(DefaultRequestContext requestContext) {
        this.concurrentCounter.decrementAndGet();
        try {
            this.logEndRequest(requestContext, requestContext.getRequestTime());
        }
        finally {
            try {
                this.eventPublisher.publish((Object)new RequestEndedEvent((Object)this, (RequestContext)requestContext));
            }
            finally {
                requestContext.finish();
            }
        }
    }

    private final class RequestTransferableState
    implements TransferableState {
        private final ConcurrentMap<DefaultRequestLocal<?>, Object> localValues;
        private final ImmutableRequestMetadata metadata;
        private final String requestId;

        private RequestTransferableState(RequestContext requestContext) {
            if (requestContext == null) {
                this.localValues = null;
                this.metadata = null;
                this.requestId = null;
            } else {
                this.localValues = requestContext instanceof DefaultRequestContext ? ((DefaultRequestContext)requestContext).getRequestLocalValues() : null;
                this.metadata = new ImmutableRequestMetadata((RequestMetadata)requestContext);
                this.requestId = requestContext.getId();
            }
        }

        public void apply() {
            DefaultRequestManager.this.requestTransferableState.set(this);
        }

        public void remove() {
            DefaultRequestManager.this.requestTransferableState.remove();
        }
    }

    private class RequestAsyncListener
    extends AsyncListenerSupport {
        private final DefaultRequestContext requestContext;
        private volatile boolean addLabel;

        RequestAsyncListener(DefaultRequestContext requestContext) {
            this.requestContext = requestContext;
            this.addLabel = true;
        }

        public void onComplete(AsyncEvent event) {
            if (this.addLabel) {
                this.requestContext.addLabel("async");
            }
            try {
                DefaultRequestManager.this.wrapUpRequest(this.requestContext);
            }
            finally {
                MDC.clear();
            }
        }

        public void onError(AsyncEvent event) {
            this.requestContext.addLabel("async:error");
            this.addLabel = false;
        }

        public void onTimeout(AsyncEvent event) {
            this.requestContext.addLabel("async:timeout");
            this.addLabel = false;
        }
    }
}

