/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.resilience;

import com.atlassian.bitbucket.dmz.resilience.CallNotAllowedException;
import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerConfiguration;
import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerMetrics;
import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.resilience.R4JApiWrapper;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import io.atlassian.util.concurrent.Suppliers;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(value=CircuitBreakerService.class)
public class DefaultCircuitBreakerService
implements CircuitBreakerService {
    private final R4JApiWrapper apiWrapper;

    @Autowired
    public DefaultCircuitBreakerService(R4JApiWrapper apiWrapper) {
        this.apiWrapper = apiWrapper;
    }

    public void addConfiguration(@Nonnull CircuitBreakerConfiguration configuration) {
        Objects.requireNonNull(configuration, "configuration");
        this.apiWrapper.createConfiguration(configuration);
    }

    @Nonnull
    public <T> Supplier<Promise<T>> decoratePromiseWithCircuitBreaker(@Nonnull String name, @Nonnull String configName, @Nonnull Supplier<Promise<T>> promiseSupplier) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(configName, "configName");
        Objects.requireNonNull(promiseSupplier, "promiseSupplier");
        Supplier<CompletionStage> completionStageSupplier = () -> Promises.toCompletableFuture((Promise)((Promise)promiseSupplier.get()));
        Supplier decoratedCompletionStageSupplier = this.apiWrapper.getOrCreateCircuitBreaker(name, configName).decorateCompletionStage(completionStageSupplier);
        return Suppliers.fromFunction((Object)((CompletionStage)decoratedCompletionStageSupplier.get()), stage -> Promises.forCompletionStage((CompletionStage)stage).recover(t -> {
            if (t instanceof CallNotPermittedException) {
                throw new CallNotAllowedException(t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException((Throwable)t);
        }));
    }

    @Nonnull
    public <T> Callable<T> decorateWithCircuitBreaker(@Nonnull String name, @Nonnull String configName, @Nonnull Callable<T> callable) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(configName, "configName");
        Objects.requireNonNull(callable, "callable");
        return () -> {
            try {
                return this.apiWrapper.getOrCreateCircuitBreaker(name, configName).decorateCallable(callable).call();
            }
            catch (CallNotPermittedException e) {
                throw new CallNotAllowedException((Throwable)e);
            }
        };
    }

    @Nonnull
    public List<CircuitBreakerMetrics> getCircuitBreakerMetrics() {
        return this.apiWrapper.getCircuitBreakers().stream().map(circuitBreaker -> {
            CircuitBreaker.Metrics metrics = circuitBreaker.getMetrics();
            return new CircuitBreakerMetrics(circuitBreaker.getName(), circuitBreaker.getState().toString(), metrics.getFailureRate(), metrics.getNumberOfBufferedCalls(), metrics.getNumberOfFailedCalls(), metrics.getNumberOfNotPermittedCalls(), metrics.getNumberOfSlowCalls(), metrics.getNumberOfSlowFailedCalls(), metrics.getNumberOfSlowSuccessfulCalls(), metrics.getNumberOfSuccessfulCalls(), metrics.getSlowCallRate());
        }).collect(Collectors.toList());
    }

    @Nonnull
    public Optional<CircuitBreakerConfiguration> getConfiguration(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        return this.apiWrapper.getConfiguration(name);
    }
}

